/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function (Drupal, Backbone) {
  Drupal.contextual.StateModel = Backbone.Model.extend({
    defaults: {
      title: '',
      regionIsHovered: false,
      hasFocus: false,
      isOpen: false,
      isLocked: false
    },

    toggleOpen() {
      const newIsOpen = !this.get('isOpen');
      this.set('isOpen', newIsOpen);

      if (newIsOpen) {
        this.focus();
      }

      return this;
    },

    close() {
      this.set('isOpen', false);
      return this;
    },

    focus() {
      this.set('hasFocus', true);
      const cid = this.cid;
      this.collection.each(model => {
        if (model.cid !== cid) {
          model.close().blur();
        }
      });
      return this;
    },

    blur() {
      if (!this.get('isOpen')) {
        this.set('hasFocus', false);
      }

      return this;
    }

  });
})(Drupal, Backbone);