/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function (Drupal, Backbone, $, Sortable) {
  Drupal.ckeditor.VisualView = Backbone.View.extend({
    events: {
      'click .ckeditor-toolbar-group-name': 'onGroupNameClick',
      'click .ckeditor-groupnames-toggle': 'onGroupNamesToggleClick',
      'click .ckeditor-add-new-group button': 'onAddGroupButtonClick'
    },

    initialize() {
      this.listenTo(this.model, 'change:isDirty change:groupNamesVisible', this.render);
      $(Drupal.theme('ckeditorButtonGroupNamesToggle')).prependTo(this.$el.find('#ckeditor-active-toolbar').parent());
      this.render();
    },

    render(model, value, changedAttributes) {
      this.insertPlaceholders();
      this.applySorting();
      let groupNamesVisible = this.model.get('groupNamesVisible');

      if (changedAttributes && changedAttributes.changes && changedAttributes.changes.isDirty) {
        this.model.set({
          groupNamesVisible: true
        }, {
          silent: true
        });
        groupNamesVisible = true;
      }

      this.$el.find('[data-toolbar="active"]').toggleClass('ckeditor-group-names-are-visible', groupNamesVisible);
      const $toggle = this.$el.find('.ckeditor-groupnames-toggle');
      $toggle.each((index, element) => {
        element.textContent = groupNamesVisible ? Drupal.t('Hide group names') : Drupal.t('Show group names');
      }).attr('aria-pressed', groupNamesVisible);
      return this;
    },

    onGroupNameClick(event) {
      const $group = $(event.currentTarget).closest('.ckeditor-toolbar-group');
      Drupal.ckeditor.openGroupNameDialog(this, $group);
      event.stopPropagation();
      event.preventDefault();
    },

    onGroupNamesToggleClick(event) {
      this.model.set('groupNamesVisible', !this.model.get('groupNamesVisible'));
      event.preventDefault();
    },

    onAddGroupButtonClick(event) {
      function insertNewGroup(success, $group) {
        if (success) {
          $group.appendTo($(event.currentTarget).closest('.ckeditor-row').children('.ckeditor-toolbar-groups'));
          $group.trigger('focus');
        }
      }

      Drupal.ckeditor.openGroupNameDialog(this, $(Drupal.theme('ckeditorToolbarGroup')), insertNewGroup);
      event.preventDefault();
    },

    endGroupDrag(event) {
      const $item = $(event.item);
      Drupal.ckeditor.registerGroupMove(this, $item);
    },

    startButtonDrag(event) {
      this.$el.find('a:focus').trigger('blur');
      this.model.set('groupNamesVisible', true);
    },

    endButtonDrag(event) {
      const $item = $(event.item);
      Drupal.ckeditor.registerButtonMove(this, $item, success => {
        $item.find('a').trigger('focus');
      });
    },

    applySorting() {
      Array.prototype.forEach.call(this.el.querySelectorAll('.ckeditor-buttons:not(.js-sortable)'), buttons => {
        buttons.classList.add('js-sortable');
        Sortable.create(buttons, {
          ghostClass: 'ckeditor-button-placeholder',
          group: 'ckeditor-buttons',
          onStart: this.startButtonDrag.bind(this),
          onEnd: this.endButtonDrag.bind(this)
        });
      });
      Array.prototype.forEach.call(this.el.querySelectorAll('.ckeditor-toolbar-groups:not(.js-sortable)'), buttons => {
        buttons.classList.add('js-sortable');
        Sortable.create(buttons, {
          ghostClass: 'ckeditor-toolbar-group-placeholder',
          onEnd: this.endGroupDrag.bind(this)
        });
      });
      Array.prototype.forEach.call(this.el.querySelectorAll('.ckeditor-multiple-buttons:not(.js-sortable)'), buttons => {
        buttons.classList.add('js-sortable');
        Sortable.create(buttons, {
          group: {
            name: 'ckeditor-buttons',
            pull: 'clone'
          },
          onEnd: this.endButtonDrag.bind(this)
        });
      });
    },

    insertPlaceholders() {
      this.insertPlaceholderRow();
      this.insertNewGroupButtons();
    },

    insertPlaceholderRow() {
      let $rows = this.$el.find('.ckeditor-row');

      if (!$rows.eq(-1).hasClass('placeholder')) {
        this.$el.find('.ckeditor-toolbar-active').children('.ckeditor-active-toolbar-configuration').append(Drupal.theme('ckeditorRow'));
      }

      $rows = this.$el.find('.ckeditor-row');
      const len = $rows.length;
      $rows.filter((index, row) => {
        if (index + 1 === len) {
          return false;
        }

        return $(row).find('.ckeditor-toolbar-group').not('.placeholder').length === 0;
      }).remove();
    },

    insertNewGroupButtons() {
      this.$el.find('.ckeditor-row').each(function () {
        const $row = $(this);
        const $groups = $row.find('.ckeditor-toolbar-group');
        const $button = $row.find('.ckeditor-add-new-group');

        if ($button.length === 0) {
          $row.children('.ckeditor-toolbar-groups').append(Drupal.theme('ckeditorNewButtonGroup'));
        } else if (!$groups.eq(-1).hasClass('ckeditor-add-new-group')) {
          $button.appendTo($row.children('.ckeditor-toolbar-groups'));
        }
      });
    }

  });
})(Drupal, Backbone, jQuery, Sortable);