/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, Backbone, CKEDITOR, _) {
  Drupal.ckeditor.ControllerView = Backbone.View.extend({
    events: {},

    initialize() {
      this.getCKEditorFeatures(this.model.get('hiddenEditorConfig'), this.disableFeaturesDisallowedByFilters.bind(this));
      this.model.listenTo(this.model, 'change:activeEditorConfig', this.model.sync);
      this.listenTo(this.model, 'change:isDirty', this.parseEditorDOM);
    },

    parseEditorDOM(model, isDirty, options) {
      if (isDirty) {
        const currentConfig = this.model.get('activeEditorConfig');
        const rows = [];
        this.$el.find('.ckeditor-active-toolbar-configuration').children('.ckeditor-row').each(function () {
          const groups = [];
          $(this).find('.ckeditor-toolbar-group').each(function () {
            const $group = $(this);
            const $buttons = $group.find('.ckeditor-button');

            if ($buttons.length) {
              const group = {
                name: $group.attr('data-drupal-ckeditor-toolbar-group-name'),
                items: []
              };
              $group.find('.ckeditor-button, .ckeditor-multiple-button').each(function () {
                group.items.push($(this).attr('data-drupal-ckeditor-button-name'));
              });
              groups.push(group);
            }
          });

          if (groups.length) {
            rows.push(groups);
          }
        });
        this.model.set('activeEditorConfig', rows);
        this.model.set('isDirty', false);

        if (options.broadcast !== false) {
          const prev = this.getButtonList(currentConfig);
          const next = this.getButtonList(rows);

          if (prev.length !== next.length) {
            this.$el.find('.ckeditor-toolbar-active').trigger('CKEditorToolbarChanged', [prev.length < next.length ? 'added' : 'removed', _.difference(_.union(prev, next), _.intersection(prev, next))[0]]);
          }
        }
      }
    },

    getCKEditorFeatures(CKEditorConfig, callback) {
      const getProperties = function (CKEPropertiesList) {
        return _.isObject(CKEPropertiesList) ? _.keys(CKEPropertiesList) : [];
      };

      const convertCKERulesToEditorFeature = function (feature, CKEFeatureRules) {
        for (let i = 0; i < CKEFeatureRules.length; i++) {
          const CKERule = CKEFeatureRules[i];
          const rule = new Drupal.EditorFeatureHTMLRule();
          const tags = getProperties(CKERule.elements);
          rule.required.tags = CKERule.propertiesOnly ? [] : tags;
          rule.allowed.tags = tags;
          rule.required.attributes = getProperties(CKERule.requiredAttributes);
          rule.allowed.attributes = getProperties(CKERule.attributes);
          rule.required.styles = getProperties(CKERule.requiredStyles);
          rule.allowed.styles = getProperties(CKERule.styles);
          rule.required.classes = getProperties(CKERule.requiredClasses);
          rule.allowed.classes = getProperties(CKERule.classes);
          rule.raw = CKERule;
          feature.addHTMLRule(rule);
        }
      };

      const hiddenCKEditorID = 'ckeditor-hidden';

      if (CKEDITOR.instances[hiddenCKEditorID]) {
        CKEDITOR.instances[hiddenCKEditorID].destroy(true);
      }

      const hiddenEditorConfig = this.model.get('hiddenEditorConfig');

      if (hiddenEditorConfig.drupalExternalPlugins) {
        const externalPlugins = hiddenEditorConfig.drupalExternalPlugins;
        Object.keys(externalPlugins || {}).forEach(pluginName => {
          CKEDITOR.plugins.addExternal(pluginName, externalPlugins[pluginName], '');
        });
      }

      CKEDITOR.inline($(`#${hiddenCKEditorID}`).get(0), CKEditorConfig);
      CKEDITOR.once('instanceReady', e => {
        if (e.editor.name === hiddenCKEditorID) {
          const CKEFeatureRulesMap = {};
          const rules = e.editor.filter.allowedContent;
          let rule;
          let name;

          for (let i = 0; i < rules.length; i++) {
            rule = rules[i];
            name = rule.featureName || ':(';

            if (!CKEFeatureRulesMap[name]) {
              CKEFeatureRulesMap[name] = [];
            }

            CKEFeatureRulesMap[name].push(rule);
          }

          const features = {};
          const buttonsToFeatures = {};
          Object.keys(CKEFeatureRulesMap).forEach(featureName => {
            const feature = new Drupal.EditorFeature(featureName);
            convertCKERulesToEditorFeature(feature, CKEFeatureRulesMap[featureName]);
            features[featureName] = feature;
            const command = e.editor.getCommand(featureName);

            if (command) {
              buttonsToFeatures[command.uiItems[0].name] = featureName;
            }
          });
          callback(features, buttonsToFeatures);
        }
      });
    },

    getFeatureForButton(button) {
      if (button === '-') {
        return false;
      }

      let featureName = this.model.get('buttonsToFeatures')[button.toLowerCase()];

      if (!featureName) {
        featureName = button.toLowerCase();
      }

      const featuresMetadata = this.model.get('featuresMetadata');

      if (!featuresMetadata[featureName]) {
        featuresMetadata[featureName] = new Drupal.EditorFeature(featureName);
        this.model.set('featuresMetadata', featuresMetadata);
      }

      return featuresMetadata[featureName];
    },

    disableFeaturesDisallowedByFilters(features, buttonsToFeatures) {
      this.model.set('featuresMetadata', features);
      this.model.set('buttonsToFeatures', buttonsToFeatures);
      this.broadcastConfigurationChanges(this.$el);
      let existingButtons = [];

      const buttonGroups = _.flatten(this.model.get('activeEditorConfig'));

      for (let i = 0; i < buttonGroups.length; i++) {
        const buttons = buttonGroups[i].items;

        for (let k = 0; k < buttons.length; k++) {
          existingButtons.push(buttons[k]);
        }
      }

      existingButtons = _.unique(existingButtons);

      for (let n = 0; n < existingButtons.length; n++) {
        const button = existingButtons[n];
        const feature = this.getFeatureForButton(button);

        if (feature === false) {
          continue;
        }

        if (Drupal.editorConfiguration.featureIsAllowedByFilters(feature)) {
          this.$el.find('.ckeditor-toolbar-active').trigger('CKEditorToolbarChanged', ['added', existingButtons[n]]);
        } else {
          $(`.ckeditor-toolbar-active li[data-drupal-ckeditor-button-name="${button}"]`).detach().appendTo('.ckeditor-toolbar-disabled > .ckeditor-toolbar-available > ul');
          this.model.set({
            isDirty: true
          }, {
            broadcast: false
          });
        }
      }
    },

    broadcastConfigurationChanges($ckeditorToolbar) {
      const view = this;
      const hiddenEditorConfig = this.model.get('hiddenEditorConfig');
      const getFeatureForButton = this.getFeatureForButton.bind(this);
      const getCKEditorFeatures = this.getCKEditorFeatures.bind(this);
      $ckeditorToolbar.find('.ckeditor-toolbar-active').on('CKEditorToolbarChanged.ckeditorAdmin', (event, action, button) => {
        const feature = getFeatureForButton(button);

        if (feature === false) {
          return;
        }

        const configEvent = action === 'added' ? 'addedFeature' : 'removedFeature';
        Drupal.editorConfiguration[configEvent](feature);
      }).on('CKEditorPluginSettingsChanged.ckeditorAdmin', (event, settingsChanges) => {
        Object.keys(settingsChanges || {}).forEach(key => {
          hiddenEditorConfig[key] = settingsChanges[key];
        });
        getCKEditorFeatures(hiddenEditorConfig, features => {
          const featuresMetadata = view.model.get('featuresMetadata');
          Object.keys(features || {}).forEach(name => {
            const feature = features[name];

            if (featuresMetadata.hasOwnProperty(name) && !_.isEqual(featuresMetadata[name], feature)) {
              Drupal.editorConfiguration.modifiedFeature(feature);
            }
          });
          view.model.set('featuresMetadata', features);
        });
      });
    },

    getButtonList(config) {
      const buttons = [];
      config = _.flatten(config);
      config.forEach(group => {
        group.items.forEach(button => {
          buttons.push(button);
        });
      });
      return _.without(buttons, '-');
    }

  });
})(jQuery, Drupal, Backbone, CKEDITOR, _);