/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, drupalSettings, _) {
  Drupal.behaviors.ckeditorStylesComboSettings = {
    attach(context) {
      const $context = $(context);
      const $ckeditorActiveToolbar = $context.find('.ckeditor-toolbar-configuration').find('.ckeditor-toolbar-active');
      let previousStylesSet = drupalSettings.ckeditor.hiddenCKEditorConfig.stylesSet;
      const that = this;
      $context.find('[name="editor[settings][plugins][stylescombo][styles]"]').on('blur.ckeditorStylesComboSettings', function () {
        const styles = this.value.trim();

        const stylesSet = that._generateStylesSetSetting(styles);

        if (!_.isEqual(previousStylesSet, stylesSet)) {
          previousStylesSet = stylesSet;
          $ckeditorActiveToolbar.trigger('CKEditorPluginSettingsChanged', [{
            stylesSet
          }]);
        }
      });
    },

    _generateStylesSetSetting(styles) {
      const stylesSet = [];
      styles = styles.replace(/\r/g, '\n');
      const lines = styles.split('\n');

      for (let i = 0; i < lines.length; i++) {
        const style = lines[i].trim();

        if (style.length === 0) {
          continue;
        }

        if (style.match(/^ *[a-zA-Z0-9]+ *(\.[a-zA-Z0-9_-]+ *)*\| *.+ *$/) === null) {
          continue;
        }

        const parts = style.split('|');
        const selector = parts[0];
        const label = parts[1];
        const classes = selector.split('.');
        const element = classes.shift();
        stylesSet.push({
          attributes: {
            class: classes.join(' ')
          },
          element,
          name: label
        });
      }

      return stylesSet;
    }

  };
  Drupal.behaviors.ckeditorStylesComboSettingsSummary = {
    attach() {
      $('[data-ckeditor-plugin-id="stylescombo"]').drupalSetSummary(context => {
        const stylesElement = document.querySelector('[data-drupal-selector="edit-editor-settings-plugins-stylescombo-styles"]');
        const styles = stylesElement ? stylesElement.value.trim() : '';

        if (styles.length === 0) {
          return Drupal.t('No styles configured');
        }

        const count = styles.split('\n').length;
        return Drupal.t('@count styles configured', {
          '@count': count
        });
      });
    }

  };
})(jQuery, Drupal, drupalSettings, _);