/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, drupalSettings) {
  function handleDialogResize(e) {
    var $modal = $(e.currentTarget);
    var $viewsOverride = $modal.find('[data-drupal-views-offset]');
    var $scroll = $modal.find('[data-drupal-views-scroll]');
    var offset = 0;
    var modalHeight;
    if ($scroll.length) {
      $modal.closest('.views-ui-dialog').addClass('views-ui-dialog-scroll');
      $scroll.css({
        overflow: 'visible',
        height: 'auto'
      });
      modalHeight = $modal.height();
      $viewsOverride.each(function () {
        offset += $(this).outerHeight();
      });

      var scrollOffset = $scroll.outerHeight() - $scroll.height();
      $scroll.height(modalHeight - offset - scrollOffset);
      $modal.css('overflow', 'hidden');
      $scroll.css('overflow', 'auto');
    }
  }

  Drupal.behaviors.viewsModalContent = {
    attach: function attach(context) {
      $(once('viewsDialog', 'body')).on('dialogContentResize.viewsDialog', '.ui-dialog-content', handleDialogResize);
      $(once('detailsUpdate', '.scroll', context)).on('click', 'summary', function (e) {
        $(e.currentTarget).trigger('dialogContentResize');
      });
    },
    detach: function detach(context, settings, trigger) {
      if (trigger === 'unload') {
        $(once.remove('viewsDialog', 'body')).off('.viewsDialog');
      }
    }
  };
})(jQuery, Drupal, drupalSettings);