/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/
var assert = require('assert');
var fs = require('fs');
var path = require('path');
var _require = require('jsdom'),
  JSDOM = _require.JSDOM;

var DrupalHtmlBuilder = eval("(".concat(fs.readFileSync(path.resolve(__dirname, '../../../../js/ckeditor5_plugins/drupalHtmlEngine/src/drupalhtmlbuilder.js')).toString(), ")").replace('export default', ''));
var _JSDOM$window = new JSDOM("<!DOCTYPE html>").window,
  document = _JSDOM$window.document,
  Node = _JSDOM$window.Node;
module.exports = {
  '@tags': ['ckeditor5'],
  '@unitTest': true,
  'should return empty string when empty DocumentFragment is passed': function shouldReturnEmptyStringWhenEmptyDocumentFragmentIsPassed() {
    var drupalHtmlBuilder = new DrupalHtmlBuilder();
    drupalHtmlBuilder.appendNode(document.createDocumentFragment());
    assert.equal(drupalHtmlBuilder.build(), '');
  },
  'should create text from single text node': function shouldCreateTextFromSingleTextNode() {
    var drupalHtmlBuilder = new DrupalHtmlBuilder();
    var text = 'foo bar';
    var fragment = document.createDocumentFragment();
    var textNode = document.createTextNode(text);
    fragment.appendChild(textNode);
    drupalHtmlBuilder.appendNode(fragment);
    assert.equal(drupalHtmlBuilder.build(), text);
  },
  'should return correct HTML from fragment with paragraph': function shouldReturnCorrectHTMLFromFragmentWithParagraph() {
    var drupalHtmlBuilder = new DrupalHtmlBuilder();
    var fragment = document.createDocumentFragment();
    var paragraph = document.createElement('p');
    paragraph.textContent = 'foo bar';
    fragment.appendChild(paragraph);
    drupalHtmlBuilder.appendNode(fragment);
    assert.equal(drupalHtmlBuilder.build(), '<p>foo bar</p>');
  },
  'should return correct HTML from fragment with multiple child nodes': function shouldReturnCorrectHTMLFromFragmentWithMultipleChildNodes() {
    var drupalHtmlBuilder = new DrupalHtmlBuilder();
    var fragment = document.createDocumentFragment();
    var text = document.createTextNode('foo bar');
    var paragraph = document.createElement('p');
    var div = document.createElement('div');
    paragraph.textContent = 'foo';
    div.textContent = 'bar';
    fragment.appendChild(text);
    fragment.appendChild(paragraph);
    fragment.appendChild(div);
    drupalHtmlBuilder.appendNode(fragment);
    assert.equal(drupalHtmlBuilder.build(), 'foo bar<p>foo</p><div>bar</div>');
  },
  'should return correct HTML from fragment with comment': function shouldReturnCorrectHTMLFromFragmentWithComment() {
    var drupalHtmlBuilder = new DrupalHtmlBuilder();
    var fragment = document.createDocumentFragment();
    var div = document.createElement('div');
    var comment = document.createComment('bar');
    div.textContent = 'bar';
    fragment.appendChild(div);
    fragment.appendChild(comment);
    drupalHtmlBuilder.appendNode(fragment);
    assert.equal(drupalHtmlBuilder.build(), '<div>bar</div>');
  },
  'should return correct HTML from fragment with attributes': function shouldReturnCorrectHTMLFromFragmentWithAttributes() {
    var drupalHtmlBuilder = new DrupalHtmlBuilder();
    var fragment = document.createDocumentFragment();
    var div = document.createElement('div');
    div.setAttribute('id', 'foo');
    div.classList.add('bar');
    div.textContent = 'baz';
    fragment.appendChild(div);
    drupalHtmlBuilder.appendNode(fragment);
    assert.equal(drupalHtmlBuilder.build(), '<div id="foo" class="bar">baz</div>');
  },
  'should return correct HTML from fragment with self closing tag': function shouldReturnCorrectHTMLFromFragmentWithSelfClosingTag() {
    var drupalHtmlBuilder = new DrupalHtmlBuilder();
    var fragment = document.createDocumentFragment();
    var hr = document.createElement('hr');
    fragment.appendChild(hr);
    drupalHtmlBuilder.appendNode(fragment);
    assert.equal(drupalHtmlBuilder.build(), '<hr>');
  },
  'attribute values should be escaped': function attributeValuesShouldBeEscaped() {
    var drupalHtmlBuilder = new DrupalHtmlBuilder();
    var fragment = document.createDocumentFragment();
    var div = document.createElement('div');
    div.setAttribute('data-caption', 'Kittens & llamas are <em>cute</em>');
    div.textContent = 'foo';
    fragment.appendChild(div);
    drupalHtmlBuilder.appendNode(fragment);
    assert.equal(drupalHtmlBuilder.build(), '<div data-caption="Kittens &amp; llamas are &lt;em&gt;cute&lt;/em&gt;">foo</div>');
  }
};