<?php
// phpcs:ignoreFile
/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 11.3-dev db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();
// Ensure any tables with a serial column with a value of 0 are created as
// expected.
if ($connection->databaseType() === 'mysql') {
  $sql_mode = $connection->query("SELECT @@sql_mode;")->fetchField();
  $connection->query("SET sql_mode = '$sql_mode,NO_AUTO_VALUE_ON_ZERO'");
}

$connection->schema()->createTable('access', [
  'fields' => [
    'aid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'mask' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'aid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('accesslog', [
  'fields' => [
    'aid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'sid' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
    'path' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
    'url' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'hostname' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '128',
    ],
    'uid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'timer' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'aid',
  ],
  'indexes' => [
    'accesslog_timestamp' => [
      'timestamp',
    ],
    'uid' => [
      'uid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('actions', [
  'fields' => [
    'aid' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'callback' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'parameters' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'description' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'aid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('actions')
->fields([
  'aid',
  'type',
  'callback',
  'parameters',
  'description',
])
->values([
  'aid' => '1',
  'type' => 'comment',
  'callback' => 'comment_unpublish_by_keyword_action',
  'parameters' => 'a:1:{s:8:"keywords";a:1:{i:0;s:6:"drupal";}}',
  'description' => 'Unpublish comment containing keyword(s)',
])
->values([
  'aid' => '2',
  'type' => 'node',
  'callback' => 'node_assign_owner_action',
  'parameters' => 'a:1:{s:9:"owner_uid";s:1:"2";}',
  'description' => 'Change the author of a post',
])
->values([
  'aid' => '3',
  'type' => 'node',
  'callback' => 'node_unpublish_by_keyword_action',
  'parameters' => 'a:1:{s:8:"keywords";a:1:{i:0;s:6:"drupal";}}',
  'description' => 'Unpublish post containing keyword(s)',
])
->values([
  'aid' => '4',
  'type' => 'system',
  'callback' => 'system_message_action',
  'parameters' => 'a:1:{s:7:"message";s:21:"Drupal migration test";}',
  'description' => 'Display a message to the user',
])
->values([
  'aid' => '5',
  'type' => 'system',
  'callback' => 'system_send_email_action',
  'parameters' => 'a:3:{s:9:"recipient";s:16:"test@example.com";s:7:"subject";s:21:"Drupal migration test";s:7:"message";s:21:"Drupal migration test";}',
  'description' => 'Send e-mail',
])
->values([
  'aid' => '6',
  'type' => 'system',
  'callback' => 'system_goto_action',
  'parameters' => 'a:1:{s:3:"url";s:22:"https://www.drupal.org";}',
  'description' => 'Redirect to URL',
])
->values([
  'aid' => 'comment_publish_action',
  'type' => 'comment',
  'callback' => 'comment_publish_action',
  'parameters' => '',
  'description' => 'Publish comment',
])
->values([
  'aid' => 'comment_unpublish_action',
  'type' => 'comment',
  'callback' => 'comment_unpublish_action',
  'parameters' => '',
  'description' => 'Unpublish comment',
])
->values([
  'aid' => 'imagecache_flush_action',
  'type' => 'node',
  'callback' => 'imagecache_flush_action',
  'parameters' => '',
  'description' => "ImageCache: Flush ALL presets for this node's filefield images",
])
->values([
  'aid' => 'imagecache_generate_all_action',
  'type' => 'node',
  'callback' => 'imagecache_generate_all_action',
  'parameters' => '',
  'description' => "ImageCache: Generate ALL presets for this node's filefield images",
])
->values([
  'aid' => 'node_make_sticky_action',
  'type' => 'node',
  'callback' => 'node_make_sticky_action',
  'parameters' => '',
  'description' => 'Make post sticky',
])
->values([
  'aid' => 'node_make_unsticky_action',
  'type' => 'node',
  'callback' => 'node_make_unsticky_action',
  'parameters' => '',
  'description' => 'Make post unsticky',
])
->values([
  'aid' => 'node_promote_action',
  'type' => 'node',
  'callback' => 'node_promote_action',
  'parameters' => '',
  'description' => 'Promote post to front page',
])
->values([
  'aid' => 'node_publish_action',
  'type' => 'node',
  'callback' => 'node_publish_action',
  'parameters' => '',
  'description' => 'Publish post',
])
->values([
  'aid' => 'node_save_action',
  'type' => 'node',
  'callback' => 'node_save_action',
  'parameters' => '',
  'description' => 'Save post',
])
->values([
  'aid' => 'node_unpromote_action',
  'type' => 'node',
  'callback' => 'node_unpromote_action',
  'parameters' => '',
  'description' => 'Remove post from front page',
])
->values([
  'aid' => 'node_unpublish_action',
  'type' => 'node',
  'callback' => 'node_unpublish_action',
  'parameters' => '',
  'description' => 'Unpublish post',
])
->values([
  'aid' => 'user_block_ip_action',
  'type' => 'user',
  'callback' => 'user_block_ip_action',
  'parameters' => '',
  'description' => 'Ban IP address of current user',
])
->values([
  'aid' => 'user_block_user_action',
  'type' => 'user',
  'callback' => 'user_block_user_action',
  'parameters' => '',
  'description' => 'Block current user',
])
->execute();
$connection->schema()->createTable('actions_aid', [
  'fields' => [
    'aid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'aid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('actions_aid')
->fields([
  'aid',
])
->values([
  'aid' => '1',
])
->values([
  'aid' => '2',
])
->values([
  'aid' => '3',
])
->values([
  'aid' => '4',
])
->values([
  'aid' => '5',
])
->values([
  'aid' => '6',
])
->execute();
$connection->schema()->createTable('aggregator_category', [
  'fields' => [
    'cid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'description' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'block' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'cid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('aggregator_feed', [
  'fields' => [
    'fid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'url' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'refresh' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'checked' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'link' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'description' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'image' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'etag' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'modified' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'block' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'fid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('aggregator_item', [
  'fields' => [
    'iid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'fid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'link' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'author' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'description' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'timestamp' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'guid' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
  ],
  'primary key' => [
    'iid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('authmap', [
  'fields' => [
    'aid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'authname' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
  ],
  'primary key' => [
    'aid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('batch', [
  'fields' => [
    'bid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'token' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ],
    'timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'batch' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'bid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('batch')
->fields([
  'bid',
  'token',
  'timestamp',
  'batch',
])
->values([
  'bid' => '1',
  'token' => '',
  'timestamp' => '1494966324',
  'batch' => NULL,
])
->execute();
$connection->schema()->createTable('blocks', [
  'fields' => [
    'bid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'delta' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '0',
    ],
    'theme' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'region' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'custom' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'throttle' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'visibility' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'pages' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'cache' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ],
  ],
  'primary key' => [
    'bid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('blocks')
->fields([
  'bid',
  'module',
  'delta',
  'theme',
  'status',
  'weight',
  'region',
  'custom',
  'throttle',
  'visibility',
  'pages',
  'title',
  'cache',
])
->values([
  'bid' => '4',
  'module' => 'comment',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-9',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
])
->values([
  'bid' => '5',
  'module' => 'menu',
  'delta' => 'primary-links',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-5',
  'region' => 'header',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
])
->values([
  'bid' => '6',
  'module' => 'menu',
  'delta' => 'secondary-links',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-8',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
])
->values([
  'bid' => '7',
  'module' => 'node',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-7',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
])
->values([
  'bid' => '8',
  'module' => 'user',
  'delta' => '2',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-11',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
])
->values([
  'bid' => '9',
  'module' => 'user',
  'delta' => '3',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-10',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
])
->values([
  'bid' => '14',
  'module' => 'aggregator',
  'delta' => 'feed-5',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-2',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
])
->values([
  'bid' => '15',
  'module' => 'block',
  'delta' => '2',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '1',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
])
->values([
  'bid' => '16',
  'module' => 'profile',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-5',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '5',
])
->values([
  'bid' => '17',
  'module' => 'event',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-3',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
])
->values([
  'bid' => '18',
  'module' => 'event',
  'delta' => '1',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '0',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
])
->values([
  'bid' => '19',
  'module' => 'event',
  'delta' => 'event-upcoming-event',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-1',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
])
->values([
  'bid' => '20',
  'module' => 'book',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-4',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '5',
])
->values([
  'bid' => '21',
  'module' => 'locale',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '0',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
])
->values([
  'bid' => '22',
  'module' => 'forum',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-8',
  'region' => 'left',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
])
->values([
  'bid' => '23',
  'module' => 'forum',
  'delta' => '1',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-9',
  'region' => 'left',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
])
->values([
  'bid' => '24',
  'module' => 'statistics',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '0',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
])
->execute();
$connection->schema()->createTable('blocks_roles', [
  'fields' => [
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ],
    'delta' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ],
    'rid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'module',
    'delta',
    'rid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('book', [
  'fields' => [
    'mlid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'bid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'mlid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('boxes', [
  'fields' => [
    'bid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'body' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'info' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'format' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'bid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('comments', [
  'fields' => [
    'cid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'pid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'subject' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'comment' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'hostname' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'format' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'thread' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '60',
    ],
    'mail' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '64',
    ],
    'homepage' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
  ],
  'primary key' => [
    'cid',
  ],
  'indexes' => [
    'pid' => [
      'pid',
    ],
    'comment_uid' => [
      'uid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('config', [
  'fields' => [
    'collection' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'data' => [
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'collection',
    'name',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('config')
->fields([
  'collection',
  'name',
  'data',
])
->values([
  'collection' => '',
  'name' => 'system.file',
  'data' => 'a:1:{s:4:"path";a:1:{s:9:"temporary";s:4:"/tmp";}}',
])
->execute();
$connection->schema()->createTable('contact', [
  'fields' => [
    'cid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'category' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'recipients' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'reply' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'selected' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'cid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('contact')
->fields([
  'cid',
  'category',
  'recipients',
  'reply',
  'weight',
  'selected',
])
->values([
  'cid' => '1',
  'category' => 'Website feedback',
  'recipients' => 'admin@example.com',
  'reply' => '',
  'weight' => '0',
  'selected' => '0',
])
->values([
  'cid' => '2',
  'category' => 'Some other category',
  'recipients' => 'test@example.com',
  'reply' => 'Thanks for contacting us, we will reply ASAP!',
  'weight' => '1',
  'selected' => '1',
])
->values([
  'cid' => '3',
  'category' => 'A category much longer than thirty two characters',
  'recipients' => 'fortyninechars@example.com',
  'reply' => '',
  'weight' => '2',
  'selected' => '0',
])
->execute();
$connection->schema()->createTable('content_field_company', [
  'fields' => [
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'field_company_nid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'vid',
    'delta',
  ],
  'indexes' => [
    'nid' => [
      'nid',
    ],
    'field_company_nid' => [
      'field_company_nid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('content_field_image', [
  'fields' => [
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'field_image_fid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'field_image_list' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'field_image_data' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'vid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('content_field_multivalue', [
  'fields' => [
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'field_multivalue_value' => [
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '2',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'vid',
    'delta',
  ],
  'indexes' => [
    'nid' => [
      'nid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('content_field_node_reference', [
  'fields' => [
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'field_node_reference_nid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'vid',
    'delta',
  ],
  'indexes' => [
    'nid' => [
      'nid',
    ],
    'field_node_reference_nid' => [
      'field_node_reference_nid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('content_field_test', [
  'fields' => [
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'field_test_value' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'field_test_format' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'vid',
  ],
  'indexes' => [
    'nid' => [
      'nid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('content_field_test_text_single_checkbox', [
  'fields' => [
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'field_test_text_single_checkbox_value' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'vid',
  ],
  'indexes' => [
    'nid' => [
      'nid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('content_field_test_two', [
  'fields' => [
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'field_test_two_value' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'vid',
    'delta',
  ],
  'indexes' => [
    'nid' => [
      'nid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('content_field_user_reference', [
  'fields' => [
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'field_user_reference_uid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'vid',
    'delta',
  ],
  'indexes' => [
    'nid' => [
      'nid',
    ],
    'field_user_reference_uid' => [
      'field_user_reference_uid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('content_group', [
  'fields' => [
    'group_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => 'standard',
    ],
    'type_name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'group_name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'label' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'settings' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'type_name',
    'group_name',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('content_group_fields', [
  'fields' => [
    'type_name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'group_name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'field_name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
  ],
  'primary key' => [
    'type_name',
    'group_name',
    'field_name',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('content_node_field', [
  'fields' => [
    'field_name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '127',
      'default' => '',
    ],
    'global_settings' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'required' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'multiple' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'db_storage' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '127',
      'default' => '',
    ],
    'db_columns' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'active' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'locked' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'field_name',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('content_node_field_instance', [
  'fields' => [
    'field_name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'type_name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'label' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'widget_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'widget_settings' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'display_settings' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'description' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'widget_module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '127',
      'default' => '',
    ],
    'widget_active' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'field_name',
    'type_name',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('content_node_field_instance')
->fields([
  'field_name',
  'type_name',
  'weight',
  'label',
  'widget_type',
  'widget_settings',
  'display_settings',
  'description',
  'widget_module',
  'widget_active',
])
->values([
  'field_name' => 'field_test_integer_selectlist',
  'type_name' => 'story',
  'weight' => '16',
  'label' => 'Integer Select List Field',
  'widget_type' => 'optionwidgets_select',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"16";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example integer field using a select list.',
  'widget_module' => 'optionwidgets',
  'widget_active' => '1',
])
->values([
  'field_name' => 'field_test_link',
  'type_name' => 'story',
  'weight' => '7',
  'label' => 'Link Field',
  'widget_type' => 'link',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"title";s:18:"default link title";s:3:"url";s:22:"https://www.drupal.org";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"7";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:8:"absolute";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example link field.',
  'widget_module' => 'link',
  'widget_active' => '1',
])
->values([
  'field_name' => 'field_test_phone',
  'type_name' => 'story',
  'weight' => '13',
  'label' => 'Phone Field',
  'widget_type' => 'phone_textfield',
  'widget_settings' => 'a:3:{s:4:"size";s:2:"60";s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:0:"";s:14:"_error_element";s:48:"default_value_widget][field_test_phone][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"13";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example phone field.',
  'widget_module' => 'phone',
  'widget_active' => '1',
])
->values([
  'field_name' => 'field_test_string_selectlist',
  'type_name' => 'story',
  'weight' => '31',
  'label' => 'String Select List Field',
  'widget_type' => 'optionwidgets_select',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:5:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => '',
  'widget_module' => 'optionwidgets',
  'widget_active' => '1',
])
->values([
  'field_name' => 'field_test_text_single_checkbox',
  'type_name' => 'story',
  'weight' => '17',
  'label' => 'Text Single Checkbox Field',
  'widget_type' => 'optionwidgets_onoff',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:1:"a";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"17";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example text field using a single on/off checkbox.',
  'widget_module' => 'optionwidgets',
  'widget_active' => '1',
])
->values([
  'field_name' => 'field_test_text_single_checkbox',
  'type_name' => 'test_planet',
  'weight' => '32',
  'label' => 'Text Single Checkbox Field',
  'widget_type' => 'text_textfield',
  'widget_settings' => 'a:4:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:1:"0";s:14:"_error_element";s:63:"default_value_widget][field_test_text_single_checkbox][0][value";}}s:17:"default_value_php";N;s:4:"rows";i:5;s:4:"size";s:3:"255";}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"32";s:6:"parent";s:0:"";s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:6:"hidden";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example text field using a single on/off checkbox.',
  'widget_module' => 'text',
  'widget_active' => '1',
])
->values([
  'field_name' => 'field_test_text_single_checkbox2',
  'type_name' => 'story',
  'weight' => '19',
  'label' => 'Text Single Checkbox Field 2',
  'widget_type' => 'optionwidgets_onoff',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";N;}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:5:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'Checkbox that uses keys only and no label.',
  'widget_module' => 'optionwidgets',
  'widget_active' => '1',
])
->values([
  'field_name' => 'field_test_three',
  'type_name' => 'story',
  'weight' => '2',
  'label' => 'Decimal Field',
  'widget_type' => 'number',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";d:101;s:14:"_error_element";s:48:"default_value_widget][field_test_three][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"2";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:11:"unformatted";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:4:"us_2";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:11:"unformatted";s:7:"exclude";i:0;}}',
  'description' => 'An example decimal field.',
  'widget_module' => 'number',
  'widget_active' => '1',
])
->values([
  'field_name' => 'field_test_two',
  'type_name' => 'story',
  'weight' => '1',
  'label' => 'Integer Field',
  'widget_type' => 'number',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:0:"";s:14:"_error_element";s:46:"default_value_widget][field_test_two][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"1";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:4:"us_0";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:4:"us_0";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:11:"unformatted";s:7:"exclude";i:0;}}',
  'description' => 'An example integer field.',
  'widget_module' => 'number',
  'widget_active' => '1',
])
->values([
  'field_name' => 'field_user_reference',
  'type_name' => 'story',
  'weight' => '20',
  'label' => 'User reference',
  'widget_type' => 'userreference_autocomplete',
  'widget_settings' => 'a:5:{s:18:"autocomplete_match";s:8:"contains";s:4:"size";s:2:"60";s:12:"reverse_link";i:0;s:13:"default_value";a:1:{i:0;a:2:{s:3:"uid";N;s:14:"_error_element";s:55:"default_value_widget][field_user_reference][0][uid][uid";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:5:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => '',
  'widget_module' => 'userreference',
  'widget_active' => '1',
])
->values([
  'field_name' => 'field_user_reference_2',
  'type_name' => 'story',
  'weight' => '21',
  'label' => 'User reference 2',
  'widget_type' => 'userreference_select',
  'widget_settings' => 'a:5:{s:18:"autocomplete_match";s:8:"contains";s:4:"size";i:60;s:12:"reverse_link";i:0;s:13:"default_value";a:1:{i:0;a:1:{s:3:"uid";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:5:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => '',
  'widget_module' => 'userreference',
  'widget_active' => '1',
])
->execute();
$connection->schema()->createTable('content_type_employee', [
  'fields' => [
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'field_commander_uid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_company_2_nid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_company_3_nid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_company_4_nid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_sync_email' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
  ],
  'primary key' => [
    'vid',
  ],
  'indexes' => [
    'nid' => [
      'nid',
    ],
    'field_commander_uid' => [
      'field_commander_uid',
    ],
    'field_company_2_nid' => [
      'field_company_2_nid',
    ],
    'field_company_3_nid' => [
      'field_company_3_nid',
    ],
    'field_company_4_nid' => [
      'field_company_4_nid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('content_type_page', [
  'fields' => [
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'field_text_field_value' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'field_reference_nid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_reference_2_nid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'vid',
  ],
  'indexes' => [
    'field_reference_nid' => [
      'field_reference_nid',
    ],
    'field_reference_2_nid' => [
      'field_reference_2_nid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('content_type_story', [
  'fields' => [
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'vid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_test_three_value' => [
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '2',
    ],
    'field_test_identical1_value' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_test_identical2_value' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_test_link_url' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '2048',
    ],
    'field_test_link_title' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
    'field_test_link_attributes' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'field_test_date_value' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '20',
    ],
    'field_test_datestamp_value' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'field_test_datetime_value' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '100',
    ],
    'field_test_email_email' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
    'field_test_filefield_fid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'field_test_filefield_list' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'field_test_filefield_data' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'field_test_four_value' => [
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '0',
    ],
    'field_test_integer_selectlist_value' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'field_test_float_single_checkbox_value' => [
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '0',
    ],
    'field_test_decimal_radio_buttons_value' => [
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '2',
    ],
    'field_test_phone_value' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
    'field_test_exclude_unset_value' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'field_test_exclude_unset_format' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_test_imagefield_fid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'field_test_imagefield_list' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'field_test_imagefield_data' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'field_test_text_single_checkbox2_value' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ],
    'field_test_datestamp_value2' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'field_test_datetime_value2' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '100',
    ],
    'field_test_string_selectlist_value' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ],
    'field_user_reference_2_uid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'field_node_reference_2_nid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'vid',
  ],
  'indexes' => [
    'nid' => [
      'nid',
    ],
    'field_user_reference_2_uid' => [
      'field_user_reference_2_uid',
    ],
    'field_node_reference_2_nid' => [
      'field_node_reference_2_nid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('content_type_test_page', [
  'fields' => [
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'field_test_value' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'field_test_format' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'vid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('content_type_test_planet', [
  'fields' => [
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'vid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'vid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('date_format_locale', [
  'fields' => [
    'format' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '200',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
    ],
  ],
  'primary key' => [
    'type',
    'language',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('date_format_types', [
  'fields' => [
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '200',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ],
    'locked' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'type',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('date_format_types')
->fields([
  'type',
  'title',
  'locked',
])
->values([
  'type' => 'long',
  'title' => 'Long',
  'locked' => '1',
])
->values([
  'type' => 'medium',
  'title' => 'Medium',
  'locked' => '1',
])
->values([
  'type' => 'short',
  'title' => 'Short',
  'locked' => '1',
])
->execute();
$connection->schema()->createTable('date_formats', [
  'fields' => [
    'dfid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'format' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '200',
    ],
    'locked' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'dfid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('date_formats')
->fields([
  'dfid',
  'format',
  'type',
  'locked',
])
->values([
  'dfid' => '1',
  'format' => 'Y-m-d H:i',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '2',
  'format' => 'm/d/Y - H:i',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '3',
  'format' => 'd/m/Y - H:i',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '4',
  'format' => 'Y/m/d - H:i',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '5',
  'format' => 'd.m.Y - H:i',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '6',
  'format' => 'm/d/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '7',
  'format' => 'd/m/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '8',
  'format' => 'Y/m/d - g:ia',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '9',
  'format' => 'M j Y - H:i',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '10',
  'format' => 'j M Y - H:i',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '11',
  'format' => 'Y M j - H:i',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '12',
  'format' => 'M j Y - g:ia',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '13',
  'format' => 'j M Y - g:ia',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '14',
  'format' => 'Y M j - g:ia',
  'type' => 'short',
  'locked' => '1',
])
->values([
  'dfid' => '15',
  'format' => 'D, Y-m-d H:i',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '16',
  'format' => 'D, m/d/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '17',
  'format' => 'D, d/m/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '18',
  'format' => 'D, Y/m/d - H:i',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '19',
  'format' => 'F j, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '20',
  'format' => 'j F, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '21',
  'format' => 'Y, F j - H:i',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '22',
  'format' => 'D, m/d/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '23',
  'format' => 'D, d/m/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '24',
  'format' => 'D, Y/m/d - g:ia',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '25',
  'format' => 'F j, Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '26',
  'format' => 'j F Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '27',
  'format' => 'Y, F j - g:ia',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '28',
  'format' => 'j. F Y - G:i',
  'type' => 'medium',
  'locked' => '1',
])
->values([
  'dfid' => '29',
  'format' => 'l, F j, Y - H:i',
  'type' => 'long',
  'locked' => '1',
])
->values([
  'dfid' => '30',
  'format' => 'l, j F, Y - H:i',
  'type' => 'long',
  'locked' => '1',
])
->values([
  'dfid' => '31',
  'format' => 'l, Y,  F j - H:i',
  'type' => 'long',
  'locked' => '1',
])
->values([
  'dfid' => '32',
  'format' => 'l, F j, Y - g:ia',
  'type' => 'long',
  'locked' => '1',
])
->values([
  'dfid' => '33',
  'format' => 'l, j F Y - g:ia',
  'type' => 'long',
  'locked' => '1',
])
->values([
  'dfid' => '34',
  'format' => 'l, Y,  F j - g:ia',
  'type' => 'long',
  'locked' => '1',
])
->values([
  'dfid' => '35',
  'format' => 'l, j. F Y - G:i',
  'type' => 'long',
  'locked' => '1',
])
->execute();
$connection->schema()->createTable('event', [
  'fields' => [
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'event_start' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ],
    'event_end' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ],
    'timezone' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'start_in_dst' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'end_in_dst' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'has_time' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ],
    'has_end_date' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ],
  ],
  'primary key' => [
    'nid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('event_timezones', [
  'fields' => [
    'timezone' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'offset' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
      'default' => '00:00:00',
    ],
    'offset_dst' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
      'default' => '00:00:00',
    ],
    'dst_region' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'is_dst' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'timezone',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('files', [
  'fields' => [
    'fid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'filename' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'filepath' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'filemime' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'filesize' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'fid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('filter_formats', [
  'fields' => [
    'format' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'roles' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'cache' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'format',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('filter_formats')
->fields([
  'format',
  'name',
  'roles',
  'cache',
])
->values([
  'format' => '1',
  'name' => 'Filtered HTML',
  'roles' => ',1,2,',
  'cache' => '1',
])
->values([
  'format' => '2',
  'name' => 'Full HTML',
  'roles' => '3',
  'cache' => '1',
])
->values([
  'format' => '3',
  'name' => 'Escape HTML Filter',
  'roles' => '',
  'cache' => '1',
])
->values([
  'format' => '4',
  'name' => 'PHP Code',
  'roles' => ',3,4,5,',
  'cache' => '0',
])
->execute();
$connection->schema()->createTable('filters', [
  'fields' => [
    'fid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'format' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'delta' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'fid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('filters')
->fields([
  'fid',
  'format',
  'module',
  'delta',
  'weight',
])
->values([
  'fid' => '1',
  'format' => '1',
  'module' => 'filter',
  'delta' => '2',
  'weight' => '0',
])
->values([
  'fid' => '2',
  'format' => '1',
  'module' => 'filter',
  'delta' => '0',
  'weight' => '1',
])
->values([
  'fid' => '3',
  'format' => '1',
  'module' => 'filter',
  'delta' => '1',
  'weight' => '2',
])
->values([
  'fid' => '4',
  'format' => '1',
  'module' => 'filter',
  'delta' => '3',
  'weight' => '10',
])
->values([
  'fid' => '5',
  'format' => '2',
  'module' => 'filter',
  'delta' => '2',
  'weight' => '0',
])
->values([
  'fid' => '6',
  'format' => '2',
  'module' => 'filter',
  'delta' => '1',
  'weight' => '1',
])
->values([
  'fid' => '7',
  'format' => '2',
  'module' => 'filter',
  'delta' => '3',
  'weight' => '10',
])
->values([
  'fid' => '8',
  'format' => '6',
  'module' => 'filter',
  'delta' => '2',
  'weight' => '0',
])
->values([
  'fid' => '9',
  'format' => '6',
  'module' => 'filter',
  'delta' => '0',
  'weight' => '1',
])
->values([
  'fid' => '10',
  'format' => '6',
  'module' => 'filter',
  'delta' => '1',
  'weight' => '2',
])
->values([
  'fid' => '11',
  'format' => '6',
  'module' => 'filter',
  'delta' => '3',
  'weight' => '10',
])
->values([
  'fid' => '16',
  'format' => '4',
  'module' => 'php',
  'delta' => '0',
  'weight' => '10',
])
->execute();
$connection->schema()->createTable('flood', [
  'fields' => [
    'fid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'event' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'hostname' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'fid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('forum', [
  'fields' => [
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'tid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'vid',
  ],
  'indexes' => [
    'nid' => [
      'nid',
    ],
    'tid' => [
      'tid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('history', [
  'fields' => [
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'uid',
    'nid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('i18n_blocks', [
  'fields' => [
    'ibid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ],
    'delta' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '0',
    ],
    'type' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
  ],
  'primary key' => [
    'ibid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('i18n_strings', [
  'fields' => [
    'lid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'objectid' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'property' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'objectindex' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'format' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'lid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('i18n_strings')
->fields([
  'lid',
  'objectid',
  'type',
  'property',
  'objectindex',
  'format',
])
->values([
  'lid' => '504',
  'objectid' => 'profile_color',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '505',
  'objectid' => 'profile_color',
  'type' => 'field',
  'property' => 'explanation',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '506',
  'objectid' => '',
  'type' => 'category',
  'property' => '',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '507',
  'objectid' => 'profile_biography',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '508',
  'objectid' => 'profile_biography',
  'type' => 'field',
  'property' => 'explanation',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '509',
  'objectid' => 'profile_sell_Address',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '510',
  'objectid' => 'profile_sell_Address',
  'type' => 'field',
  'property' => 'explanation',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '511',
  'objectid' => '',
  'type' => 'category',
  'property' => '',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '512',
  'objectid' => 'profile_sold_to',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '513',
  'objectid' => 'profile_sold_to',
  'type' => 'field',
  'property' => 'explanation',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '514',
  'objectid' => 'profile_sold_to',
  'type' => 'field',
  'property' => 'options',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '515',
  'objectid' => '',
  'type' => 'category',
  'property' => '',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '516',
  'objectid' => 'profile_bands',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '517',
  'objectid' => 'profile_bands',
  'type' => 'field',
  'property' => 'explanation',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '518',
  'objectid' => 'profile_birthdate',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '519',
  'objectid' => 'profile_birthdate',
  'type' => 'field',
  'property' => 'explanation',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '520',
  'objectid' => 'profile_really_really_love_migrations',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '521',
  'objectid' => 'profile_really_really_love_migrations',
  'type' => 'field',
  'property' => 'explanation',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '522',
  'objectid' => 'profile_blog',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '523',
  'objectid' => 'profile_blog',
  'type' => 'field',
  'property' => 'explanation',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '524',
  'objectid' => '1',
  'type' => 'block',
  'property' => 'title',
  'objectindex' => '1',
  'format' => '0',
])
->values([
  'lid' => '525',
  'objectid' => '1',
  'type' => 'block',
  'property' => 'body',
  'objectindex' => '1',
  'format' => '2',
])
->values([
  'lid' => '526',
  'objectid' => '2',
  'type' => 'block',
  'property' => 'title',
  'objectindex' => '2',
  'format' => '0',
])
->values([
  'lid' => '527',
  'objectid' => '2',
  'type' => 'block',
  'property' => 'body',
  'objectindex' => '2',
  'format' => '2',
])
->values([
  'lid' => '528',
  'objectid' => '4',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '4',
  'format' => '0',
])
->values([
  'lid' => '529',
  'objectid' => '1',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '1',
  'format' => '0',
])
->values([
  'lid' => '530',
  'objectid' => '2',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '2',
  'format' => '0',
])
->values([
  'lid' => '531',
  'objectid' => '3',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '3',
  'format' => '0',
])
->values([
  'lid' => '532',
  'objectid' => '5',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '5',
  'format' => '0',
])
->values([
  'lid' => '533',
  'objectid' => 'article',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '534',
  'objectid' => 'article',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '535',
  'objectid' => 'article',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '536',
  'objectid' => 'article',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '537',
  'objectid' => 'company',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '538',
  'objectid' => 'company',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '539',
  'objectid' => 'company',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '540',
  'objectid' => 'company',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '541',
  'objectid' => 'employee',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '542',
  'objectid' => 'employee',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '543',
  'objectid' => 'employee',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '544',
  'objectid' => 'employee',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '545',
  'objectid' => 'sponsor',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '546',
  'objectid' => 'sponsor',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '547',
  'objectid' => 'sponsor',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '548',
  'objectid' => 'sponsor',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '549',
  'objectid' => 'story',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '550',
  'objectid' => 'story',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '551',
  'objectid' => 'story',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '552',
  'objectid' => 'story',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '553',
  'objectid' => 'test_event',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '554',
  'objectid' => 'test_event',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '555',
  'objectid' => 'test_event',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '556',
  'objectid' => 'test_event',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '558',
  'objectid' => 'test_page',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '559',
  'objectid' => 'test_page',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '560',
  'objectid' => 'test_page',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '561',
  'objectid' => 'test_page',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '562',
  'objectid' => 'test_planet',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '563',
  'objectid' => 'test_planet',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '564',
  'objectid' => 'test_planet',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '565',
  'objectid' => 'test_planet',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '566',
  'objectid' => 'test_story',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '567',
  'objectid' => 'test_story',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '568',
  'objectid' => 'test_story',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '569',
  'objectid' => 'test_story',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '570',
  'objectid' => 'story-field_test_exclude_unset',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '571',
  'objectid' => 'story-field_test_exclude_unset',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '572',
  'objectid' => 'story-field_test_two',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '573',
  'objectid' => 'story-field_test_two',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '574',
  'objectid' => 'story-field_test',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '575',
  'objectid' => 'story-field_test',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '576',
  'objectid' => 'story-field_test_three',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '577',
  'objectid' => 'story-field_test_three',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '578',
  'objectid' => 'story-field_test_four',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '579',
  'objectid' => 'story-field_test_four',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '580',
  'objectid' => 'story-field_test_identical1',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '581',
  'objectid' => 'story-field_test_identical1',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '582',
  'objectid' => 'story-field_test_identical2',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '583',
  'objectid' => 'story-field_test_identical2',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '584',
  'objectid' => 'story-field_test_email',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '585',
  'objectid' => 'story-field_test_email',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '586',
  'objectid' => 'story-field_test_link',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '587',
  'objectid' => 'story-field_test_link',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '588',
  'objectid' => 'story-field_test_filefield',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '589',
  'objectid' => 'story-field_test_filefield',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '590',
  'objectid' => 'story-field_test_imagefield',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '591',
  'objectid' => 'story-field_test_imagefield',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '592',
  'objectid' => 'story-field_test_date',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '593',
  'objectid' => 'story-field_test_date',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '594',
  'objectid' => 'story-field_test_datestamp',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '595',
  'objectid' => 'story-field_test_datestamp',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '596',
  'objectid' => 'story-field_test_datetime',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '597',
  'objectid' => 'story-field_test_datetime',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '598',
  'objectid' => 'story-field_test_phone',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '599',
  'objectid' => 'story-field_test_phone',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '600',
  'objectid' => 'story-field_test_decimal_radio_buttons',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '601',
  'objectid' => 'story-field_test_decimal_radio_buttons',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '602',
  'objectid' => 'field_test_decimal_radio_buttons',
  'type' => 'field',
  'property' => 'option_1.2',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '603',
  'objectid' => 'field_test_decimal_radio_buttons',
  'type' => 'field',
  'property' => 'option_2.1',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '604',
  'objectid' => 'story-field_test_float_single_checkbox',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '605',
  'objectid' => 'story-field_test_float_single_checkbox',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '606',
  'objectid' => 'field_test_float_single_checkbox',
  'type' => 'field',
  'property' => 'option_3.142',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '607',
  'objectid' => 'field_test_float_single_checkbox',
  'type' => 'field',
  'property' => 'option_1.234',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '608',
  'objectid' => 'story-field_test_integer_selectlist',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '609',
  'objectid' => 'story-field_test_integer_selectlist',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '610',
  'objectid' => 'field_test_integer_selectlist',
  'type' => 'field',
  'property' => 'option_1234',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '611',
  'objectid' => 'field_test_integer_selectlist',
  'type' => 'field',
  'property' => 'option_2341',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '612',
  'objectid' => 'field_test_integer_selectlist',
  'type' => 'field',
  'property' => 'option_3412',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '613',
  'objectid' => 'field_test_integer_selectlist',
  'type' => 'field',
  'property' => 'option_4123',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '614',
  'objectid' => 'story-field_test_text_single_checkbox',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '615',
  'objectid' => 'story-field_test_text_single_checkbox',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '616',
  'objectid' => 'field_test_text_single_checkbox',
  'type' => 'field',
  'property' => 'option_0',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '617',
  'objectid' => 'field_test_text_single_checkbox',
  'type' => 'field',
  'property' => 'option_1',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '618',
  'objectid' => 'story-field_test_text_single_checkbox2',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '619',
  'objectid' => 'story-field_test_text_single_checkbox2',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '620',
  'objectid' => 'field_test_text_single_checkbox2',
  'type' => 'field',
  'property' => 'option_Off',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '621',
  'objectid' => 'field_test_text_single_checkbox2',
  'type' => 'field',
  'property' => 'option_Hello',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '622',
  'objectid' => 'test_page-field_test',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '623',
  'objectid' => 'test_page-field_test',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '624',
  'objectid' => 'test_planet-field_multivalue',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '625',
  'objectid' => 'test_planet-field_multivalue',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '626',
  'objectid' => 'test_planet-field_test_text_single_checkbox',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '627',
  'objectid' => 'test_planet-field_test_text_single_checkbox',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '633',
  'objectid' => '140',
  'type' => 'item',
  'property' => 'title',
  'objectindex' => '140',
  'format' => '0',
])
->values([
  'lid' => '634',
  'objectid' => '139',
  'type' => 'item',
  'property' => 'title',
  'objectindex' => '139',
  'format' => '0',
])
->values([
  'lid' => '635',
  'objectid' => '139',
  'type' => 'item',
  'property' => 'description',
  'objectindex' => '139',
  'format' => '0',
])
->values([
  'lid' => '1664',
  'objectid' => 'forum',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '1665',
  'objectid' => 'forum',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '1666',
  'objectid' => 'forum',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '1667',
  'objectid' => 'forum',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '1672',
  'objectid' => '6',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '6',
  'format' => '0',
])
->values([
  'lid' => '1673',
  'objectid' => '7',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '7',
  'format' => '0',
])
->values([
  'lid' => '1674',
  'objectid' => '463',
  'type' => 'item',
  'property' => 'title',
  'objectindex' => '463',
  'format' => '0',
])
->values([
  'lid' => '1675',
  'objectid' => '463',
  'type' => 'item',
  'property' => 'description',
  'objectindex' => '463',
  'format' => '0',
])
->values([
  'lid' => '1676',
  'objectid' => '138',
  'type' => 'item',
  'property' => 'title',
  'objectindex' => '138',
  'format' => '0',
])
->values([
  'lid' => '1677',
  'objectid' => '138',
  'type' => 'item',
  'property' => 'description',
  'objectindex' => '138',
  'format' => '0',
])
->values([
  'lid' => '1678',
  'objectid' => 'profile_really_really_love_migrating',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '1679',
  'objectid' => 'menu-translation-test',
  'type' => 'menu',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '1680',
  'objectid' => 'employee-field_company',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '1681',
  'objectid' => 'employee-field_commander',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '1682',
  'objectid' => 'employee-field_company_2',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '1683',
  'objectid' => 'employee-field_company_3',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '1684',
  'objectid' => 'page-field_reference',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '1685',
  'objectid' => 'page-field_reference_2',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '1686',
  'objectid' => 'story-field_test_string_selectlist',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '1689',
  'objectid' => 'test_planet-field_test_text_single_checkbox',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '1690',
  'objectid' => 'field_test_string_selectlist',
  'type' => 'field',
  'property' => 'option_A',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '1691',
  'objectid' => 'field_test_string_selectlist',
  'type' => 'field',
  'property' => 'option_B',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '1692',
  'objectid' => '14',
  'type' => 'term',
  'property' => 'name',
  'objectindex' => '14',
  'format' => '0',
])
->values([
  'lid' => '1693',
  'objectid' => '15',
  'type' => 'term',
  'property' => 'name',
  'objectindex' => '15',
  'format' => '0',
])
->values([
  'lid' => '1694',
  'objectid' => '14',
  'type' => 'term',
  'property' => 'description',
  'objectindex' => '14',
  'format' => '0',
])
->values([
  'lid' => '1695',
  'objectid' => 'profile_count_trees',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
])
->values([
  'lid' => '1696',
  'objectid' => 'profile_count_trees',
  'type' => 'field',
  'property' => 'options',
  'objectindex' => '0',
  'format' => '0',
])
->execute();
$connection->schema()->createTable('i18n_variable', [
  'fields' => [
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
    'value' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ],
  ],
  'primary key' => [
    'name',
    'language',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('i18n_variable')
->fields([
  'name',
  'language',
  'value',
])
->values([
  'name' => 'anonymous',
  'language' => 'fr',
  'value' => 's:8:"fr Guest";',
])
->values([
  'name' => 'anonymous',
  'language' => 'zu',
  'value' => 's:5:"Guest";',
])
->values([
  'name' => 'array_filter',
  'language' => 'en',
  'value' => 'b:1;',
])
->values([
  'name' => 'error_level',
  'language' => 'fr',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'error_level',
  'language' => 'zu',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'i18nstrings_allowed_formats',
  'language' => 'en',
  'value' => 'a:2:{i:0;i:1;i:1;i:2;}',
])
->values([
  'name' => 'site_403',
  'language' => 'fr',
  'value' => 's:7:"fr-user";',
])
->values([
  'name' => 'site_403',
  'language' => 'zu',
  'value' => 's:7:"zu-user";',
])
->values([
  'name' => 'site_404',
  'language' => 'fr',
  'value' => 's:17:"fr-page-not-found";',
])
->values([
  'name' => 'site_404',
  'language' => 'zu',
  'value' => 's:17:"zu-page-not-found";',
])
->values([
  'name' => 'site_footer',
  'language' => 'fr',
  'value' => 's:0:"";',
])
->values([
  'name' => 'site_footer',
  'language' => 'zu',
  'value' => 's:0:"";',
])
->values([
  'name' => 'site_frontpage',
  'language' => 'fr',
  'value' => 's:4:"node";',
])
->values([
  'name' => 'site_frontpage',
  'language' => 'zu',
  'value' => 's:4:"node";',
])
->values([
  'name' => 'site_mail',
  'language' => 'fr',
  'value' => 's:24:"fr_site_mail@example.com";',
])
->values([
  'name' => 'site_mail',
  'language' => 'zu',
  'value' => 's:21:"site_mail@example.com";',
])
->values([
  'name' => 'site_mission',
  'language' => 'fr',
  'value' => 's:0:"";',
])
->values([
  'name' => 'site_mission',
  'language' => 'zu',
  'value' => 's:0:"";',
])
->values([
  'name' => 'site_name',
  'language' => 'fr',
  'value' => 's:12:"fr site name";',
])
->values([
  'name' => 'site_name',
  'language' => 'zu',
  'value' => 's:14:"zu - site_name";',
])
->values([
  'name' => 'site_offline',
  'language' => 'fr',
  'value' => 's:1:"0";',
])
->values([
  'name' => 'site_offline_message',
  'language' => 'fr',
  'value' => 's:99:"fr - Drupal is currently under maintenance. We should be back shortly. Thank you for your patience.";',
])
->values([
  'name' => 'site_slogan',
  'language' => 'fr',
  'value' => 's:16:"fr Migrate rocks";',
])
->values([
  'name' => 'site_slogan',
  'language' => 'zu',
  'value' => 's:13:"Migrate rocks";',
])
->values([
  'name' => 'statistics_count_content_views',
  'language' => 'en',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'statistics_enable_access_log',
  'language' => 'en',
  'value' => 's:1:"0";',
])
->values([
  'name' => 'statistics_flush_accesslog_timer',
  'language' => 'en',
  'value' => 's:6:"259200";',
])
->values([
  'name' => 'user_email_verification',
  'language' => 'fr',
  'value' => 'i:0;',
])
->values([
  'name' => 'user_email_verification',
  'language' => 'zu',
  'value' => 'i:0;',
])
->values([
  'name' => 'user_mail_password_reset_body',
  'language' => 'fr',
  'value' => "s:424:\"fr - !username,\r\n\r\nA request to reset the password for your account has been made at !site.\r\n\r\nYou may now log in to !uri_brief by clicking on this link or copying and pasting it in your browser:\r\n\r\n!login_url\r\n\r\nThis is a one-time login, so it can be used only once. It expires after one day and nothing will happen if it's not used.\r\n\r\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\";",
])
->values([
  'name' => 'user_mail_password_reset_body',
  'language' => 'zu',
  'value' => "s:419:\"!username,\r\n\r\nA request to reset the password for your account has been made at !site.\r\n\r\nYou may now log in to !uri_brief by clicking on this link or copying and pasting it in your browser:\r\n\r\n!login_url\r\n\r\nThis is a one-time login, so it can be used only once. It expires after one day and nothing will happen if it's not used.\r\n\r\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\";",
])
->values([
  'name' => 'user_mail_password_reset_subject',
  'language' => 'fr',
  'value' => 's:57:"fr - Replacement login information for !username at !site";',
])
->values([
  'name' => 'user_mail_password_reset_subject',
  'language' => 'zu',
  'value' => 's:52:"Replacement login information for !username at !site";',
])
->values([
  'name' => 'user_mail_register_admin_created_body',
  'language' => 'fr',
  'value' => "s:473:\"fr - !username,\r\n\r\nA site administrator at !site has created an account for you. You may now log in to !login_uri using the following username and password:\r\n\r\nusername: !username\r\npassword: !password\r\n\r\nYou may also log in by clicking on this link or copying and pasting it in your browser:\r\n\r\n!login_url\r\n\r\nThis is a one-time login, so it can be used only once.\r\n\r\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\r\n\r\n\r\n--  !site team\";",
])
->values([
  'name' => 'user_mail_register_admin_created_body',
  'language' => 'zu',
  'value' => "s:473:\"zu - !username,\r\n\r\nA site administrator at !site has created an account for you. You may now log in to !login_uri using the following username and password:\r\n\r\nusername: !username\r\npassword: !password\r\n\r\nYou may also log in by clicking on this link or copying and pasting it in your browser:\r\n\r\n!login_url\r\n\r\nThis is a one-time login, so it can be used only once.\r\n\r\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\r\n\r\n\r\n--  !site team\";",
])
->values([
  'name' => 'user_mail_register_admin_created_subject',
  'language' => 'fr',
  'value' => 's:57:"fr - An administrator created an account for you at !site";',
])
->values([
  'name' => 'user_mail_register_admin_created_subject',
  'language' => 'zu',
  'value' => 's:57:"zu - An administrator created an account for you at !site";',
])
->values([
  'name' => 'user_mail_register_no_approval_required_body',
  'language' => 'fr',
  'value' => "s:447:\"fr - !username,\r\n\r\nThank you for registering at !site. You may now log in to !login_uri using the following username and password:\r\n\r\nusername: !username\r\npassword: !password\r\n\r\nYou may also log in by clicking on this link or copying and pasting it in your browser:\r\n\r\n!login_url\r\n\r\nThis is a one-time login, so it can be used only once.\r\n\r\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\r\n\r\n\r\n--  !site team\";",
])
->values([
  'name' => 'user_mail_register_no_approval_required_body',
  'language' => 'zu',
  'value' => "s:442:\"!username,\r\n\r\nThank you for registering at !site. You may now log in to !login_uri using the following username and password:\r\n\r\nusername: !username\r\npassword: !password\r\n\r\nYou may also log in by clicking on this link or copying and pasting it in your browser:\r\n\r\n!login_url\r\n\r\nThis is a one-time login, so it can be used only once.\r\n\r\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\r\n\r\n\r\n--  !site team\";",
])
->values([
  'name' => 'user_mail_register_no_approval_required_subject',
  'language' => 'fr',
  'value' => 's:43:"fr - Account details for !username at !site";',
])
->values([
  'name' => 'user_mail_register_no_approval_required_subject',
  'language' => 'zu',
  'value' => 's:38:"Account details for !username at !site";',
])
->values([
  'name' => 'user_mail_register_pending_approval_admin_body',
  'language' => 'fr',
  'value' => 's:59:"fr - !username has applied for an account.\r\n\r\n!edit_uri";',
])
->values([
  'name' => 'user_mail_register_pending_approval_admin_body',
  'language' => 'zu',
  'value' => 's:54:"!username has applied for an account.\r\n\r\n!edit_uri";',
])
->values([
  'name' => 'user_mail_register_pending_approval_admin_subject',
  'language' => 'fr',
  'value' => 's:68:"fr - Account details for !username at !site (pending admin approval)";',
])
->values([
  'name' => 'user_mail_register_pending_approval_admin_subject',
  'language' => 'zu',
  'value' => 's:63:"Account details for !username at !site (pending admin approval)";',
])
->values([
  'name' => 'user_mail_register_pending_approval_body',
  'language' => 'fr',
  'value' => "s:277:\"fr - !username,\r\n\r\nThank you for registering at !site. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\r\n\r\n\r\n--  !site team\";",
])
->values([
  'name' => 'user_mail_register_pending_approval_body',
  'language' => 'zu',
  'value' => "s:272:\"!username,\r\n\r\nThank you for registering at !site. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\r\n\r\n\r\n--  !site team\";",
])
->values([
  'name' => 'user_mail_register_pending_approval_subject',
  'language' => 'fr',
  'value' => 's:68:"fr - Account details for !username at !site (pending admin approval)";',
])
->values([
  'name' => 'user_mail_register_pending_approval_subject',
  'language' => 'zu',
  'value' => 's:63:"Account details for !username at !site (pending admin approval)";',
])
->values([
  'name' => 'user_mail_status_activated_body',
  'language' => 'fr',
  'value' => "s:439:\"fr - !username,\r\n\r\nYour account at !site has been activated.\r\n\r\nYou may now log in by clicking on this link or copying and pasting it in your browser:\r\n\r\n!login_url\r\n\r\nThis is a one-time login, so it can be used only once.\r\n\r\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\r\n\r\nOnce you have set your own password, you will be able to log in to !login_uri in the future using:\r\n\r\nusername: !username\r\n\";",
])
->values([
  'name' => 'user_mail_status_activated_body',
  'language' => 'zu',
  'value' => "s:434:\"!username,\r\n\r\nYour account at !site has been activated.\r\n\r\nYou may now log in by clicking on this link or copying and pasting it in your browser:\r\n\r\n!login_url\r\n\r\nThis is a one-time login, so it can be used only once.\r\n\r\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\r\n\r\nOnce you have set your own password, you will be able to log in to !login_uri in the future using:\r\n\r\nusername: !username\r\n\";",
])
->values([
  'name' => 'user_mail_status_activated_notify',
  'language' => 'fr',
  'value' => 'i:0;',
])
->values([
  'name' => 'user_mail_status_activated_notify',
  'language' => 'zu',
  'value' => 'i:0;',
])
->values([
  'name' => 'user_mail_status_activated_subject',
  'language' => 'fr',
  'value' => 's:54:"fr - Account details for !username at !site (approved)";',
])
->values([
  'name' => 'user_mail_status_activated_subject',
  'language' => 'zu',
  'value' => 's:49:"Account details for !username at !site (approved)";',
])
->values([
  'name' => 'user_mail_status_blocked_body',
  'language' => 'fr',
  'value' => "s:58:\"fr - !username,\r\n\r\nYour account on !site has been blocked.\";",
])
->values([
  'name' => 'user_mail_status_blocked_body',
  'language' => 'zu',
  'value' => "s:53:\"!username,\r\n\r\nYour account on !site has been blocked.\";",
])
->values([
  'name' => 'user_mail_status_blocked_notify',
  'language' => 'fr',
  'value' => 'i:1;',
])
->values([
  'name' => 'user_mail_status_blocked_notify',
  'language' => 'zu',
  'value' => 'i:1;',
])
->values([
  'name' => 'user_mail_status_blocked_subject',
  'language' => 'fr',
  'value' => 's:53:"fr - Account details for !username at !site (blocked)";',
])
->values([
  'name' => 'user_mail_status_blocked_subject',
  'language' => 'zu',
  'value' => 's:48:"Account details for !username at !site (blocked)";',
])
->values([
  'name' => 'user_mail_status_canceled_body',
  'language' => 'fr',
  'value' => 's:63:"fr - !username,\r\n\r\nYour account on !site has been canceled.";',
])
->values([
  'name' => 'user_mail_status_canceled_body',
  'language' => 'zu',
  'value' => 's:58:"!username,\r\n\r\nYour account on !site has been canceled.";',
])
->values([
  'name' => 'user_mail_status_canceled_subject',
  'language' => 'fr',
  'value' => 's:54:"fr - Account details for !username at !site (canceled)";',
])
->values([
  'name' => 'user_mail_status_canceled_subject',
  'language' => 'zu',
  'value' => 's:49:"Account details for !username at !site (canceled)";',
])
->values([
  'name' => 'user_mail_status_deleted_body',
  'language' => 'fr',
  'value' => "s:58:\"fr - !username,\r\n\r\nYour account on !site has been deleted.\";",
])
->values([
  'name' => 'user_mail_status_deleted_body',
  'language' => 'zu',
  'value' => "s:53:\"!username,\r\n\r\nYour account on !site has been deleted.\";",
])
->values([
  'name' => 'user_mail_status_deleted_notify',
  'language' => 'fr',
  'value' => 'i:0;',
])
->values([
  'name' => 'user_mail_status_deleted_notify',
  'language' => 'zu',
  'value' => 'i:0;',
])
->values([
  'name' => 'user_mail_status_deleted_subject',
  'language' => 'fr',
  'value' => 's:53:"fr - Account details for !username at !site (deleted)";',
])
->values([
  'name' => 'user_mail_status_deleted_subject',
  'language' => 'zu',
  'value' => 's:48:"Account details for !username at !site (deleted)";',
])
->values([
  'name' => 'user_pictures',
  'language' => 'fr',
  'value' => 's:1:"0";',
])
->values([
  'name' => 'user_pictures',
  'language' => 'zu',
  'value' => 's:1:"0";',
])
->values([
  'name' => 'user_picture_default',
  'language' => 'fr',
  'value' => 's:0:"";',
])
->values([
  'name' => 'user_picture_default',
  'language' => 'zu',
  'value' => 's:0:"";',
])
->values([
  'name' => 'user_picture_dimensions',
  'language' => 'fr',
  'value' => 's:5:"85x85";',
])
->values([
  'name' => 'user_picture_dimensions',
  'language' => 'zu',
  'value' => 's:5:"85x85";',
])
->values([
  'name' => 'user_picture_file_size',
  'language' => 'fr',
  'value' => 's:2:"30";',
])
->values([
  'name' => 'user_picture_file_size',
  'language' => 'zu',
  'value' => 's:2:"30";',
])
->values([
  'name' => 'user_picture_guidelines',
  'language' => 'fr',
  'value' => 's:0:"";',
])
->values([
  'name' => 'user_picture_guidelines',
  'language' => 'zu',
  'value' => 's:0:"";',
])
->values([
  'name' => 'user_picture_path',
  'language' => 'fr',
  'value' => 's:8:"pictures";',
])
->values([
  'name' => 'user_picture_path',
  'language' => 'zu',
  'value' => 's:8:"pictures";',
])
->values([
  'name' => 'user_register',
  'language' => 'fr',
  'value' => 's:1:"0";',
])
->values([
  'name' => 'user_register',
  'language' => 'zu',
  'value' => 's:1:"0";',
])
->values([
  'name' => 'user_registration_help',
  'language' => 'fr',
  'value' => 's:0:"";',
])
->values([
  'name' => 'user_registration_help',
  'language' => 'zu',
  'value' => 's:0:"";',
])
->values([
  'name' => 'user_signatures',
  'language' => 'fr',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'user_signatures',
  'language' => 'zu',
  'value' => 's:1:"1";',
])
->execute();
$connection->schema()->createTable('imagecache_action', [
  'fields' => [
    'actionid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'presetid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ],
    'action' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ],
    'data' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'actionid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('imagecache_preset', [
  'fields' => [
    'presetid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'presetname' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ],
  ],
  'primary key' => [
    'presetid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('languages', [
  'fields' => [
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'native' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'direction' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'enabled' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'plurals' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'formula' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'domain' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'prefix' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'javascript' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
  ],
  'primary key' => [
    'language',
  ],
  'indexes' => [
    'list' => [
      'weight',
      'name',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('languages')
->fields([
  'language',
  'name',
  'native',
  'direction',
  'enabled',
  'plurals',
  'formula',
  'domain',
  'prefix',
  'weight',
  'javascript',
])
->values([
  'language' => 'en',
  'name' => 'English',
  'native' => 'English',
  'direction' => '0',
  'enabled' => '1',
  'plurals' => '0',
  'formula' => '',
  'domain' => '',
  'prefix' => '',
  'weight' => '0',
  'javascript' => '',
])
->values([
  'language' => 'fr',
  'name' => 'French',
  'native' => 'Français',
  'direction' => '0',
  'enabled' => '1',
  'plurals' => '2',
  'formula' => '($n>1)',
  'domain' => 'http://fr.drupal.org',
  'prefix' => 'fr',
  'weight' => '0',
  'javascript' => '047746d30d76aa44a54db9923c7c5fb0',
])
->values([
  'language' => 'zu',
  'name' => 'Zulu',
  'native' => 'isiZulu',
  'direction' => '0',
  'enabled' => '1',
  'plurals' => '0',
  'formula' => '',
  'domain' => 'http://zu.drupal.org',
  'prefix' => 'zu',
  'weight' => '0',
  'javascript' => '',
])
->execute();
$connection->schema()->createTable('locales_source', [
  'fields' => [
    'lid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'location' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'textgroup' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => 'default',
    ],
    'source' => [
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'version' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '20',
      'default' => 'none',
    ],
  ],
  'primary key' => [
    'lid',
  ],
  'indexes' => [
    'source' => [
      [
        'source',
        '30',
      ],
    ],
    'textgroup_location' => [
      [
        'textgroup',
        '30',
      ],
      [
        'location',
        '191',
      ],
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('locales_target', [
  'fields' => [
    'lid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'translation' => [
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
    'plid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'plural' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'i18n_status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'language',
    'lid',
    'plural',
  ],
  'indexes' => [
    'lid' => [
      'lid',
    ],
    'plid' => [
      'plid',
    ],
    'plural' => [
      'plural',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('menu_custom', [
  'fields' => [
    'menu_name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'description' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'menu_name',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('menu_custom')
->fields([
  'menu_name',
  'title',
  'description',
])
->values([
  'menu_name' => 'navigation',
  'title' => 'Navigation',
  'description' => 'The navigation menu is provided by Drupal and is the main interactive menu for any site. It is usually the only menu that contains personalized links for authenticated users, and is often not even visible to anonymous users.',
])
->values([
  'menu_name' => 'primary-links',
  'title' => 'Primary links',
  'description' => 'Primary links are often used at the theme layer to show the major sections of a site. A typical representation for primary links would be tabs along the top.',
])
->values([
  'menu_name' => 'secondary-links',
  'title' => 'Secondary links',
  'description' => 'Secondary links are often used for pages like legal notices, contact details, and other secondary navigation items that play a lesser role than primary links',
])
->execute();
$connection->schema()->createTable('menu_links', [
  'fields' => [
    'menu_name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'mlid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'plid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'link_path' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'router_path' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'link_title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'options' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => 'system',
    ],
    'hidden' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'external' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'has_children' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'expanded' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'depth' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'customized' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'p1' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'p2' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'p3' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'p4' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'p5' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'p6' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'p7' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'p8' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'p9' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'updated' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'mlid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('menu_links')
->fields([
  'menu_name',
  'mlid',
  'plid',
  'link_path',
  'router_path',
  'link_title',
  'options',
  'module',
  'hidden',
  'external',
  'has_children',
  'expanded',
  'weight',
  'depth',
  'customized',
  'p1',
  'p2',
  'p3',
  'p4',
  'p5',
  'p6',
  'p7',
  'p8',
  'p9',
  'updated',
])
->values([
  'menu_name' => 'secondary-links',
  'mlid' => '138',
  'plid' => '139',
  'link_path' => 'user/login',
  'router_path' => 'user/login',
  'link_title' => 'Test 1',
  'options' => 'a:2:{s:10:"attributes";a:1:{s:5:"title";s:16:"Test menu link 1";}s:8:"langcode";s:2:"en";}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-50',
  'depth' => '2',
  'customized' => '1',
  'p1' => '139',
  'p2' => '138',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'secondary-links',
  'mlid' => '139',
  'plid' => '0',
  'link_path' => 'admin',
  'router_path' => 'admin',
  'link_title' => 'Test 2',
  'options' => 'a:2:{s:5:"query";s:7:"foo=bar";s:10:"attributes";a:1:{s:5:"title";s:16:"Test menu link 2";}}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '1',
  'weight' => '-49',
  'depth' => '1',
  'customized' => '1',
  'p1' => '139',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'secondary-links',
  'mlid' => '140',
  'plid' => '0',
  'link_path' => 'https://www.drupal.org',
  'router_path' => '',
  'link_title' => 'Drupal.org',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:0:"";}}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '1',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-50',
  'depth' => '1',
  'customized' => '1',
  'p1' => '140',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '141',
  'plid' => '0',
  'link_path' => 'node',
  'router_path' => 'node',
  'link_title' => 'Content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '141',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '142',
  'plid' => '0',
  'link_path' => 'rss.xml',
  'router_path' => 'rss.xml',
  'link_title' => 'RSS feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '142',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '143',
  'plid' => '0',
  'link_path' => 'batch',
  'router_path' => 'batch',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '143',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '144',
  'plid' => '0',
  'link_path' => 'admin',
  'router_path' => 'admin',
  'link_title' => 'Administer',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '9',
  'depth' => '1',
  'customized' => '0',
  'p1' => '144',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '145',
  'plid' => '0',
  'link_path' => 'contact',
  'router_path' => 'contact',
  'link_title' => 'Contact',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '145',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '147',
  'plid' => '0',
  'link_path' => 'logout',
  'router_path' => 'logout',
  'link_title' => 'Log out',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '147',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '148',
  'plid' => '0',
  'link_path' => 'user',
  'router_path' => 'user',
  'link_title' => 'User account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '148',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '149',
  'plid' => '0',
  'link_path' => 'profile',
  'router_path' => 'profile',
  'link_title' => 'User list',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '149',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '150',
  'plid' => '0',
  'link_path' => 'node/%',
  'router_path' => 'node/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '150',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '151',
  'plid' => '0',
  'link_path' => 'content/js_add_more',
  'router_path' => 'content/js_add_more',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '151',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '152',
  'plid' => '0',
  'link_path' => 'upload/js',
  'router_path' => 'upload/js',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '152',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '153',
  'plid' => '0',
  'link_path' => 'taxonomy/autocomplete',
  'router_path' => 'taxonomy/autocomplete',
  'link_title' => 'Autocomplete taxonomy',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '153',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '155',
  'plid' => '144',
  'link_path' => 'admin/compact',
  'router_path' => 'admin/compact',
  'link_title' => 'Compact mode',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '155',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '156',
  'plid' => '0',
  'link_path' => 'filter/tips',
  'router_path' => 'filter/tips',
  'link_title' => 'Compose tips',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '156',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '157',
  'plid' => '144',
  'link_path' => 'admin/content',
  'router_path' => 'admin/content',
  'link_title' => 'Content management',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:27:\"Manage your site's content.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '158',
  'plid' => '0',
  'link_path' => 'node/add',
  'router_path' => 'node/add',
  'link_title' => 'Create content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '1',
  'customized' => '0',
  'p1' => '158',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '159',
  'plid' => '0',
  'link_path' => 'comment/delete',
  'router_path' => 'comment/delete',
  'link_title' => 'Delete comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '159',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '160',
  'plid' => '0',
  'link_path' => 'comment/edit',
  'router_path' => 'comment/edit',
  'link_title' => 'Edit comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '160',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '161',
  'plid' => '0',
  'link_path' => 'system/files',
  'router_path' => 'system/files',
  'link_title' => 'File download',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '161',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '163',
  'plid' => '149',
  'link_path' => 'profile/autocomplete',
  'router_path' => 'profile/autocomplete',
  'link_title' => 'Profile autocomplete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '149',
  'p2' => '163',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '165',
  'plid' => '144',
  'link_path' => 'admin/reports',
  'router_path' => 'admin/reports',
  'link_title' => 'Reports',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:59:"View reports from system logs and other status information.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '166',
  'plid' => '144',
  'link_path' => 'admin/build',
  'router_path' => 'admin/build',
  'link_title' => 'Site building',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Control how your site looks and feels.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '167',
  'plid' => '144',
  'link_path' => 'admin/settings',
  'router_path' => 'admin/settings',
  'link_title' => 'Site configuration',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:40:"Adjust basic site configuration options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '169',
  'plid' => '0',
  'link_path' => 'user/autocomplete',
  'router_path' => 'user/autocomplete',
  'link_title' => 'User autocomplete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '169',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '170',
  'plid' => '144',
  'link_path' => 'admin/user',
  'router_path' => 'admin/user',
  'link_title' => 'User management',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:61:\"Manage your site's users, groups and access to site features.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '171',
  'plid' => '0',
  'link_path' => 'user/timezone',
  'router_path' => 'user/timezone',
  'link_title' => 'User timezone',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '171',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '172',
  'plid' => '0',
  'link_path' => 'user/%',
  'router_path' => 'user/%',
  'link_title' => 'My account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '172',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '175',
  'plid' => '170',
  'link_path' => 'admin/user/rules',
  'router_path' => 'admin/user/rules',
  'link_title' => 'Access rules',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:80:"List and create rules to disallow usernames, e-mail addresses, and IP addresses.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '175',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '176',
  'plid' => '167',
  'link_path' => 'admin/settings/actions',
  'router_path' => 'admin/settings/actions',
  'link_title' => 'Actions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Manage the actions defined for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '176',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '177',
  'plid' => '167',
  'link_path' => 'admin/settings/admin',
  'router_path' => 'admin/settings/admin',
  'link_title' => 'Administration theme',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:55:"Settings for how your administrative pages should look.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '177',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '178',
  'plid' => '158',
  'link_path' => 'node/add/article',
  'router_path' => 'node/add/article',
  'link_title' => 'Article',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:34:"An <em>article</em>, content type.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '178',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '179',
  'plid' => '166',
  'link_path' => 'admin/build/block',
  'router_path' => 'admin/build/block',
  'link_title' => 'Blocks',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:79:\"Configure what block content appears in your site's sidebars and other regions.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '179',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '180',
  'plid' => '167',
  'link_path' => 'admin/settings/clean-urls',
  'router_path' => 'admin/settings/clean-urls',
  'link_title' => 'Clean URLs',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Enable or disable clean URLs for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '180',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '181',
  'plid' => '157',
  'link_path' => 'admin/content/comment',
  'router_path' => 'admin/content/comment',
  'link_title' => 'Comments',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:61:"List and edit site comments and the comment moderation queue.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '181',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '182',
  'plid' => '158',
  'link_path' => 'node/add/company',
  'router_path' => 'node/add/company',
  'link_title' => 'Company',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Company node type";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '182',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '183',
  'plid' => '166',
  'link_path' => 'admin/build/contact',
  'router_path' => 'admin/build/contact',
  'link_title' => 'Contact form',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:71:"Create a system contact form and set up categories for the form to use.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '183',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '184',
  'plid' => '157',
  'link_path' => 'admin/content/node',
  'router_path' => 'admin/content/node',
  'link_title' => 'Content',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:43:\"View, edit, and delete your site's content.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '184',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '185',
  'plid' => '157',
  'link_path' => 'admin/content/types',
  'router_path' => 'admin/content/types',
  'link_title' => 'Content types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:82:"Manage posts by content type, including default status, front page promotion, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '185',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '186',
  'plid' => '167',
  'link_path' => 'admin/settings/date-time',
  'router_path' => 'admin/settings/date-time',
  'link_title' => 'Date and time',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:89:\"Settings for how Drupal displays date and time, as well as the system's default timezone.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '186',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '187',
  'plid' => '0',
  'link_path' => 'node/%/delete',
  'router_path' => 'node/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '1',
  'customized' => '0',
  'p1' => '187',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '188',
  'plid' => '172',
  'link_path' => 'user/%/delete',
  'router_path' => 'user/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '172',
  'p2' => '188',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '189',
  'plid' => '158',
  'link_path' => 'node/add/employee',
  'router_path' => 'node/add/employee',
  'link_title' => 'Employee',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:18:"Employee node type";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '189',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '190',
  'plid' => '167',
  'link_path' => 'admin/settings/error-reporting',
  'router_path' => 'admin/settings/error-reporting',
  'link_title' => 'Error reporting',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:93:"Control how Drupal deals with errors including 403/404 errors as well as PHP error reporting.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '190',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '192',
  'plid' => '167',
  'link_path' => 'admin/settings/file-system',
  'router_path' => 'admin/settings/file-system',
  'link_title' => 'File system',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:68:"Tell Drupal where to store uploaded files and how they are accessed.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '192',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '193',
  'plid' => '167',
  'link_path' => 'admin/settings/uploads',
  'router_path' => 'admin/settings/uploads',
  'link_title' => 'File uploads',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Control how files may be attached to content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '193',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '194',
  'plid' => '167',
  'link_path' => 'admin/settings/image-toolkit',
  'router_path' => 'admin/settings/image-toolkit',
  'link_title' => 'Image toolkit',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:74:"Choose which image toolkit to use if you have installed optional toolkits.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '194',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '195',
  'plid' => '167',
  'link_path' => 'admin/settings/filters',
  'router_path' => 'admin/settings/filters',
  'link_title' => 'Input formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:127:"Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '195',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '196',
  'plid' => '167',
  'link_path' => 'admin/settings/logging',
  'router_path' => 'admin/settings/logging',
  'link_title' => 'Logging and alerts',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:156:\"Settings for logging and alerts modules. Various modules can route Drupal's system events to different destination, such as syslog, database, email, ...etc.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '196',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '197',
  'plid' => '166',
  'link_path' => 'admin/build/menu',
  'router_path' => 'admin/build/menu',
  'link_title' => 'Menus',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:116:\"Control your site's navigation menu, primary links and secondary links, as well as rename and reorganize menu items.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '197',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '198',
  'plid' => '158',
  'link_path' => 'node/add/test-event',
  'router_path' => 'node/add/test-event',
  'link_title' => 'Migrate test event',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:27:"test event description here";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '198',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '199',
  'plid' => '158',
  'link_path' => 'node/add/test-page',
  'router_path' => 'node/add/test-page',
  'link_title' => 'Migrate test page',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '199',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '200',
  'plid' => '158',
  'link_path' => 'node/add/test-planet',
  'router_path' => 'node/add/test-planet',
  'link_title' => 'Migrate test planet',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '200',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '201',
  'plid' => '158',
  'link_path' => 'node/add/test-story',
  'router_path' => 'node/add/test-story',
  'link_title' => 'Migrate test story',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '201',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '202',
  'plid' => '166',
  'link_path' => 'admin/build/modules',
  'router_path' => 'admin/build/modules',
  'link_title' => 'Modules',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Enable or disable add-on modules for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '202',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '203',
  'plid' => '167',
  'link_path' => 'admin/settings/performance',
  'router_path' => 'admin/settings/performance',
  'link_title' => 'Performance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:101:"Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '203',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '204',
  'plid' => '170',
  'link_path' => 'admin/user/permissions',
  'router_path' => 'admin/user/permissions',
  'link_title' => 'Permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '204',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '205',
  'plid' => '157',
  'link_path' => 'admin/content/node-settings',
  'router_path' => 'admin/content/node-settings',
  'link_title' => 'Post settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:126:"Control posting behavior, such as teaser length, requiring previews before posting, and the number of posts on the front page.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '205',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '206',
  'plid' => '170',
  'link_path' => 'admin/user/profile',
  'router_path' => 'admin/user/profile',
  'link_title' => 'Profiles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:42:"Create customizable fields for your users.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '206',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '207',
  'plid' => '157',
  'link_path' => 'admin/content/rss-publishing',
  'router_path' => 'admin/content/rss-publishing',
  'link_title' => 'RSS publishing',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:92:"Configure the number of items per feed and whether feeds should be titles/teasers/full-text.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '207',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '208',
  'plid' => '0',
  'link_path' => 'comment/reply/%',
  'router_path' => 'comment/reply/%',
  'link_title' => 'Reply to comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '208',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '209',
  'plid' => '170',
  'link_path' => 'admin/user/roles',
  'router_path' => 'admin/user/roles',
  'link_title' => 'Roles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"List, edit, or add user roles.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '209',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '210',
  'plid' => '167',
  'link_path' => 'admin/settings/site-information',
  'router_path' => 'admin/settings/site-information',
  'link_title' => 'Site information',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:107:"Change basic site information, such as the site name, slogan, e-mail address, mission, front page and more.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '210',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '211',
  'plid' => '167',
  'link_path' => 'admin/settings/site-maintenance',
  'router_path' => 'admin/settings/site-maintenance',
  'link_title' => 'Site maintenance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:63:"Take the site off-line for maintenance or bring it back online.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '211',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '212',
  'plid' => '158',
  'link_path' => 'node/add/sponsor',
  'router_path' => 'node/add/sponsor',
  'link_title' => 'Sponsor',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Sponsor node type";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '212',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '213',
  'plid' => '165',
  'link_path' => 'admin/reports/status',
  'router_path' => 'admin/reports/status',
  'link_title' => 'Status report',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:74:\"Get a status report about your site's operation and any detected problems.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '213',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '214',
  'plid' => '157',
  'link_path' => 'admin/content/taxonomy',
  'router_path' => 'admin/content/taxonomy',
  'link_title' => 'Taxonomy',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:67:"Manage tagging, categorization, and classification of your content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '214',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '215',
  'plid' => '0',
  'link_path' => 'taxonomy/term/%',
  'router_path' => 'taxonomy/term/%',
  'link_title' => 'Taxonomy term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '215',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '216',
  'plid' => '166',
  'link_path' => 'admin/build/themes',
  'router_path' => 'admin/build/themes',
  'link_title' => 'Themes',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:57:"Change which theme your site uses or allows users to set.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '216',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '217',
  'plid' => '170',
  'link_path' => 'admin/user/settings',
  'router_path' => 'admin/user/settings',
  'link_title' => 'User settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:101:"Configure default behavior of users, including registration requirements, e-mails, and user pictures.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '217',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '218',
  'plid' => '170',
  'link_path' => 'admin/user/user',
  'router_path' => 'admin/user/user',
  'link_title' => 'Users',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:26:"List, add, and edit users.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '218',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '219',
  'plid' => '195',
  'link_path' => 'admin/settings/filters/%',
  'router_path' => 'admin/settings/filters/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '195',
  'p4' => '219',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '220',
  'plid' => '206',
  'link_path' => 'admin/user/profile/add',
  'router_path' => 'admin/user/profile/add',
  'link_title' => 'Add field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '206',
  'p4' => '220',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '221',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/article',
  'router_path' => 'admin/content/node-type/article',
  'link_title' => 'Article',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '221',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '222',
  'plid' => '180',
  'link_path' => 'admin/settings/clean-urls/check',
  'router_path' => 'admin/settings/clean-urls/check',
  'link_title' => 'Clean URL check',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '180',
  'p4' => '222',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '223',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/company',
  'router_path' => 'admin/content/node-type/company',
  'link_title' => 'Company',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '223',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '224',
  'plid' => '176',
  'link_path' => 'admin/settings/actions/configure',
  'router_path' => 'admin/settings/actions/configure',
  'link_title' => 'Configure an advanced action',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '176',
  'p4' => '224',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '225',
  'plid' => '179',
  'link_path' => 'admin/build/block/configure',
  'router_path' => 'admin/build/block/configure',
  'link_title' => 'Configure block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '179',
  'p4' => '225',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '226',
  'plid' => '166',
  'link_path' => 'admin/build/menu-customize/%',
  'router_path' => 'admin/build/menu-customize/%',
  'link_title' => 'Customize menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '226',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '227',
  'plid' => '186',
  'link_path' => 'admin/settings/date-time/lookup',
  'router_path' => 'admin/settings/date-time/lookup',
  'link_title' => 'Date and time lookup',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '186',
  'p4' => '227',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '228',
  'plid' => '179',
  'link_path' => 'admin/build/block/delete',
  'router_path' => 'admin/build/block/delete',
  'link_title' => 'Delete block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '179',
  'p4' => '228',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '229',
  'plid' => '206',
  'link_path' => 'admin/user/profile/delete',
  'router_path' => 'admin/user/profile/delete',
  'link_title' => 'Delete field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '206',
  'p4' => '229',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '230',
  'plid' => '195',
  'link_path' => 'admin/settings/filters/delete',
  'router_path' => 'admin/settings/filters/delete',
  'link_title' => 'Delete input format',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '195',
  'p4' => '230',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '231',
  'plid' => '175',
  'link_path' => 'admin/user/rules/delete',
  'router_path' => 'admin/user/rules/delete',
  'link_title' => 'Delete rule',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '175',
  'p4' => '231',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '232',
  'plid' => '206',
  'link_path' => 'admin/user/profile/edit',
  'router_path' => 'admin/user/profile/edit',
  'link_title' => 'Edit field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '206',
  'p4' => '232',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '233',
  'plid' => '209',
  'link_path' => 'admin/user/roles/edit',
  'router_path' => 'admin/user/roles/edit',
  'link_title' => 'Edit role',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '209',
  'p4' => '233',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '234',
  'plid' => '175',
  'link_path' => 'admin/user/rules/edit',
  'router_path' => 'admin/user/rules/edit',
  'link_title' => 'Edit rule',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '175',
  'p4' => '234',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '235',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/employee',
  'router_path' => 'admin/content/node-type/employee',
  'link_title' => 'Employee',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '235',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '236',
  'plid' => '214',
  'link_path' => 'admin/content/taxonomy/%',
  'router_path' => 'admin/content/taxonomy/%',
  'link_title' => 'List terms',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '214',
  'p4' => '236',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '237',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/test-event',
  'router_path' => 'admin/content/node-type/test-event',
  'link_title' => 'Migrate test event',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '237',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '238',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/test-page',
  'router_path' => 'admin/content/node-type/test-page',
  'link_title' => 'Migrate test page',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '238',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '239',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/test-planet',
  'router_path' => 'admin/content/node-type/test-planet',
  'link_title' => 'Migrate test planet',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '239',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '240',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/test-story',
  'router_path' => 'admin/content/node-type/test-story',
  'link_title' => 'Migrate test story',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '240',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '241',
  'plid' => '213',
  'link_path' => 'admin/reports/status/php',
  'router_path' => 'admin/reports/status/php',
  'link_title' => 'PHP',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '213',
  'p4' => '241',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '242',
  'plid' => '206',
  'link_path' => 'admin/user/profile/autocomplete',
  'router_path' => 'admin/user/profile/autocomplete',
  'link_title' => 'Profile category autocomplete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '206',
  'p4' => '242',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '243',
  'plid' => '205',
  'link_path' => 'admin/content/node-settings/rebuild',
  'router_path' => 'admin/content/node-settings/rebuild',
  'link_title' => 'Rebuild permissions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '205',
  'p4' => '243',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '244',
  'plid' => '176',
  'link_path' => 'admin/settings/actions/orphan',
  'router_path' => 'admin/settings/actions/orphan',
  'link_title' => 'Remove orphans',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '176',
  'p4' => '244',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '245',
  'plid' => '213',
  'link_path' => 'admin/reports/status/run-cron',
  'router_path' => 'admin/reports/status/run-cron',
  'link_title' => 'Run cron',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '213',
  'p4' => '245',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '246',
  'plid' => '213',
  'link_path' => 'admin/reports/status/sql',
  'router_path' => 'admin/reports/status/sql',
  'link_title' => 'SQL',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '213',
  'p4' => '246',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '247',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/sponsor',
  'router_path' => 'admin/content/node-type/sponsor',
  'link_title' => 'Sponsor',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '247',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '248',
  'plid' => '186',
  'link_path' => 'admin/settings/date-time/formats/lookup',
  'router_path' => 'admin/settings/date-time/formats/lookup',
  'link_title' => 'Date and time lookup',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '186',
  'p4' => '248',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '249',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/article/delete',
  'router_path' => 'admin/content/node-type/article/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '249',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '250',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/company/delete',
  'router_path' => 'admin/content/node-type/company/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '250',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '251',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/employee/delete',
  'router_path' => 'admin/content/node-type/employee/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '251',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '252',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/sponsor/delete',
  'router_path' => 'admin/content/node-type/sponsor/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '252',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '253',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-event/delete',
  'router_path' => 'admin/content/node-type/test-event/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '253',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '254',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-page/delete',
  'router_path' => 'admin/content/node-type/test-page/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '254',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '255',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-planet/delete',
  'router_path' => 'admin/content/node-type/test-planet/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '255',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '256',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-story/delete',
  'router_path' => 'admin/content/node-type/test-story/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '256',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '257',
  'plid' => '176',
  'link_path' => 'admin/settings/actions/delete/%',
  'router_path' => 'admin/settings/actions/delete/%',
  'link_title' => 'Delete action',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Delete an action.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '176',
  'p4' => '257',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '258',
  'plid' => '183',
  'link_path' => 'admin/build/contact/delete/%',
  'router_path' => 'admin/build/contact/delete/%',
  'link_title' => 'Delete contact',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '183',
  'p4' => '258',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '259',
  'plid' => '186',
  'link_path' => 'admin/settings/date-time/delete/%',
  'router_path' => 'admin/settings/date-time/delete/%',
  'link_title' => 'Delete date format type',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:52:"Allow users to delete a configured date format type.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '186',
  'p4' => '259',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '260',
  'plid' => '0',
  'link_path' => 'admin/build/menu-customize/%/delete',
  'router_path' => 'admin/build/menu-customize/%/delete',
  'link_title' => 'Delete menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '260',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '261',
  'plid' => '183',
  'link_path' => 'admin/build/contact/edit/%',
  'router_path' => 'admin/build/contact/edit/%',
  'link_title' => 'Edit contact category',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '183',
  'p4' => '261',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '262',
  'plid' => '214',
  'link_path' => 'admin/content/taxonomy/edit/term',
  'router_path' => 'admin/content/taxonomy/edit/term',
  'link_title' => 'Edit term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '214',
  'p4' => '262',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '263',
  'plid' => '179',
  'link_path' => 'admin/build/block/list/js',
  'router_path' => 'admin/build/block/list/js',
  'link_title' => 'JavaScript List Form',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '179',
  'p4' => '263',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '264',
  'plid' => '202',
  'link_path' => 'admin/build/modules/list/confirm',
  'router_path' => 'admin/build/modules/list/confirm',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '202',
  'p4' => '264',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '266',
  'plid' => '0',
  'link_path' => 'user/reset/%/%/%',
  'router_path' => 'user/reset/%/%/%',
  'link_title' => 'Reset password',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '266',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '267',
  'plid' => '202',
  'link_path' => 'admin/build/modules/uninstall/confirm',
  'router_path' => 'admin/build/modules/uninstall/confirm',
  'link_title' => 'Uninstall',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '202',
  'p4' => '267',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '269',
  'plid' => '0',
  'link_path' => 'node/%/revisions/%/delete',
  'router_path' => 'node/%/revisions/%/delete',
  'link_title' => 'Delete earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '269',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '270',
  'plid' => '0',
  'link_path' => 'node/%/revisions/%/revert',
  'router_path' => 'node/%/revisions/%/revert',
  'link_title' => 'Revert to earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '270',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '271',
  'plid' => '0',
  'link_path' => 'node/%/revisions/%/view',
  'router_path' => 'node/%/revisions/%/view',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '271',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '272',
  'plid' => '186',
  'link_path' => 'admin/settings/date-time/formats/delete/%',
  'router_path' => 'admin/settings/date-time/formats/delete/%',
  'link_title' => 'Delete date format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Allow users to delete a configured date format.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '186',
  'p4' => '272',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '273',
  'plid' => '197',
  'link_path' => 'admin/build/menu/item/%/delete',
  'router_path' => 'admin/build/menu/item/%/delete',
  'link_title' => 'Delete menu item',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '197',
  'p4' => '273',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '276',
  'plid' => '197',
  'link_path' => 'admin/build/menu/item/%/edit',
  'router_path' => 'admin/build/menu/item/%/edit',
  'link_title' => 'Edit menu item',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '197',
  'p4' => '276',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '277',
  'plid' => '214',
  'link_path' => 'admin/content/taxonomy/edit/vocabulary/%',
  'router_path' => 'admin/content/taxonomy/edit/vocabulary/%',
  'link_title' => 'Edit vocabulary',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '214',
  'p4' => '277',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '278',
  'plid' => '197',
  'link_path' => 'admin/build/menu/item/%/reset',
  'router_path' => 'admin/build/menu/item/%/reset',
  'link_title' => 'Reset menu item',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '197',
  'p4' => '278',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '299',
  'plid' => '0',
  'link_path' => 'event',
  'router_path' => 'event',
  'link_title' => 'Events',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '299',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '300',
  'plid' => '299',
  'link_path' => 'event/dst',
  'router_path' => 'event/dst',
  'link_title' => 'Event dst view',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '299',
  'p2' => '300',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '301',
  'plid' => '299',
  'link_path' => 'event/ical',
  'router_path' => 'event/ical',
  'link_title' => 'Event ical feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '299',
  'p2' => '301',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '302',
  'plid' => '299',
  'link_path' => 'event/feed',
  'router_path' => 'event/feed',
  'link_title' => 'Event rss feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '299',
  'p2' => '302',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '303',
  'plid' => '299',
  'link_path' => 'event/type',
  'router_path' => 'event/type',
  'link_title' => 'Filter by content type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '299',
  'p2' => '303',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '304',
  'plid' => '299',
  'link_path' => 'event/term',
  'router_path' => 'event/term',
  'link_title' => 'Filter by taxonomy',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '299',
  'p2' => '304',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '305',
  'plid' => '0',
  'link_path' => 'node/%/ical',
  'router_path' => 'node/%/ical',
  'link_title' => 'Event ical',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '305',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '306',
  'plid' => '167',
  'link_path' => 'admin/settings/event',
  'router_path' => 'admin/settings/event',
  'link_title' => 'Events',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:36:"Set up how your site handles events.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '306',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '307',
  'plid' => '306',
  'link_path' => 'admin/settings/event/overview',
  'router_path' => 'admin/settings/event/overview',
  'link_title' => 'Event overview',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:50:"Change how event summary information is displayed.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '306',
  'p4' => '307',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '308',
  'plid' => '306',
  'link_path' => 'admin/settings/event/timezone',
  'router_path' => 'admin/settings/event/timezone',
  'link_title' => 'Timezone handling',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:55:"Change how timezone information is saved and displayed.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '306',
  'p4' => '308',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '309',
  'plid' => '158',
  'link_path' => 'node/add/story',
  'router_path' => 'node/add/story',
  'link_title' => 'Story',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '309',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '310',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/story',
  'router_path' => 'admin/content/node-type/story',
  'link_title' => 'Story',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '310',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '311',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/delete',
  'router_path' => 'admin/content/node-type/story/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '311',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '328',
  'plid' => '0',
  'link_path' => 'filefield/progress',
  'router_path' => 'filefield/progress',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '328',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '329',
  'plid' => '0',
  'link_path' => 'filefield/ahah/%/%/%',
  'router_path' => 'filefield/ahah/%/%/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '329',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '333',
  'plid' => '167',
  'link_path' => 'admin/settings/email',
  'router_path' => 'admin/settings/email',
  'link_title' => 'CCK Email Contact Form Settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:57:"Administer flood control settings for email contact forms";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '333',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '334',
  'plid' => '0',
  'link_path' => 'email/%/%',
  'router_path' => 'email/%/%',
  'link_title' => 'Email Contact Form',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '334',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '350',
  'plid' => '0',
  'link_path' => 'aggregator',
  'router_path' => 'aggregator',
  'link_title' => 'Feed aggregator',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '1',
  'customized' => '0',
  'p1' => '350',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '351',
  'plid' => '350',
  'link_path' => 'aggregator/categories',
  'router_path' => 'aggregator/categories',
  'link_title' => 'Categories',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '350',
  'p2' => '351',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '352',
  'plid' => '350',
  'link_path' => 'aggregator/opml',
  'router_path' => 'aggregator/opml',
  'link_title' => 'OPML feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '350',
  'p2' => '352',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '353',
  'plid' => '350',
  'link_path' => 'aggregator/rss',
  'router_path' => 'aggregator/rss',
  'link_title' => 'RSS feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '350',
  'p2' => '353',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '354',
  'plid' => '350',
  'link_path' => 'aggregator/sources',
  'router_path' => 'aggregator/sources',
  'link_title' => 'Sources',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '350',
  'p2' => '354',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '355',
  'plid' => '351',
  'link_path' => 'aggregator/categories/%',
  'router_path' => 'aggregator/categories/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '350',
  'p2' => '351',
  'p3' => '355',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '356',
  'plid' => '354',
  'link_path' => 'aggregator/sources/%',
  'router_path' => 'aggregator/sources/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '350',
  'p2' => '354',
  'p3' => '356',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '357',
  'plid' => '157',
  'link_path' => 'admin/content/aggregator',
  'router_path' => 'admin/content/aggregator',
  'link_title' => 'Feed aggregator',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:116:\"Configure which content your site aggregates from other sites, how often it polls them, and how they're categorized.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '357',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '358',
  'plid' => '357',
  'link_path' => 'admin/content/aggregator/remove/%',
  'router_path' => 'admin/content/aggregator/remove/%',
  'link_title' => 'Remove items',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '357',
  'p4' => '358',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '359',
  'plid' => '357',
  'link_path' => 'admin/content/aggregator/update/%',
  'router_path' => 'admin/content/aggregator/update/%',
  'link_title' => 'Update items',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '357',
  'p4' => '359',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '360',
  'plid' => '357',
  'link_path' => 'admin/content/aggregator/edit/category/%',
  'router_path' => 'admin/content/aggregator/edit/category/%',
  'link_title' => 'Edit category',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '357',
  'p4' => '360',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '361',
  'plid' => '357',
  'link_path' => 'admin/content/aggregator/edit/feed/%',
  'router_path' => 'admin/content/aggregator/edit/feed/%',
  'link_title' => 'Edit feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '357',
  'p4' => '361',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '363',
  'plid' => '0',
  'link_path' => 'book',
  'router_path' => 'book',
  'link_title' => 'Books',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '363',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '364',
  'plid' => '363',
  'link_path' => 'book/js/form',
  'router_path' => 'book/js/form',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '363',
  'p2' => '364',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '366',
  'plid' => '157',
  'link_path' => 'admin/content/book',
  'router_path' => 'admin/content/book',
  'link_title' => 'Books',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:33:\"Manage your site's book outlines.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '366',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '367',
  'plid' => '363',
  'link_path' => 'book/export/%/%',
  'router_path' => 'book/export/%/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '363',
  'p2' => '367',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '369',
  'plid' => '366',
  'link_path' => 'admin/content/book/%',
  'router_path' => 'admin/content/book/%',
  'link_title' => 'Re-order book pages and change titles',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '366',
  'p4' => '369',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '370',
  'plid' => '0',
  'link_path' => 'node/%/outline/remove',
  'router_path' => 'node/%/outline/remove',
  'link_title' => 'Remove from outline',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '370',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'secondary-links',
  'mlid' => '393',
  'plid' => '0',
  'link_path' => 'user/login',
  'router_path' => 'user/login',
  'link_title' => 'Test 3',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-47',
  'depth' => '1',
  'customized' => '1',
  'p1' => '393',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '394',
  'plid' => '166',
  'link_path' => 'admin/build/path',
  'router_path' => 'admin/build/path',
  'link_title' => 'URL aliases',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:46:\"Change your site's URL paths by aliasing them.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '394',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '395',
  'plid' => '394',
  'link_path' => 'admin/build/path/delete',
  'router_path' => 'admin/build/path/delete',
  'link_title' => 'Delete alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '394',
  'p4' => '395',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '396',
  'plid' => '394',
  'link_path' => 'admin/build/path/edit',
  'router_path' => 'admin/build/path/edit',
  'link_title' => 'Edit alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '394',
  'p4' => '396',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '397',
  'plid' => '0',
  'link_path' => 'system/files/imagecache',
  'router_path' => 'system/files/imagecache',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '397',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '398',
  'plid' => '167',
  'link_path' => 'admin/settings/imageapi',
  'router_path' => 'admin/settings/imageapi',
  'link_title' => 'ImageAPI',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:19:"Configure ImageAPI.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '398',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '399',
  'plid' => '167',
  'link_path' => 'admin/settings/language',
  'router_path' => 'admin/settings/language',
  'link_title' => 'Languages',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:55:"Configure languages for content and the user interface.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '399',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '400',
  'plid' => '166',
  'link_path' => 'admin/build/translate',
  'router_path' => 'admin/build/translate',
  'link_title' => 'Translate interface',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:59:"Translate the built in interface and optionally other text.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '400',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '401',
  'plid' => '399',
  'link_path' => 'admin/settings/language/delete/%',
  'router_path' => 'admin/settings/language/delete/%',
  'link_title' => 'Confirm',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '399',
  'p4' => '401',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '403',
  'plid' => '400',
  'link_path' => 'admin/build/translate/delete/%',
  'router_path' => 'admin/build/translate/delete/%',
  'link_title' => 'Delete string',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '400',
  'p4' => '403',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '404',
  'plid' => '399',
  'link_path' => 'admin/settings/language/edit/%',
  'router_path' => 'admin/settings/language/edit/%',
  'link_title' => 'Edit language',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '399',
  'p4' => '404',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '405',
  'plid' => '400',
  'link_path' => 'admin/build/translate/edit/%',
  'router_path' => 'admin/build/translate/edit/%',
  'link_title' => 'Edit string',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '400',
  'p4' => '405',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '407',
  'plid' => '0',
  'link_path' => 'i18nstrings/save',
  'router_path' => 'i18nstrings/save',
  'link_title' => 'Save string',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '407',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '408',
  'plid' => '0',
  'link_path' => 'i18n/node/autocomplete',
  'router_path' => 'i18n/node/autocomplete',
  'link_title' => 'Node title autocomplete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '408',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '411',
  'plid' => '0',
  'link_path' => 'core/tests/fixtures/files/imagecache',
  'router_path' => 'core/tests/fixtures/files/imagecache',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '411',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '412',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '412',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '413',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_date/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_date/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '413',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '414',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_datestamp/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_datestamp/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '414',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '415',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_datetime/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_datetime/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '415',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '416',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_decimal_radio_buttons/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_decimal_radio_buttons/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '416',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '417',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_email/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_email/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '417',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '418',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_exclude_unset/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_exclude_unset/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '418',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '419',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_filefield/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_filefield/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '419',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '420',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_float_single_checkbox/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_float_single_checkbox/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '420',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '421',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_four/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_four/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '421',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '422',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_identical1/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_identical1/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '422',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '423',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_identical2/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_identical2/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '423',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '424',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_imagefield/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_imagefield/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '424',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '425',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_integer_selectlist/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_integer_selectlist/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '425',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '426',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_link/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_link/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '426',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '427',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_phone/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_phone/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '427',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '428',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '428',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '429',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox2/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox2/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '429',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '430',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_three/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_three/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '430',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '431',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_two/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_two/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '431',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '432',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-page/fields/field_test/remove',
  'router_path' => 'admin/content/node-type/test-page/fields/field_test/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '432',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '433',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-planet/fields/field_multivalue/remove',
  'router_path' => 'admin/content/node-type/test-planet/fields/field_multivalue/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '433',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '434',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-planet/fields/field_test_text_single_checkbox/remove',
  'router_path' => 'admin/content/node-type/test-planet/fields/field_test_text_single_checkbox/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '434',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '438',
  'plid' => '167',
  'link_path' => 'admin/settings/variable',
  'router_path' => 'admin/settings/variable',
  'link_title' => 'Variables',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:31:"Edit and delete site variables.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '438',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '439',
  'plid' => '438',
  'link_path' => 'admin/settings/variable/edit/%',
  'router_path' => 'admin/settings/variable/edit/%',
  'link_title' => 'Edit variable',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '438',
  'p4' => '439',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '440',
  'plid' => '438',
  'link_path' => 'admin/settings/variable/group/%',
  'router_path' => 'admin/settings/variable/group/%',
  'link_title' => 'Variables group',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:32:"Edit and delete group variables.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '438',
  'p4' => '440',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '441',
  'plid' => '0',
  'link_path' => 'forum',
  'router_path' => 'forum',
  'link_title' => 'Forums',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '441',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '442',
  'plid' => '165',
  'link_path' => 'admin/reports/settings',
  'router_path' => 'admin/reports/settings',
  'link_title' => 'Access log settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:50:"Control details about what and how your site logs.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '3',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '442',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '443',
  'plid' => '158',
  'link_path' => 'node/add/forum',
  'router_path' => 'node/add/forum',
  'link_title' => 'Forum topic',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:85:"A <em>forum topic</em> is the initial post to a new discussion thread within a forum.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '443',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '444',
  'plid' => '157',
  'link_path' => 'admin/content/forum',
  'router_path' => 'admin/content/forum',
  'link_title' => 'Forums',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:61:"Control forums and their hierarchy and change forum settings.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '444',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '445',
  'plid' => '165',
  'link_path' => 'admin/reports/hits',
  'router_path' => 'admin/reports/hits',
  'link_title' => 'Recent hits',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"View pages that have recently been visited.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '445',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '446',
  'plid' => '165',
  'link_path' => 'admin/reports/pages',
  'router_path' => 'admin/reports/pages',
  'link_title' => 'Top pages',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"View pages that have been hit frequently.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '446',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '447',
  'plid' => '165',
  'link_path' => 'admin/reports/referrers',
  'router_path' => 'admin/reports/referrers',
  'link_title' => 'Top referrers',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:19:"View top referrers.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '447',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '448',
  'plid' => '165',
  'link_path' => 'admin/reports/visitors',
  'router_path' => 'admin/reports/visitors',
  'link_title' => 'Top visitors',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:34:"View visitors that hit many pages.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '448',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '449',
  'plid' => '165',
  'link_path' => 'admin/reports/access/%',
  'router_path' => 'admin/reports/access/%',
  'link_title' => 'Details',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:16:"View access log.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '449',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '450',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/forum',
  'router_path' => 'admin/content/node-type/forum',
  'link_title' => 'Forum topic',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '450',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '451',
  'plid' => '444',
  'link_path' => 'admin/content/forum/edit/%',
  'router_path' => 'admin/content/forum/edit/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '444',
  'p4' => '451',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '452',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/forum/delete',
  'router_path' => 'admin/content/node-type/forum/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '452',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '453',
  'plid' => '444',
  'link_path' => 'admin/content/forum/edit/container/%',
  'router_path' => 'admin/content/forum/edit/container/%',
  'link_title' => 'Edit container',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '444',
  'p4' => '453',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '454',
  'plid' => '444',
  'link_path' => 'admin/content/forum/edit/forum/%',
  'router_path' => 'admin/content/forum/edit/forum/%',
  'link_title' => 'Edit forum',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '444',
  'p4' => '454',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '455',
  'plid' => '0',
  'link_path' => 'nodereference/autocomplete',
  'router_path' => 'nodereference/autocomplete',
  'link_title' => 'Nodereference autocomplete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '455',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '456',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/employee/fields/field_company/remove',
  'router_path' => 'admin/content/node-type/employee/fields/field_company/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '456',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '457',
  'plid' => '0',
  'link_path' => 'userreference/autocomplete',
  'router_path' => 'userreference/autocomplete',
  'link_title' => 'Userreference autocomplete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '457',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '458',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/employee/fields/field_commander/remove',
  'router_path' => 'admin/content/node-type/employee/fields/field_commander/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '458',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'secondary-links',
  'mlid' => '463',
  'plid' => '139',
  'link_path' => 'user/login',
  'router_path' => 'user/login',
  'link_title' => 'fr - Test 1',
  'options' => 'a:3:{s:10:"attributes";a:1:{s:5:"title";s:21:"fr - Test menu link 1";}s:8:"langcode";s:2:"fr";s:5:"alter";b:1;}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-49',
  'depth' => '2',
  'customized' => '1',
  'p1' => '139',
  'p2' => '459',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '464',
  'plid' => '158',
  'link_path' => 'node/add/page',
  'router_path' => 'node/add/page',
  'link_title' => 'Page',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '464',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '465',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/page',
  'router_path' => 'admin/content/node-type/page',
  'link_title' => 'Page',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '465',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '466',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/page/delete',
  'router_path' => 'admin/content/node-type/page/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '466',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '467',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/employee/fields/field_company_2/remove',
  'router_path' => 'admin/content/node-type/employee/fields/field_company_2/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '467',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '468',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/employee/fields/field_company_3/remove',
  'router_path' => 'admin/content/node-type/employee/fields/field_company_3/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '468',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '469',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/page/fields/field_reference/remove',
  'router_path' => 'admin/content/node-type/page/fields/field_reference/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '469',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '470',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/page/fields/field_reference_2/remove',
  'router_path' => 'admin/content/node-type/page/fields/field_reference_2/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '470',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->values([
  'menu_name' => 'navigation',
  'mlid' => '471',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_string_selectlist/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_string_selectlist/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '471',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
])
->execute();
$connection->schema()->createTable('menu_router', [
  'fields' => [
    'path' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'load_functions' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'to_arg_functions' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'access_callback' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'access_arguments' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'page_callback' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'page_arguments' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'fit' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'number_parts' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'tab_parent' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'tab_root' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'title_callback' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'title_arguments' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'type' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'block_callback' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'description' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'position' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'file' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'path',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('menu_router')
->fields([
  'path',
  'load_functions',
  'to_arg_functions',
  'access_callback',
  'access_arguments',
  'page_callback',
  'page_arguments',
  'fit',
  'number_parts',
  'tab_parent',
  'tab_root',
  'title',
  'title_callback',
  'title_arguments',
  'type',
  'block_callback',
  'description',
  'position',
  'weight',
  'file',
])
->values([
  'path' => 'admin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_main_admin_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'admin',
  'title' => 'Administer',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '9',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/build',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/build',
  'title' => 'Site building',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control how your site looks and feels.',
  'position' => 'right',
  'weight' => '-10',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/build/block',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block',
  'title' => 'Blocks',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Configure what block content appears in your site's sidebars and other regions.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/build/block/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/block',
  'tab_root' => 'admin/build/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/build/block/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"block_admin_configure";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block/configure',
  'title' => 'Configure block',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/build/block/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:16:"block_box_delete";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block/delete',
  'title' => 'Delete block',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/build/block/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/block',
  'tab_root' => 'admin/build/block',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/build/block/list/bluemarine',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/bluemarine/bluemarine.info";s:4:"name";s:10:"bluemarine";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:10:"Bluemarine";s:11:"description";s:66:"Table-based multi-column theme with a marine and ash color scheme.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/bluemarine/script.js";}s:10:"screenshot";s:32:"themes/bluemarine/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:10:"bluemarine";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Bluemarine',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/build/block/list/chameleon',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:31:"themes/chameleon/chameleon.info";s:4:"name";s:9:"chameleon";s:4:"type";s:5:"theme";s:5:"owner";s:32:"themes/chameleon/chameleon.theme";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:12:{s:4:"name";s:9:"Chameleon";s:11:"description";s:42:"Minimalist tabled theme with light colors.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:8:"features";a:4:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"scripts";a:1:{s:9:"script.js";s:26:"themes/chameleon/script.js";}s:10:"screenshot";s:31:"themes/chameleon/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:9:"chameleon";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Chameleon',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/build/block/list/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:7:"Garland";s:11:"description";s:66:"Tableless, recolorable, multi-column, fluid width theme (default).";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:24:"themes/garland/script.js";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/build/block/list/js',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display_js',
  'page_arguments' => 'a:0:{}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block/list/js',
  'title' => 'JavaScript List Form',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/build/block/list/marvin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:35:"themes/chameleon/marvin/marvin.info";s:4:"name";s:6:"marvin";s:4:"type";s:5:"theme";s:5:"owner";s:0:"";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:6:"Marvin";s:11:"description";s:31:"Boxy tabled theme in all grays.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"base theme";s:9:"chameleon";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/chameleon/marvin/script.js";}s:10:"screenshot";s:38:"themes/chameleon/marvin/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:10:"base_theme";s:9:"chameleon";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:6:"marvin";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Marvin',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/build/block/list/minnelli',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":13:{s:8:"filename";s:37:"themes/garland/minnelli/minnelli.info";s:4:"name";s:8:"minnelli";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:14:{s:4:"name";s:8:"Minnelli";s:11:"description";s:56:"Tableless, recolorable, multi-column, fixed width theme.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"base theme";s:7:"garland";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/garland/minnelli/script.js";}s:10:"screenshot";s:38:"themes/garland/minnelli/screenshot.png";s:3:"php";s:5:"4.3.5";s:6:"engine";s:11:"phptemplate";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:6:"engine";s:11:"phptemplate";s:10:"base_theme";s:7:"garland";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:8:"minnelli";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Minnelli',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/build/block/list/pushbutton',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/pushbutton/pushbutton.info";s:4:"name";s:10:"pushbutton";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:10:"Pushbutton";s:11:"description";s:52:"Tabled, multi-column theme in blue and orange tones.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/pushbutton/script.js";}s:10:"screenshot";s:32:"themes/pushbutton/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:10:"pushbutton";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Pushbutton',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
])
->values([
  'path' => 'admin/build/contact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'contact_admin_categories',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/contact',
  'title' => 'Contact form',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Create a system contact form and set up categories for the form to use.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/contact/contact.admin.inc',
])
->values([
  'path' => 'admin/build/contact/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"contact_admin_edit";i:1;i:3;}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/contact',
  'tab_root' => 'admin/build/contact',
  'title' => 'Add category',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/contact/contact.admin.inc',
])
->values([
  'path' => 'admin/build/contact/delete/%',
  'load_functions' => 'a:1:{i:4;s:12:"contact_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"contact_admin_delete";i:1;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/contact/delete/%',
  'title' => 'Delete contact',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/contact/contact.admin.inc',
])
->values([
  'path' => 'admin/build/contact/edit/%',
  'load_functions' => 'a:1:{i:4;s:12:"contact_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:18:"contact_admin_edit";i:1;i:3;i:2;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/contact/edit/%',
  'title' => 'Edit contact category',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/contact/contact.admin.inc',
])
->values([
  'path' => 'admin/build/contact/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'contact_admin_categories',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/contact',
  'tab_root' => 'admin/build/contact',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/contact/contact.admin.inc',
])
->values([
  'path' => 'admin/build/contact/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"contact_admin_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/contact',
  'tab_root' => 'admin/build/contact',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/contact/contact.admin.inc',
])
->values([
  'path' => 'admin/build/menu',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu',
  'title' => 'Menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Control your site's navigation menu, primary links and secondary links, as well as rename and reorganize menu items.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/build/menu-customize/%',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'Customize menu',
  'title_callback' => 'menu_overview_title',
  'title_arguments' => 'a:1:{i:0;i:3;}',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/build/menu-customize/%/add',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:3:"add";i:2;N;i:3;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/menu-customize/%',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'Add item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/build/menu-customize/%/delete',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_delete_menu_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu-customize/%/delete',
  'title' => 'Delete menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/build/menu-customize/%/edit',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:14:"menu_edit_menu";i:1;s:4:"edit";i:2;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/menu-customize/%',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'Edit menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/build/menu-customize/%/list',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/menu-customize/%',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'List items',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/build/menu/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"menu_edit_menu";i:1;s:3:"add";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/menu',
  'tab_root' => 'admin/build/menu',
  'title' => 'Add menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/build/menu/item/%/delete',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_item_delete_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'fit' => '61',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu/item/%/delete',
  'title' => 'Delete menu item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/build/menu/item/%/edit',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:4:"edit";i:2;i:4;i:3;N;}',
  'fit' => '61',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu/item/%/edit',
  'title' => 'Edit menu item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/build/menu/item/%/reset',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"menu_reset_item_confirm";i:1;i:4;}',
  'fit' => '61',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu/item/%/reset',
  'title' => 'Reset menu item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/build/menu/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/menu',
  'tab_root' => 'admin/build/menu',
  'title' => 'List menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/build/menu/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"menu_configure";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/menu',
  'tab_root' => 'admin/build/menu',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'file' => 'modules/menu/menu.admin.inc',
])
->values([
  'path' => 'admin/build/modules',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/modules',
  'title' => 'Modules',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Enable or disable add-on modules for your site.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/build/modules/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/modules',
  'tab_root' => 'admin/build/modules',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/build/modules/list/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/modules/list/confirm',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/build/modules/uninstall',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/modules',
  'tab_root' => 'admin/build/modules',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/build/modules/uninstall/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/modules/uninstall/confirm',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/build/path',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/path',
  'title' => 'URL aliases',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Change your site's URL paths by aliasing them.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
])
->values([
  'path' => 'admin/build/path/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/path',
  'tab_root' => 'admin/build/path',
  'title' => 'Add alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
])
->values([
  'path' => 'admin/build/path/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"path_admin_delete_confirm";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/path/delete',
  'title' => 'Delete alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
])
->values([
  'path' => 'admin/build/path/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/path/edit',
  'title' => 'Edit alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
])
->values([
  'path' => 'admin/build/path/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/path',
  'tab_root' => 'admin/build/path',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/path/path.admin.inc',
])
->values([
  'path' => 'admin/build/themes',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"system_themes_form";i:1;N;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/themes',
  'title' => 'Themes',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Change which theme your site uses or allows users to set.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/build/themes/select',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"system_themes_form";i:1;N;}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/themes',
  'tab_root' => 'admin/build/themes',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => 'Select the default theme.',
  'position' => '',
  'weight' => '-1',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/build/themes/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/themes',
  'tab_root' => 'admin/build/themes',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/build/themes/settings/bluemarine',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/bluemarine/bluemarine.info";s:4:"name";s:10:"bluemarine";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:10:"Bluemarine";s:11:"description";s:66:"Table-based multi-column theme with a marine and ash color scheme.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/bluemarine/script.js";}s:10:"screenshot";s:32:"themes/bluemarine/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:10:"bluemarine";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Bluemarine',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/build/themes/settings/chameleon',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:31:"themes/chameleon/chameleon.info";s:4:"name";s:9:"chameleon";s:4:"type";s:5:"theme";s:5:"owner";s:32:"themes/chameleon/chameleon.theme";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:12:{s:4:"name";s:9:"Chameleon";s:11:"description";s:42:"Minimalist tabled theme with light colors.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:8:"features";a:4:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"scripts";a:1:{s:9:"script.js";s:26:"themes/chameleon/script.js";}s:10:"screenshot";s:31:"themes/chameleon/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:9:"chameleon";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Chameleon',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/build/themes/settings/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:7:"Garland";s:11:"description";s:66:"Tableless, recolorable, multi-column, fluid width theme (default).";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:24:"themes/garland/script.js";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:7:"garland";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/build/themes/settings/global',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Global settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-1',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/build/themes/settings/marvin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:35:"themes/chameleon/marvin/marvin.info";s:4:"name";s:6:"marvin";s:4:"type";s:5:"theme";s:5:"owner";s:0:"";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:6:"Marvin";s:11:"description";s:31:"Boxy tabled theme in all grays.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"base theme";s:9:"chameleon";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/chameleon/marvin/script.js";}s:10:"screenshot";s:38:"themes/chameleon/marvin/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:10:"base_theme";s:9:"chameleon";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:6:"marvin";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Marvin',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/build/themes/settings/minnelli',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":13:{s:8:"filename";s:37:"themes/garland/minnelli/minnelli.info";s:4:"name";s:8:"minnelli";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:14:{s:4:"name";s:8:"Minnelli";s:11:"description";s:56:"Tableless, recolorable, multi-column, fixed width theme.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"base theme";s:7:"garland";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/garland/minnelli/script.js";}s:10:"screenshot";s:38:"themes/garland/minnelli/screenshot.png";s:3:"php";s:5:"4.3.5";s:6:"engine";s:11:"phptemplate";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:6:"engine";s:11:"phptemplate";s:10:"base_theme";s:7:"garland";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:8:"minnelli";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Minnelli',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/build/themes/settings/pushbutton',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/pushbutton/pushbutton.info";s:4:"name";s:10:"pushbutton";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:10:"Pushbutton";s:11:"description";s:52:"Tabled, multi-column theme in blue and orange tones.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/pushbutton/script.js";}s:10:"screenshot";s:32:"themes/pushbutton/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:10:"pushbutton";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Pushbutton',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/build/translate',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:1:{i:0;s:32:"locale_translate_overview_screen";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/translate',
  'title' => 'Translate interface',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Translate the built in interface and optionally other text.',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/build/translate/delete/%',
  'load_functions' => 'a:1:{i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:2:{i:0;s:28:"locale_translate_delete_page";i:1;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/translate/delete/%',
  'title' => 'Delete string',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/build/translate/edit/%',
  'load_functions' => 'a:1:{i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:3:{i:0;s:15:"drupal_get_form";i:1;s:26:"locale_translate_edit_form";i:2;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/translate/edit/%',
  'title' => 'Edit string',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/build/translate/export',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:1:{i:0;s:30:"locale_translate_export_screen";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/translate',
  'tab_root' => 'admin/build/translate',
  'title' => 'Export',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '30',
  'file' => '',
])
->values([
  'path' => 'admin/build/translate/import',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:2:{i:0;s:15:"drupal_get_form";i:1;s:28:"locale_translate_import_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/translate',
  'tab_root' => 'admin/build/translate',
  'title' => 'Import',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '20',
  'file' => '',
])
->values([
  'path' => 'admin/build/translate/overview',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:1:{i:0;s:32:"locale_translate_overview_screen";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/translate',
  'tab_root' => 'admin/build/translate',
  'title' => 'Overview',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/build/translate/refresh',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'i18nstrings_admin_refresh_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/translate',
  'tab_root' => 'admin/build/translate',
  'title' => 'Refresh',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '20',
  'file' => 'sites/all/modules/i18n/i18nstrings/i18nstrings.admin.inc',
])
->values([
  'path' => 'admin/build/translate/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:1:{i:0;s:28:"locale_translate_seek_screen";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/translate',
  'tab_root' => 'admin/build/translate',
  'title' => 'Search',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'file' => '',
])
->values([
  'path' => 'admin/by-module',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_by_module',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'By module',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/by-task',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_main_admin_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'By task',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/compact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_compact_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/compact',
  'title' => 'Compact mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/content',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/content',
  'title' => 'Content management',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Manage your site's content.",
  'position' => 'left',
  'weight' => '-10',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/content/aggregator',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'aggregator_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/aggregator',
  'title' => 'Feed aggregator',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Configure which content your site aggregates from other sites, how often it polls them, and how they're categorized.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
])
->values([
  'path' => 'admin/content/aggregator/add/category',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"aggregator_form_category";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/aggregator',
  'tab_root' => 'admin/content/aggregator',
  'title' => 'Add category',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
])
->values([
  'path' => 'admin/content/aggregator/add/feed',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"aggregator_form_feed";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/aggregator',
  'tab_root' => 'admin/content/aggregator',
  'title' => 'Add feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
])
->values([
  'path' => 'admin/content/aggregator/edit/category/%',
  'load_functions' => 'a:1:{i:5;s:24:"aggregator_category_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"aggregator_form_category";i:1;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/content/aggregator/edit/category/%',
  'title' => 'Edit category',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
])
->values([
  'path' => 'admin/content/aggregator/edit/feed/%',
  'load_functions' => 'a:1:{i:5;s:20:"aggregator_feed_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"aggregator_form_feed";i:1;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/content/aggregator/edit/feed/%',
  'title' => 'Edit feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
])
->values([
  'path' => 'admin/content/aggregator/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'aggregator_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/aggregator',
  'tab_root' => 'admin/content/aggregator',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/aggregator/aggregator.admin.inc',
])
->values([
  'path' => 'admin/content/aggregator/remove/%',
  'load_functions' => 'a:1:{i:4;s:20:"aggregator_feed_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"aggregator_admin_remove_feed";i:1;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/aggregator/remove/%',
  'title' => 'Remove items',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
])
->values([
  'path' => 'admin/content/aggregator/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"aggregator_admin_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/aggregator',
  'tab_root' => 'admin/content/aggregator',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'file' => 'modules/aggregator/aggregator.admin.inc',
])
->values([
  'path' => 'admin/content/aggregator/update/%',
  'load_functions' => 'a:1:{i:4;s:20:"aggregator_feed_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'aggregator_admin_refresh_feed',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/aggregator/update/%',
  'title' => 'Update items',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
])
->values([
  'path' => 'admin/content/book',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer book outlines";}',
  'page_callback' => 'book_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/book',
  'title' => 'Books',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Manage your site's book outlines.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/book/book.admin.inc',
])
->values([
  'path' => 'admin/content/book/%',
  'load_functions' => 'a:1:{i:3;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_book_outline_access',
  'access_arguments' => 'a:1:{i:0;i:3;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:15:"book_admin_edit";i:1;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/book/%',
  'title' => 'Re-order book pages and change titles',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/book/book.admin.inc',
])
->values([
  'path' => 'admin/content/book/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer book outlines";}',
  'page_callback' => 'book_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/book',
  'tab_root' => 'admin/content/book',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/book/book.admin.inc',
])
->values([
  'path' => 'admin/content/book/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"book_admin_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/book',
  'tab_root' => 'admin/content/book',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '8',
  'file' => 'modules/book/book.admin.inc',
])
->values([
  'path' => 'admin/content/comment',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/comment',
  'title' => 'Comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'List and edit site comments and the comment moderation queue.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.admin.inc',
])
->values([
  'path' => 'admin/content/comment/approval',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:1:{i:0;s:8:"approval";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content/comment',
  'title' => 'Approval queue',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.admin.inc',
])
->values([
  'path' => 'admin/content/comment/new',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content/comment',
  'title' => 'Published comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/comment/comment.admin.inc',
])
->values([
  'path' => 'admin/content/forum',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"forum_overview";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/forum',
  'title' => 'Forums',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control forums and their hierarchy and change forum settings.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
])
->values([
  'path' => 'admin/content/forum/add/container',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:1:{i:0;s:9:"container";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/forum',
  'tab_root' => 'admin/content/forum',
  'title' => 'Add container',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
])
->values([
  'path' => 'admin/content/forum/add/forum',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:1:{i:0;s:5:"forum";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/forum',
  'tab_root' => 'admin/content/forum',
  'title' => 'Add forum',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
])
->values([
  'path' => 'admin/content/forum/edit/%',
  'load_functions' => 'a:1:{i:4;s:15:"forum_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:0:{}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/forum/edit/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
])
->values([
  'path' => 'admin/content/forum/edit/container/%',
  'load_functions' => 'a:1:{i:5;s:15:"forum_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:2:{i:0;s:9:"container";i:1;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/content/forum/edit/container/%',
  'title' => 'Edit container',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
])
->values([
  'path' => 'admin/content/forum/edit/forum/%',
  'load_functions' => 'a:1:{i:5;s:15:"forum_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:2:{i:0;s:5:"forum";i:1;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/content/forum/edit/forum/%',
  'title' => 'Edit forum',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
])
->values([
  'path' => 'admin/content/forum/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"forum_overview";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/forum',
  'tab_root' => 'admin/content/forum',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/forum/forum.admin.inc',
])
->values([
  'path' => 'admin/content/forum/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"forum_admin_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/forum',
  'tab_root' => 'admin/content/forum',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'file' => 'modules/forum/forum.admin.inc',
])
->values([
  'path' => 'admin/content/node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer nodes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "View, edit, and delete your site's content.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.admin.inc',
])
->values([
  'path' => 'admin/content/node-settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer nodes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"node_configure";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-settings',
  'title' => 'Post settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control posting behavior, such as teaser length, requiring previews before posting, and the number of posts on the front page.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.admin.inc',
])
->values([
  'path' => 'admin/content/node-settings/rebuild',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"node_configure_rebuild_confirm";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-settings/rebuild',
  'title' => 'Rebuild permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/article',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"article";s:4:"name";s:7:"Article";s:6:"module";s:4:"node";s:11:"description";s:34:"An <em>article</em>, content type.";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:5:"Title";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"story";}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Article',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/article/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"article";s:4:"name";s:7:"Article";s:6:"module";s:4:"node";s:11:"description";s:34:"An <em>article</em>, content type.";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:5:"Title";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"story";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/article/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/article/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:7:"article";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/article',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/article/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"article";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/article/display',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/article/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"article";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/article/display',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/article/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"article";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/article/display',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/article/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"article";s:4:"name";s:7:"Article";s:6:"module";s:4:"node";s:11:"description";s:34:"An <em>article</em>, content type.";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:5:"Title";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"story";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/article',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/article/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:7:"article";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/article',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/company',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"company";s:4:"name";s:7:"Company";s:6:"module";s:4:"node";s:11:"description";s:17:"Company node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:11:"Description";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:7:"company";}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Company',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/company/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"company";s:4:"name";s:7:"Company";s:6:"module";s:4:"node";s:11:"description";s:17:"Company node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:11:"Description";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:7:"company";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/company/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/company/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:7:"company";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/company',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/company/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"company";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/company/display',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/company/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"company";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/company/display',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/company/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"company";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/company/display',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/company/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"company";s:4:"name";s:7:"Company";s:6:"module";s:4:"node";s:11:"description";s:17:"Company node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:11:"Description";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:7:"company";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/company',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/company/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:7:"company";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/company',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/employee',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:8:"employee";s:4:"name";s:8:"Employee";s:6:"module";s:4:"node";s:11:"description";s:18:"Employee node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:3:"Bio";s:14:"min_word_count";s:2:"20";s:6:"custom";s:1:"0";s:8:"modified";s:1:"0";s:6:"locked";s:1:"0";s:9:"orig_type";s:8:"employee";}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Employee',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/employee/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"type";s:8:"employee";s:4:"name";s:8:"Employee";s:6:"module";s:4:"node";s:11:"description";s:18:"Employee node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:3:"Bio";s:14:"min_word_count";s:2:"20";s:6:"custom";s:1:"0";s:8:"modified";s:1:"0";s:6:"locked";s:1:"0";s:9:"orig_type";s:8:"employee";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/employee/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/employee/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:8:"employee";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/employee',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/employee/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:8:"employee";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/employee/display',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/employee/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:8:"employee";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/employee/display',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/employee/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:8:"employee";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/employee/display',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/employee/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:8:"employee";s:4:"name";s:8:"Employee";s:6:"module";s:4:"node";s:11:"description";s:18:"Employee node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:3:"Bio";s:14:"min_word_count";s:2:"20";s:6:"custom";s:1:"0";s:8:"modified";s:1:"0";s:6:"locked";s:1:"0";s:9:"orig_type";s:8:"employee";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/employee',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/employee/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:8:"employee";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/employee',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/employee/fields/field_commander',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:8:"employee";i:2;s:15:"field_commander";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/employee/fields',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Commanding Officer',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/employee/fields/field_commander/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:8:"employee";i:2;s:15:"field_commander";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/employee/fields/field_commander/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/employee/fields/field_company',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:8:"employee";i:2;s:13:"field_company";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/employee/fields',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Company',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/employee/fields/field_company/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:8:"employee";i:2;s:13:"field_company";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/employee/fields/field_company/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/employee/fields/field_company_2',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:8:"employee";i:2;s:15:"field_company_2";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/employee/fields',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Company 2',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/employee/fields/field_company_2/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:8:"employee";i:2;s:15:"field_company_2";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/employee/fields/field_company_2/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/employee/fields/field_company_3',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:8:"employee";i:2;s:15:"field_company_3";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/employee/fields',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Company 3',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/employee/fields/field_company_3/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:8:"employee";i:2;s:15:"field_company_3";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/employee/fields/field_company_3/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/forum',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":15:{s:4:"name";s:11:"Forum topic";s:6:"module";s:5:"forum";s:11:"description";s:85:"A <em>forum topic</em> is the initial post to a new discussion thread within a forum.";s:11:"title_label";s:7:"Subject";s:4:"type";s:5:"forum";s:9:"has_title";b:1;s:8:"has_body";b:1;s:10:"body_label";s:4:"Body";s:4:"help";s:0:"";s:14:"min_word_count";i:0;s:6:"custom";b:0;s:8:"modified";b:0;s:6:"locked";b:1;s:9:"orig_type";s:5:"forum";s:6:"is_new";b:1;}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/forum',
  'title' => 'Forum topic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/forum/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":15:{s:4:"name";s:11:"Forum topic";s:6:"module";s:5:"forum";s:11:"description";s:85:"A <em>forum topic</em> is the initial post to a new discussion thread within a forum.";s:11:"title_label";s:7:"Subject";s:4:"type";s:5:"forum";s:9:"has_title";b:1;s:8:"has_body";b:1;s:10:"body_label";s:4:"Body";s:4:"help";s:0:"";s:14:"min_word_count";i:0;s:6:"custom";b:0;s:8:"modified";b:0;s:6:"locked";b:1;s:9:"orig_type";s:5:"forum";s:6:"is_new";b:1;}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/forum/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/forum/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:5:"forum";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/forum',
  'tab_root' => 'admin/content/node-type/forum',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/forum/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:5:"forum";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/forum/display',
  'tab_root' => 'admin/content/node-type/forum',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/forum/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:5:"forum";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/forum/display',
  'tab_root' => 'admin/content/node-type/forum',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/forum/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:5:"forum";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/forum/display',
  'tab_root' => 'admin/content/node-type/forum',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/forum/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":15:{s:4:"name";s:11:"Forum topic";s:6:"module";s:5:"forum";s:11:"description";s:85:"A <em>forum topic</em> is the initial post to a new discussion thread within a forum.";s:11:"title_label";s:7:"Subject";s:4:"type";s:5:"forum";s:9:"has_title";b:1;s:8:"has_body";b:1;s:10:"body_label";s:4:"Body";s:4:"help";s:0:"";s:14:"min_word_count";i:0;s:6:"custom";b:0;s:8:"modified";b:0;s:6:"locked";b:1;s:9:"orig_type";s:5:"forum";s:6:"is_new";b:1;}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/forum',
  'tab_root' => 'admin/content/node-type/forum',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/forum/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:5:"forum";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/forum',
  'tab_root' => 'admin/content/node-type/forum',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/page',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:4:\"page\";s:4:\"name\";s:4:\"Page\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:4:\"page\";}}",
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'Page',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/page/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:24:\"node_type_delete_confirm\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:4:\"page\";s:4:\"name\";s:4:\"Page\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:4:\"page\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/page/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/page/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:4:"page";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/page',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/page/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:4:"page";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/page/display',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/page/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:4:"page";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/page/display',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/page/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:4:"page";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/page/display',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/page/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:4:\"page\";s:4:\"name\";s:4:\"Page\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:4:\"page\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/page',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/page/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:4:"page";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/page',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/page/fields/field_reference',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:4:"page";i:2;s:15:"field_reference";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/page/fields',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'Reference',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/page/fields/field_reference/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:4:"page";i:2;s:15:"field_reference";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/page/fields/field_reference/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/page/fields/field_reference_2',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:4:"page";i:2;s:17:"field_reference_2";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/page/fields',
  'tab_root' => 'admin/content/node-type/page',
  'title' => 'Reference',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/page/fields/field_reference_2/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:4:"page";i:2;s:17:"field_reference_2";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/page/fields/field_reference_2/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/sponsor',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"sponsor";s:4:"name";s:7:"Sponsor";s:6:"module";s:4:"node";s:11:"description";s:17:"Sponsor node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:0:"";}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Sponsor',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/sponsor/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"sponsor";s:4:"name";s:7:"Sponsor";s:6:"module";s:4:"node";s:11:"description";s:17:"Sponsor node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:0:"";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/sponsor/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/sponsor/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:7:"sponsor";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/sponsor',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/sponsor/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"sponsor";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/sponsor/display',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/sponsor/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"sponsor";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/sponsor/display',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/sponsor/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"sponsor";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/sponsor/display',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/sponsor/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"sponsor";s:4:"name";s:7:"Sponsor";s:6:"module";s:4:"node";s:11:"description";s:17:"Sponsor node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:0:"";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/sponsor',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/sponsor/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:7:"sponsor";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/sponsor',
  'tab_root' => 'admin/content/node-type/sponsor',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:5:\"story\";s:4:\"name\";s:5:\"Story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:5:\"story\";}}",
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Story',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/story/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:24:\"node_type_delete_confirm\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:5:\"story\";s:4:\"name\";s:5:\"Story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:5:\"story\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/story/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:5:"story";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/story',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:5:"story";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/display',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:5:"story";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/display',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:5:"story";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/display',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:5:\"story\";s:4:\"name\";s:5:\"Story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:5:\"story\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/story',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:5:"story";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/story',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:10:"field_test";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Text Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:10:"field_test";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_date',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:15:"field_test_date";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Date Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_date/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:15:"field_test_date";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_date/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_datestamp',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:20:"field_test_datestamp";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Date Stamp Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_datestamp/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:20:"field_test_datestamp";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_datestamp/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_datetime',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:19:"field_test_datetime";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Datetime Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_datetime/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:19:"field_test_datetime";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_datetime/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_decimal_radio_buttons',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:32:"field_test_decimal_radio_buttons";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Decimal Radio Buttons Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_decimal_radio_buttons/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:32:"field_test_decimal_radio_buttons";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_decimal_radio_buttons/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_email',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:16:"field_test_email";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Email Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_email/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:16:"field_test_email";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_email/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_exclude_unset',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:24:"field_test_exclude_unset";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Text Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_exclude_unset/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:24:"field_test_exclude_unset";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_exclude_unset/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_filefield',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:20:"field_test_filefield";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'File Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_filefield/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:20:"field_test_filefield";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_filefield/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_float_single_checkbox',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:32:"field_test_float_single_checkbox";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Float Single Checkbox Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_float_single_checkbox/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:32:"field_test_float_single_checkbox";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_float_single_checkbox/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_four',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:15:"field_test_four";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Float Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_four/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:15:"field_test_four";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_four/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_identical1',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:21:"field_test_identical1";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Integer Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_identical1/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:21:"field_test_identical1";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_identical1/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_identical2',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:21:"field_test_identical2";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Integer Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_identical2/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:21:"field_test_identical2";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_identical2/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_imagefield',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:21:"field_test_imagefield";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Image Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_imagefield/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:21:"field_test_imagefield";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_imagefield/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_integer_selectlist',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:29:"field_test_integer_selectlist";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Integer Select List Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_integer_selectlist/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:29:"field_test_integer_selectlist";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_integer_selectlist/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_link',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:15:"field_test_link";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Link Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_link/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:15:"field_test_link";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_link/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_phone',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:16:"field_test_phone";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Phone Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_phone/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:16:"field_test_phone";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_phone/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_string_selectlist',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:28:"field_test_string_selectlist";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'String Select List Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_string_selectlist/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:28:"field_test_string_selectlist";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_string_selectlist/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:31:"field_test_text_single_checkbox";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Text Single Checkbox Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:31:"field_test_text_single_checkbox";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox2',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:32:"field_test_text_single_checkbox2";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Text Single Checkbox Field 2',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox2/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:32:"field_test_text_single_checkbox2";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox2/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_three',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:16:"field_test_three";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Decimal Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_three/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:16:"field_test_three";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_three/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_two',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:5:"story";i:2;s:14:"field_test_two";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/story/fields',
  'tab_root' => 'admin/content/node-type/story',
  'title' => 'Integer Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/story/fields/field_test_two/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:5:"story";i:2;s:14:"field_test_two";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/story/fields/field_test_two/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-event',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:10:"test_event";s:4:"name";s:18:"Migrate test event";s:6:"module";s:4:"node";s:11:"description";s:27:"test event description here";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:10:"Event Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"event";}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-event',
  'title' => 'Migrate test event',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/test-event/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"type";s:10:"test_event";s:4:"name";s:18:"Migrate test event";s:6:"module";s:4:"node";s:11:"description";s:27:"test event description here";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:10:"Event Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"event";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-event/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/test-event/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:10:"test_event";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-event',
  'tab_root' => 'admin/content/node-type/test-event',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-event/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:10:"test_event";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-event/display',
  'tab_root' => 'admin/content/node-type/test-event',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-event/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:10:"test_event";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-event/display',
  'tab_root' => 'admin/content/node-type/test-event',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-event/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:10:"test_event";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-event/display',
  'tab_root' => 'admin/content/node-type/test-event',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-event/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:10:"test_event";s:4:"name";s:18:"Migrate test event";s:6:"module";s:4:"node";s:11:"description";s:27:"test event description here";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:10:"Event Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"event";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-event',
  'tab_root' => 'admin/content/node-type/test-event',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/test-event/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:10:"test_event";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-event',
  'tab_root' => 'admin/content/node-type/test-event',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-page',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:9:\"test_page\";s:4:\"name\";s:17:\"Migrate test page\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:28:\"This is the body field label\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:9:\"test_page\";}}",
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-page',
  'title' => 'Migrate test page',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/test-page/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:24:\"node_type_delete_confirm\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:9:\"test_page\";s:4:\"name\";s:17:\"Migrate test page\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:28:\"This is the body field label\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:9:\"test_page\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-page/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/test-page/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:9:"test_page";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-page',
  'tab_root' => 'admin/content/node-type/test-page',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-page/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:9:"test_page";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-page/display',
  'tab_root' => 'admin/content/node-type/test-page',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-page/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:9:"test_page";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-page/display',
  'tab_root' => 'admin/content/node-type/test-page',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-page/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:9:"test_page";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-page/display',
  'tab_root' => 'admin/content/node-type/test-page',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-page/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:9:\"test_page\";s:4:\"name\";s:17:\"Migrate test page\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"1\";s:10:\"body_label\";s:28:\"This is the body field label\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:9:\"test_page\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-page',
  'tab_root' => 'admin/content/node-type/test-page',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/test-page/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:9:"test_page";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-page',
  'tab_root' => 'admin/content/node-type/test-page',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-page/fields/field_test',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:9:"test_page";i:2;s:10:"field_test";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-page/fields',
  'tab_root' => 'admin/content/node-type/test-page',
  'title' => 'Text Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-page/fields/field_test/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:9:"test_page";i:2;s:10:"field_test";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-page/fields/field_test/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-planet',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:11:\"test_planet\";s:4:\"name\";s:19:\"Migrate test planet\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"0\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:11:\"test_planet\";}}",
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'Migrate test planet',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/test-planet/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:24:\"node_type_delete_confirm\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:11:\"test_planet\";s:4:\"name\";s:19:\"Migrate test planet\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"0\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:11:\"test_planet\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-planet/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/test-planet/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:11:"test_planet";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-planet',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-planet/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:11:"test_planet";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-planet/display',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-planet/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:11:"test_planet";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-planet/display',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-planet/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:11:"test_planet";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-planet/display',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-planet/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:11:\"test_planet\";s:4:\"name\";s:19:\"Migrate test planet\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"0\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:11:\"test_planet\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-planet',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/test-planet/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:11:"test_planet";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-planet',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-planet/fields/field_multivalue',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:11:"test_planet";i:2;s:16:"field_multivalue";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-planet/fields',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'Decimal Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-planet/fields/field_multivalue/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:11:"test_planet";i:2;s:16:"field_multivalue";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-planet/fields/field_multivalue/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-planet/fields/field_test_text_single_checkbox',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:23:"content_field_edit_form";i:1;s:11:"test_planet";i:2;s:31:"field_test_text_single_checkbox";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-planet/fields',
  'tab_root' => 'admin/content/node-type/test-planet',
  'title' => 'Text Single Checkbox Field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-planet/fields/field_test_text_single_checkbox/remove',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"content_field_remove_form";i:1;s:11:"test_planet";i:2;s:31:"field_test_text_single_checkbox";}',
  'fit' => '127',
  'number_parts' => '7',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-planet/fields/field_test_text_single_checkbox/remove',
  'title' => 'Remove field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-story',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:10:\"test_story\";s:4:\"name\";s:18:\"Migrate test story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"0\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:10:\"test_story\";}}",
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-story',
  'title' => 'Migrate test story',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/test-story/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:24:\"node_type_delete_confirm\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:10:\"test_story\";s:4:\"name\";s:18:\"Migrate test story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"0\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:10:\"test_story\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/test-story/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/test-story/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:10:"test_story";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-story',
  'tab_root' => 'admin/content/node-type/test-story',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-story/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:10:"test_story";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-story/display',
  'tab_root' => 'admin/content/node-type/test-story',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-story/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:10:"test_story";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-story/display',
  'tab_root' => 'admin/content/node-type/test-story',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-story/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:10:"test_story";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/test-story/display',
  'tab_root' => 'admin/content/node-type/test-story',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node-type/test-story/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => "a:2:{i:0;s:14:\"node_type_form\";i:1;O:8:\"stdClass\":14:{s:4:\"type\";s:10:\"test_story\";s:4:\"name\";s:18:\"Migrate test story\";s:6:\"module\";s:4:\"node\";s:11:\"description\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";s:4:\"help\";s:0:\"\";s:9:\"has_title\";s:1:\"1\";s:11:\"title_label\";s:5:\"Title\";s:8:\"has_body\";s:1:\"0\";s:10:\"body_label\";s:4:\"Body\";s:14:\"min_word_count\";s:1:\"0\";s:6:\"custom\";s:1:\"1\";s:8:\"modified\";s:1:\"1\";s:6:\"locked\";s:1:\"0\";s:9:\"orig_type\";s:10:\"test_story\";}}",
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-story',
  'tab_root' => 'admin/content/node-type/test-story',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/node-type/test-story/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:10:"test_story";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/test-story',
  'tab_root' => 'admin/content/node-type/test-story',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/node/overview',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer nodes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/node',
  'tab_root' => 'admin/content/node',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/node/node.admin.inc',
])
->values([
  'path' => 'admin/content/rss-publishing',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_rss_feeds_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/rss-publishing',
  'title' => 'RSS publishing',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Configure the number of items per feed and whether feeds should be titles/teasers/full-text.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/content/taxonomy',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"taxonomy_overview_vocabularies";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/taxonomy',
  'title' => 'Taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Manage tagging, categorization, and classification of your content.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'admin/content/taxonomy/%',
  'load_functions' => 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/taxonomy/%',
  'title' => 'List terms',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'admin/content/taxonomy/%/add/term',
  'load_functions' => 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'taxonomy_add_term_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '59',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/taxonomy/%',
  'tab_root' => 'admin/content/taxonomy/%',
  'title' => 'Add term',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'admin/content/taxonomy/%/list',
  'load_functions' => 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/taxonomy/%',
  'tab_root' => 'admin/content/taxonomy/%',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'admin/content/taxonomy/%/translation',
  'load_functions' => 'a:1:{i:3;s:24:"taxonomy_vocabulary_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_i18ntaxonomy_translation_tab',
  'access_arguments' => 'a:1:{i:0;i:3;}',
  'page_callback' => 'i18ntaxonomy_page_vocabulary',
  'page_arguments' => 'a:3:{i:0;i:3;i:1;i:5;i:2;i:6;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/taxonomy/%',
  'tab_root' => 'admin/content/taxonomy/%',
  'title' => 'Translation',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/i18n/i18ntaxonomy/i18ntaxonomy.admin.inc',
])
->values([
  'path' => 'admin/content/taxonomy/add/vocabulary',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"taxonomy_form_vocabulary";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/taxonomy',
  'tab_root' => 'admin/content/taxonomy',
  'title' => 'Add vocabulary',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'admin/content/taxonomy/edit/term',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'taxonomy_admin_term_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/taxonomy/edit/term',
  'title' => 'Edit term',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'admin/content/taxonomy/edit/vocabulary/%',
  'load_functions' => 'a:1:{i:5;s:24:"taxonomy_vocabulary_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'taxonomy_admin_vocabulary_edit',
  'page_arguments' => 'a:1:{i:0;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/content/taxonomy/edit/vocabulary/%',
  'title' => 'Edit vocabulary',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'admin/content/taxonomy/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"taxonomy_overview_vocabularies";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/taxonomy',
  'tab_root' => 'admin/content/taxonomy',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/taxonomy/taxonomy.admin.inc',
])
->values([
  'path' => 'admin/content/types',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'content_types_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/types',
  'title' => 'Content types',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Manage posts by content type, including default status, front page promotion, etc.',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/types/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"node_type_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/types',
  'tab_root' => 'admin/content/types',
  'title' => 'Add content type',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
])
->values([
  'path' => 'admin/content/types/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'content_fields_list',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/types',
  'tab_root' => 'admin/content/types',
  'title' => 'Fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/content/types/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'content_types_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/types',
  'tab_root' => 'admin/content/types',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
])
->values([
  'path' => 'admin/reports',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/reports',
  'title' => 'Reports',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'View reports from system logs and other status information.',
  'position' => 'left',
  'weight' => '5',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/reports/access/%',
  'load_functions' => 'a:1:{i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_access_log',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/access/%',
  'title' => 'Details',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => 'View access log.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/statistics/statistics.admin.inc',
])
->values([
  'path' => 'admin/reports/hits',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_recent_hits',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/hits',
  'title' => 'Recent hits',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'View pages that have recently been visited.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/statistics/statistics.admin.inc',
])
->values([
  'path' => 'admin/reports/pages',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_top_pages',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/pages',
  'title' => 'Top pages',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'View pages that have been hit frequently.',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/statistics/statistics.admin.inc',
])
->values([
  'path' => 'admin/reports/referrers',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_top_referrers',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/referrers',
  'title' => 'Top referrers',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'View top referrers.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/statistics/statistics.admin.inc',
])
->values([
  'path' => 'admin/reports/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:34:"statistics_access_logging_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/settings',
  'title' => 'Access log settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control details about what and how your site logs.',
  'position' => '',
  'weight' => '3',
  'file' => 'modules/statistics/statistics.admin.inc',
])
->values([
  'path' => 'admin/reports/status',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_status',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status',
  'title' => 'Status report',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Get a status report about your site's operation and any detected problems.",
  'position' => '',
  'weight' => '10',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/reports/status/php',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_php',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/php',
  'title' => 'PHP',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/reports/status/run-cron',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_run_cron',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/run-cron',
  'title' => 'Run cron',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/reports/status/sql',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_sql',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/sql',
  'title' => 'SQL',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/reports/visitors',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_top_visitors',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/visitors',
  'title' => 'Top visitors',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'View visitors that hit many pages.',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/statistics/statistics.admin.inc',
])
->values([
  'path' => 'admin/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_settings_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/settings',
  'title' => 'Site configuration',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Adjust basic site configuration options.',
  'position' => 'right',
  'weight' => '-5',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/settings/actions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/actions',
  'title' => 'Actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/settings/actions/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_actions_configure";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/actions/configure',
  'title' => 'Configure an advanced action',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/settings/actions/delete/%',
  'load_functions' => 'a:1:{i:4;s:12:"actions_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"system_actions_delete_form";i:1;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/actions/delete/%',
  'title' => 'Delete action',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => 'Delete an action.',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/settings/actions/manage',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/actions',
  'tab_root' => 'admin/settings/actions',
  'title' => 'Manage actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '-2',
  'file' => '',
])
->values([
  'path' => 'admin/settings/actions/orphan',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_remove_orphans',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/actions/orphan',
  'title' => 'Remove orphans',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/settings/admin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_admin_theme_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/admin',
  'title' => 'Administration theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => 'system_admin_theme_settings',
  'description' => 'Settings for how your administrative pages should look.',
  'position' => 'left',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/settings/clean-urls',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_clean_url_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/clean-urls',
  'title' => 'Clean URLs',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Enable or disable clean URLs for your site.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/settings/clean-urls/check',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_json',
  'page_arguments' => 'a:1:{i:0;a:1:{s:6:"status";b:1;}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/clean-urls/check',
  'title' => 'Clean URL check',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/settings/date-time',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/date-time',
  'title' => 'Date and time',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Settings for how Drupal displays date and time, as well as the system's default timezone.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/settings/date-time/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/date-time',
  'tab_root' => 'admin/settings/date-time',
  'title' => 'Date and time',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => "Settings for how Drupal displays date and time, as well as the system's default timezone.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/settings/date-time/delete/%',
  'load_functions' => 'a:1:{i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:32:"date_api_delete_format_type_form";i:1;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/date-time/delete/%',
  'title' => 'Delete date format type',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => 'Allow users to delete a configured date format type.',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/date/date_api.admin.inc',
])
->values([
  'path' => 'admin/settings/date-time/formats',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:26:"date_api_date_formats_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/date-time',
  'tab_root' => 'admin/settings/date-time',
  'title' => 'Formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => 'Allow users to configure date formats',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/date/date_api.admin.inc',
])
->values([
  'path' => 'admin/settings/date-time/formats/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"date_api_add_date_formats_form";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/date-time/formats',
  'tab_root' => 'admin/settings/date-time',
  'title' => 'Add format',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => 'Allow users to add additional date formats.',
  'position' => '',
  'weight' => '3',
  'file' => 'sites/all/modules/date/date_api.admin.inc',
])
->values([
  'path' => 'admin/settings/date-time/formats/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:26:"date_api_date_formats_form";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/date-time/formats',
  'tab_root' => 'admin/settings/date-time',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => 'Allow users to configure date formats',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/date/date_api.admin.inc',
])
->values([
  'path' => 'admin/settings/date-time/formats/custom',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'date_api_configure_custom_date_formats',
  'page_arguments' => 'a:0:{}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/date-time/formats',
  'tab_root' => 'admin/settings/date-time',
  'title' => 'Custom formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => 'Allow users to configure custom date formats.',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/date/date_api.admin.inc',
])
->values([
  'path' => 'admin/settings/date-time/formats/delete/%',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"date_api_delete_format_form";i:1;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/date-time/formats/delete/%',
  'title' => 'Delete date format',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => 'Allow users to delete a configured date format.',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/date/date_api.admin.inc',
])
->values([
  'path' => 'admin/settings/date-time/formats/lookup',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'date_api_date_time_lookup',
  'page_arguments' => 'a:0:{}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/date-time/formats/lookup',
  'title' => 'Date and time lookup',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/settings/date-time/lookup',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_date_time_lookup',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/date-time/lookup',
  'title' => 'Date and time lookup',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/settings/email',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"email_admin_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/email',
  'title' => 'CCK Email Contact Form Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Administer flood control settings for email contact forms',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/settings/error-reporting',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:31:"system_error_reporting_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/error-reporting',
  'title' => 'Error reporting',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control how Drupal deals with errors including 403/404 errors as well as PHP error reporting.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/settings/event',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/event',
  'title' => 'Events',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Set up how your site handles events.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/settings/event/overview',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:29:"event_admin_overview_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/event/overview',
  'title' => 'Event overview',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Change how event summary information is displayed.',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/settings/event/timezone',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:29:"event_admin_timezone_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/event/timezone',
  'title' => 'Timezone handling',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Change how timezone information is saved and displayed.',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/settings/file-system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_file_system_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/file-system',
  'title' => 'File system',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Tell Drupal where to store uploaded files and how they are accessed.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/settings/filters',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/filters',
  'title' => 'Input formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
])
->values([
  'path' => 'admin/settings/filters/%',
  'load_functions' => 'a:1:{i:3;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/filters/%',
  'title' => '',
  'title_callback' => 'filter_admin_format_title',
  'title_arguments' => 'a:1:{i:0;i:3;}',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
])
->values([
  'path' => 'admin/settings/filters/%/configure',
  'load_functions' => 'a:1:{i:3;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_configure_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/filters/%',
  'tab_root' => 'admin/settings/filters/%',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/filter/filter.admin.inc',
])
->values([
  'path' => 'admin/settings/filters/%/edit',
  'load_functions' => 'a:1:{i:3;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/filters/%',
  'tab_root' => 'admin/settings/filters/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
])
->values([
  'path' => 'admin/settings/filters/%/order',
  'load_functions' => 'a:1:{i:3;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_order_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/filters/%',
  'tab_root' => 'admin/settings/filters/%',
  'title' => 'Rearrange',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/filter/filter.admin.inc',
])
->values([
  'path' => 'admin/settings/filters/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/filters',
  'tab_root' => 'admin/settings/filters',
  'title' => 'Add input format',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/filter/filter.admin.inc',
])
->values([
  'path' => 'admin/settings/filters/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"filter_admin_delete";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/filters/delete',
  'title' => 'Delete input format',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
])
->values([
  'path' => 'admin/settings/filters/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/filters',
  'tab_root' => 'admin/settings/filters',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.admin.inc',
])
->values([
  'path' => 'admin/settings/image-toolkit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:29:"system_image_toolkit_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/image-toolkit',
  'title' => 'Image toolkit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Choose which image toolkit to use if you have installed optional toolkits.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/settings/imageapi',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer imageapi";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:17:"imageapi_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/imageapi',
  'title' => 'ImageAPI',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Configure ImageAPI.',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/settings/language',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:2:{i:0;s:15:"drupal_get_form";i:1;s:30:"locale_languages_overview_form";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/language',
  'title' => 'Languages',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Configure languages for content and the user interface.',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/settings/language/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:1:{i:0;s:27:"locale_languages_add_screen";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/language',
  'tab_root' => 'admin/settings/language',
  'title' => 'Add language',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'file' => '',
])
->values([
  'path' => 'admin/settings/language/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:2:{i:0;s:15:"drupal_get_form";i:1;s:31:"locale_languages_configure_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/language',
  'tab_root' => 'admin/settings/language',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'file' => '',
])
->values([
  'path' => 'admin/settings/language/configure/language',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:2:{i:0;s:15:"drupal_get_form";i:1;s:31:"locale_languages_configure_form";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/language/configure',
  'tab_root' => 'admin/settings/language',
  'title' => 'Language negotiation',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => '',
])
->values([
  'path' => 'admin/settings/language/configure/strings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:26:"i18nstrings_admin_settings";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/language/configure',
  'tab_root' => 'admin/settings/language',
  'title' => 'String translation',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '20',
  'file' => 'sites/all/modules/i18n/i18nstrings/i18nstrings.admin.inc',
])
->values([
  'path' => 'admin/settings/language/delete/%',
  'load_functions' => 'a:1:{i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:3:{i:0;s:15:"drupal_get_form";i:1;s:28:"locale_languages_delete_form";i:2;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/language/delete/%',
  'title' => 'Confirm',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/settings/language/edit/%',
  'load_functions' => 'a:1:{i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:3:{i:0;s:15:"drupal_get_form";i:1;s:26:"locale_languages_edit_form";i:2;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/language/edit/%',
  'title' => 'Edit language',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/settings/language/i18n',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"i18n_admin_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/language',
  'tab_root' => 'admin/settings/language',
  'title' => 'Multilingual system',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => 'Configure extended options for multilingual content and translations.',
  'position' => '',
  'weight' => '10',
  'file' => 'sites/all/modules/i18n/i18n.admin.inc',
])
->values([
  'path' => 'admin/settings/language/i18n/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"i18n_admin_settings";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/settings/language/i18n',
  'tab_root' => 'admin/settings/language',
  'title' => 'Multilingual system',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => 'Configure extended options for multilingual content and translations.',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/i18n/i18n.admin.inc',
])
->values([
  'path' => 'admin/settings/language/overview',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer languages";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:2:{i:0;s:15:"drupal_get_form";i:1;s:30:"locale_languages_overview_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/language',
  'tab_root' => 'admin/settings/language',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'admin/settings/logging',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_logging_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/logging',
  'title' => 'Logging and alerts',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Settings for logging and alerts modules. Various modules can route Drupal's system events to different destination, such as syslog, database, email, ...etc.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/settings/performance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_performance_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/performance',
  'title' => 'Performance',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/settings/site-information',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_site_information_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/site-information',
  'title' => 'Site information',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Change basic site information, such as the site name, slogan, e-mail address, mission, front page and more.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/settings/site-maintenance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_site_maintenance_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/site-maintenance',
  'title' => 'Site maintenance',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Take the site off-line for maintenance or bring it back online.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/settings/uploads',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"upload_admin_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/uploads',
  'title' => 'File uploads',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control how files may be attached to content.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/upload/upload.admin.inc',
])
->values([
  'path' => 'admin/settings/variable',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'variable_admin_page_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/variable',
  'title' => 'Variables',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Edit and delete site variables.',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/variable/variable_admin/variable_admin.pages.inc',
])
->values([
  'path' => 'admin/settings/variable/edit/%',
  'load_functions' => 'a:1:{i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'variable_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'variable_admin_page_edit',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/variable/edit/%',
  'title' => 'Edit variable',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/variable/variable_admin/variable_admin.pages.inc',
])
->values([
  'path' => 'admin/settings/variable/group',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'variable_admin_page_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/variable',
  'tab_root' => 'admin/settings/variable',
  'title' => 'By group',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => 'Variables by group.',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/variable/variable_admin/variable_admin.pages.inc',
])
->values([
  'path' => 'admin/settings/variable/group/%',
  'load_functions' => 'a:1:{i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'variable_admin_page_group',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/settings/variable/group/%',
  'title' => 'Variables group',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Edit and delete group variables.',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/variable/variable_admin/variable_admin.pages.inc',
])
->values([
  'path' => 'admin/settings/variable/modules',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'variable_admin_page_modules',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/variable',
  'tab_root' => 'admin/settings/variable',
  'title' => 'By module',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => 'Variables by module.',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/variable/variable_admin/variable_admin.pages.inc',
])
->values([
  'path' => 'admin/settings/variable/undefined',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'variable_admin_page_undefined',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/settings/variable',
  'tab_root' => 'admin/settings/variable',
  'title' => 'Undefined',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => 'Unknown variables.',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/variable/variable_admin/variable_admin.pages.inc',
])
->values([
  'path' => 'admin/user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/user',
  'title' => 'User management',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Manage your site's users, groups and access to site features.",
  'position' => 'left',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'admin/user/permissions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:15:"user_admin_perm";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/permissions',
  'title' => 'Permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Determine access to features by selecting permissions for roles.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/user/profile',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"profile_admin_overview";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/profile',
  'title' => 'Profiles',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Create customizable fields for your users.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/profile/profile.admin.inc',
])
->values([
  'path' => 'admin/user/profile/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"profile_field_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/profile/add',
  'title' => 'Add field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/profile/profile.admin.inc',
])
->values([
  'path' => 'admin/user/profile/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'profile_admin_settings_autocomplete',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/profile/autocomplete',
  'title' => 'Profile category autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/profile/profile.admin.inc',
])
->values([
  'path' => 'admin/user/profile/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"profile_field_delete";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/profile/delete',
  'title' => 'Delete field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/profile/profile.admin.inc',
])
->values([
  'path' => 'admin/user/profile/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"profile_field_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/profile/edit',
  'title' => 'Edit field',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/profile/profile.admin.inc',
])
->values([
  'path' => 'admin/user/roles',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_new_role";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/roles',
  'title' => 'Roles',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'List, edit, or add user roles.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/user/roles/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:15:"user_admin_role";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/roles/edit',
  'title' => 'Edit role',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/user/rules',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/rules',
  'title' => 'Access rules',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'List and create rules to disallow usernames, e-mail addresses, and IP addresses.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/user/rules/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access_add',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/rules',
  'tab_root' => 'admin/user/rules',
  'title' => 'Add rule',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/user/rules/check',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access_check',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/rules',
  'tab_root' => 'admin/user/rules',
  'title' => 'Check rules',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/user/rules/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"user_admin_access_delete_confirm";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/rules/delete',
  'title' => 'Delete rule',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/user/rules/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/user/rules/edit',
  'title' => 'Edit rule',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/user/rules/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'user_admin_access',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/rules',
  'tab_root' => 'admin/user/rules',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/user/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_settings";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/settings',
  'title' => 'User settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Configure default behavior of users, including registration requirements, e-mails, and user pictures.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/user/user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/user/user',
  'title' => 'Users',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'List, add, and edit users.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/user/user/create',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:6:"create";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/user',
  'tab_root' => 'admin/user/user',
  'title' => 'Add user',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'admin/user/user/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/user/user',
  'tab_root' => 'admin/user/user',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/user/user.admin.inc',
])
->values([
  'path' => 'aggregator',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access news feeds";}',
  'page_callback' => 'aggregator_page_last',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'aggregator',
  'title' => 'Feed aggregator',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'file' => 'modules/aggregator/aggregator.pages.inc',
])
->values([
  'path' => 'aggregator/categories',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_aggregator_has_categories',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'aggregator_page_categories',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'aggregator/categories',
  'title' => 'Categories',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.pages.inc',
])
->values([
  'path' => 'aggregator/categories/%',
  'load_functions' => 'a:1:{i:2;s:24:"aggregator_category_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access news feeds";}',
  'page_callback' => 'aggregator_page_category',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '6',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'aggregator/categories/%',
  'title' => '',
  'title_callback' => '_aggregator_category_title',
  'title_arguments' => 'a:1:{i:0;i:2;}',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.pages.inc',
])
->values([
  'path' => 'aggregator/categories/%/categorize',
  'load_functions' => 'a:1:{i:2;s:24:"aggregator_category_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"aggregator_page_category";i:1;i:2;}',
  'fit' => '13',
  'number_parts' => '4',
  'tab_parent' => 'aggregator/categories/%',
  'tab_root' => 'aggregator/categories/%',
  'title' => 'Categorize',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.pages.inc',
])
->values([
  'path' => 'aggregator/categories/%/configure',
  'load_functions' => 'a:1:{i:2;s:24:"aggregator_category_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"aggregator_form_category";i:1;i:2;}',
  'fit' => '13',
  'number_parts' => '4',
  'tab_parent' => 'aggregator/categories/%',
  'tab_root' => 'aggregator/categories/%',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/aggregator/aggregator.admin.inc',
])
->values([
  'path' => 'aggregator/categories/%/view',
  'load_functions' => 'a:1:{i:2;s:24:"aggregator_category_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access news feeds";}',
  'page_callback' => 'aggregator_page_category',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '13',
  'number_parts' => '4',
  'tab_parent' => 'aggregator/categories/%',
  'tab_root' => 'aggregator/categories/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/aggregator/aggregator.pages.inc',
])
->values([
  'path' => 'aggregator/opml',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access news feeds";}',
  'page_callback' => 'aggregator_page_opml',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'aggregator/opml',
  'title' => 'OPML feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.pages.inc',
])
->values([
  'path' => 'aggregator/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access news feeds";}',
  'page_callback' => 'aggregator_page_rss',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'aggregator/rss',
  'title' => 'RSS feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.pages.inc',
])
->values([
  'path' => 'aggregator/sources',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access news feeds";}',
  'page_callback' => 'aggregator_page_sources',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'aggregator/sources',
  'title' => 'Sources',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.pages.inc',
])
->values([
  'path' => 'aggregator/sources/%',
  'load_functions' => 'a:1:{i:2;s:20:"aggregator_feed_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access news feeds";}',
  'page_callback' => 'aggregator_page_source',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '6',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'aggregator/sources/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.pages.inc',
])
->values([
  'path' => 'aggregator/sources/%/categorize',
  'load_functions' => 'a:1:{i:2;s:20:"aggregator_feed_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:22:"aggregator_page_source";i:1;i:2;}',
  'fit' => '13',
  'number_parts' => '4',
  'tab_parent' => 'aggregator/sources/%',
  'tab_root' => 'aggregator/sources/%',
  'title' => 'Categorize',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.pages.inc',
])
->values([
  'path' => 'aggregator/sources/%/configure',
  'load_functions' => 'a:1:{i:2;s:20:"aggregator_feed_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"aggregator_form_feed";i:1;i:2;}',
  'fit' => '13',
  'number_parts' => '4',
  'tab_parent' => 'aggregator/sources/%',
  'tab_root' => 'aggregator/sources/%',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/aggregator/aggregator.admin.inc',
])
->values([
  'path' => 'aggregator/sources/%/view',
  'load_functions' => 'a:1:{i:2;s:20:"aggregator_feed_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access news feeds";}',
  'page_callback' => 'aggregator_page_source',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '13',
  'number_parts' => '4',
  'tab_parent' => 'aggregator/sources/%',
  'tab_root' => 'aggregator/sources/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/aggregator/aggregator.pages.inc',
])
->values([
  'path' => 'batch',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'system_batch_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'batch',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
])
->values([
  'path' => 'book',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'book_render',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'book',
  'title' => 'Books',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '20',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/book/book.pages.inc',
])
->values([
  'path' => 'book/export/%/%',
  'load_functions' => 'a:2:{i:2;N;i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:31:"access printer-friendly version";}',
  'page_callback' => 'book_export',
  'page_arguments' => 'a:2:{i:0;i:2;i:1;i:3;}',
  'fit' => '12',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'book/export/%/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/book/book.pages.inc',
])
->values([
  'path' => 'book/js/form',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'book_form_update',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'book/js/form',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/book/book.pages.inc',
])
->values([
  'path' => 'comment/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_delete',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'comment/delete',
  'title' => 'Delete comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.admin.inc',
])
->values([
  'path' => 'comment/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:13:"post comments";}',
  'page_callback' => 'comment_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'comment/edit',
  'title' => 'Edit comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.pages.inc',
])
->values([
  'path' => 'comment/reply/%',
  'load_functions' => 'a:1:{i:2;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:2;}',
  'page_callback' => 'comment_reply',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '6',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'comment/reply/%',
  'title' => 'Reply to comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.pages.inc',
])
->values([
  'path' => 'contact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"access site-wide contact form";}',
  'page_callback' => 'contact_site_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'contact',
  'title' => 'Contact',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '20',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/contact/contact.pages.inc',
])
->values([
  'path' => 'content/js_add_more',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'content_add_more_js',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'content/js_add_more',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.node_form.inc',
])
->values([
  'path' => 'core/tests/fixtures/files/imagecache',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_imagecache_menu_access_public_files',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'imagecache_cache',
  'page_arguments' => 'a:0:{}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'core/tests/fixtures/files/imagecache',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'email/%/%',
  'load_functions' => 'a:2:{i:1;s:9:"node_load";i:2;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'email_mail_page',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;i:2;}',
  'fit' => '4',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'email/%/%',
  'title' => 'Email Contact Form',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'event',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'event_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'event',
  'title' => 'Events',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '20',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/event/ical.inc',
])
->values([
  'path' => 'event/dst',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'event_dst',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'event/dst',
  'title' => 'Event dst view',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'event/feed',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'event_feed',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'event/feed',
  'title' => 'Event rss feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'event/ical',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'event_ical',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'event/ical',
  'title' => 'Event ical feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/event/ical.inc',
])
->values([
  'path' => 'event/term',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'event_term',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'event/term',
  'title' => 'Filter by taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'event/type',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'event_type',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'event/type',
  'title' => 'Filter by content type',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'filefield/ahah/%/%/%',
  'load_functions' => 'a:3:{i:2;N;i:3;N;i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'filefield_edit_access',
  'access_arguments' => 'a:2:{i:0;i:2;i:1;i:3;}',
  'page_callback' => 'filefield_js',
  'page_arguments' => 'a:3:{i:0;i:2;i:1;i:3;i:2;i:4;}',
  'fit' => '24',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'filefield/ahah/%/%/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'filefield/progress',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'filefield_progress',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'filefield/progress',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'filter/tips',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'filter_tips_long',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'filter/tips',
  'title' => 'Compose tips',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '20',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/filter/filter.pages.inc',
])
->values([
  'path' => 'forum',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'forum_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'forum',
  'title' => 'Forums',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '20',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.pages.inc',
])
->values([
  'path' => 'i18n/node/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'i18n_node_autocomplete',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'i18n/node/autocomplete',
  'title' => 'Node title autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/i18n/i18n.pages.inc',
])
->values([
  'path' => 'i18nstrings/save',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"use on-page translation";}',
  'page_callback' => 'i18nstrings_save_string',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'i18nstrings/save',
  'title' => 'Save string',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'logout',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_logged_in',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_logout',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'logout',
  'title' => 'Log out',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_page_default',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'node',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'node/%',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '2',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'node/%',
  'title' => '',
  'title_callback' => 'node_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'node/%/delete',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"delete";i:1;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"node_delete_confirm";i:1;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/%/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/%/edit',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"update";i:1;i:1;}',
  'page_callback' => 'node_page_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/%/ical',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'event_ical_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'event_node_ical',
  'page_arguments' => 'a:0:{}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/%/ical',
  'title' => 'Event ical',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/event/ical.inc',
])
->values([
  'path' => 'node/%/outline',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_book_outline_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'book_outline',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Outline',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/book/book.pages.inc',
])
->values([
  'path' => 'node/%/outline/remove',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_book_outline_remove_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:16:"book_remove_form";i:1;i:1;}',
  'fit' => '11',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'node/%/outline/remove',
  'title' => 'Remove from outline',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/book/book.pages.inc',
])
->values([
  'path' => 'node/%/revisions',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_revision_overview',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/%/revisions/%/delete',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"delete";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_delete_confirm";i:1;i:1;}',
  'fit' => '21',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/delete',
  'title' => 'Delete earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/%/revisions/%/revert',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"update";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_revert_confirm";i:1;i:1;}',
  'fit' => '21',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/revert',
  'title' => 'Revert to earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/%/revisions/%/view',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_show',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;N;i:2;b:1;}',
  'fit' => '21',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/view',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'node/%/track',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_node_tracker',
  'page_arguments' => 'a:0:{}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Track',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/statistics/statistics.pages.inc',
])
->values([
  'path' => 'node/%/translate',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_translation_tab_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'i18n_translation_node_overview',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Translate',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/i18n/i18n.pages.inc',
])
->values([
  'path' => 'node/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => '',
])
->values([
  'path' => 'node/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_node_add_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'i18ncontent_node_add_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'node/add',
  'title' => 'Create content',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/add/article',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:7:"article";}',
  'page_callback' => 'i18ncontent_node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/article',
  'title' => 'Article',
  'title_callback' => 'i18nstrings_title_callback',
  'title_arguments' => 'a:2:{i:0;s:26:"nodetype:type:article:name";i:1;s:7:"Article";}',
  'type' => '6',
  'block_callback' => '',
  'description' => 'An <em>article</em>, content type.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/add/company',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:7:"company";}',
  'page_callback' => 'i18ncontent_node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/company',
  'title' => 'Company',
  'title_callback' => 'i18nstrings_title_callback',
  'title_arguments' => 'a:2:{i:0;s:26:"nodetype:type:company:name";i:1;s:7:"Company";}',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Company node type',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/add/employee',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:8:"employee";}',
  'page_callback' => 'i18ncontent_node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/employee',
  'title' => 'Employee',
  'title_callback' => 'i18nstrings_title_callback',
  'title_arguments' => 'a:2:{i:0;s:27:"nodetype:type:employee:name";i:1;s:8:"Employee";}',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Employee node type',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/add/forum',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:5:"forum";}',
  'page_callback' => 'i18ncontent_node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/forum',
  'title' => 'Forum topic',
  'title_callback' => 'i18nstrings_title_callback',
  'title_arguments' => 'a:2:{i:0;s:24:"nodetype:type:forum:name";i:1;s:11:"Forum topic";}',
  'type' => '6',
  'block_callback' => '',
  'description' => 'A <em>forum topic</em> is the initial post to a new discussion thread within a forum.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/add/page',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:4:"page";}',
  'page_callback' => 'i18ncontent_node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/page',
  'title' => 'Page',
  'title_callback' => 'i18nstrings_title_callback',
  'title_arguments' => 'a:2:{i:0;s:23:"nodetype:type:page:name";i:1;s:4:"Page";}',
  'type' => '6',
  'block_callback' => '',
  'description' => "A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/add/sponsor',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:7:"sponsor";}',
  'page_callback' => 'i18ncontent_node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/sponsor',
  'title' => 'Sponsor',
  'title_callback' => 'i18nstrings_title_callback',
  'title_arguments' => 'a:2:{i:0;s:26:"nodetype:type:sponsor:name";i:1;s:7:"Sponsor";}',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Sponsor node type',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/add/story',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:5:"story";}',
  'page_callback' => 'i18ncontent_node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/story',
  'title' => 'Story',
  'title_callback' => 'i18nstrings_title_callback',
  'title_arguments' => 'a:2:{i:0;s:24:"nodetype:type:story:name";i:1;s:5:"Story";}',
  'type' => '6',
  'block_callback' => '',
  'description' => "A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/add/test-event',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:10:"test_event";}',
  'page_callback' => 'i18ncontent_node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/test-event',
  'title' => 'Migrate test event',
  'title_callback' => 'i18nstrings_title_callback',
  'title_arguments' => 'a:2:{i:0;s:29:"nodetype:type:test-event:name";i:1;s:18:"Migrate test event";}',
  'type' => '6',
  'block_callback' => '',
  'description' => 'test event description here',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/add/test-page',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:9:"test_page";}',
  'page_callback' => 'i18ncontent_node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/test-page',
  'title' => 'Migrate test page',
  'title_callback' => 'i18nstrings_title_callback',
  'title_arguments' => 'a:2:{i:0;s:28:"nodetype:type:test-page:name";i:1;s:17:"Migrate test page";}',
  'type' => '6',
  'block_callback' => '',
  'description' => "A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/add/test-planet',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:11:"test_planet";}',
  'page_callback' => 'i18ncontent_node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/test-planet',
  'title' => 'Migrate test planet',
  'title_callback' => 'i18nstrings_title_callback',
  'title_arguments' => 'a:2:{i:0;s:30:"nodetype:type:test-planet:name";i:1;s:19:"Migrate test planet";}',
  'type' => '6',
  'block_callback' => '',
  'description' => "A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'node/add/test-story',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:10:"test_story";}',
  'page_callback' => 'i18ncontent_node_add',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'node/add/test-story',
  'title' => 'Migrate test story',
  'title_callback' => 'i18nstrings_title_callback',
  'title_arguments' => 'a:2:{i:0;s:29:"nodetype:type:test-story:name";i:1;s:18:"Migrate test story";}',
  'type' => '6',
  'block_callback' => '',
  'description' => "A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.pages.inc',
])
->values([
  'path' => 'nodereference/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'nodereference_autocomplete_access',
  'access_arguments' => 'a:1:{i:0;i:2;}',
  'page_callback' => 'nodereference_autocomplete',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'nodereference/autocomplete',
  'title' => 'Nodereference autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'profile',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"access user profiles";}',
  'page_callback' => 'profile_browse',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'profile',
  'title' => 'User list',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '20',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/profile/profile.pages.inc',
])
->values([
  'path' => 'profile/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"access user profiles";}',
  'page_callback' => 'profile_autocomplete',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'profile/autocomplete',
  'title' => 'Profile autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/profile/profile.pages.inc',
])
->values([
  'path' => 'rss.xml',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_feed',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'rss.xml',
  'title' => 'RSS feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'system/files',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:1:{i:0;s:19:"view uploaded files";}',
  'page_callback' => 'file_download',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'system/files',
  'title' => 'File download',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'system/files/imagecache',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'imagecache_cache_private',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'system/files/imagecache',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'taxonomy/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'i18ntaxonomy_autocomplete',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/autocomplete',
  'title' => 'Autocomplete taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/i18n/i18ntaxonomy/i18ntaxonomy.pages.inc',
])
->values([
  'path' => 'taxonomy/term/%',
  'load_functions' => 'a:1:{i:2;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'i18ntaxonomy_term_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'fit' => '6',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Taxonomy term',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/i18n/i18ntaxonomy/i18ntaxonomy.pages.inc',
])
->values([
  'path' => 'upload/js',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:12:"upload files";}',
  'page_callback' => 'upload_js',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'upload/js',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'user',
  'title' => 'User account',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/%',
  'load_functions' => 'a:1:{i:1;s:22:"user_uid_optional_load";}',
  'to_arg_functions' => 'a:1:{i:1;s:24:"user_uid_optional_to_arg";}',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '2',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'user/%',
  'title' => 'My account',
  'title_callback' => 'user_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/%/contact',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_contact_user_tab_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'contact_user_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Contact',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/contact/contact.pages.inc',
])
->values([
  'path' => 'user/%/delete',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_delete_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"user_confirm_delete";i:1;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'user/%/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/%/edit',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_edit_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/%/edit/account',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_edit_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '11',
  'number_parts' => '4',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => 'Account',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/%/edit/Administrative data',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'profile_category_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:19:"Administrative data";}',
  'page_callback' => 'user_edit',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;i:3;}',
  'fit' => '11',
  'number_parts' => '4',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => '',
  'title_callback' => 'i18nprofile_translate_category',
  'title_arguments' => 'a:1:{i:0;s:19:"Administrative data";}',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '3',
  'file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/%/edit/Communication preferences',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'profile_category_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:25:"Communication preferences";}',
  'page_callback' => 'user_edit',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;i:3;}',
  'fit' => '11',
  'number_parts' => '4',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => '',
  'title_callback' => 'i18nprofile_translate_category',
  'title_arguments' => 'a:1:{i:0;s:25:"Communication preferences";}',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '3',
  'file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/%/edit/Personal information',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'profile_category_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:20:"Personal information";}',
  'page_callback' => 'user_edit',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;i:3;}',
  'fit' => '11',
  'number_parts' => '4',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => '',
  'title_callback' => 'i18nprofile_translate_category',
  'title_arguments' => 'a:1:{i:0;s:20:"Personal information";}',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '3',
  'file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/%/track/navigation',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"access statistics";}',
  'page_callback' => 'statistics_user_tracker',
  'page_arguments' => 'a:0:{}',
  'fit' => '11',
  'number_parts' => '4',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Track page visits',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/statistics/statistics.pages.inc',
])
->values([
  'path' => 'user/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'fit' => '5',
  'number_parts' => '3',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"access user profiles";}',
  'page_callback' => 'user_autocomplete',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'user/autocomplete',
  'title' => 'User autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/login',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_anonymous',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Log in',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/password',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_anonymous',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:9:"user_pass";}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Request new password',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/register',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_register_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:13:"user_register";}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Create new account',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/reset/%/%/%',
  'load_functions' => 'a:3:{i:2;N;i:3;N;i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:15:"user_pass_reset";i:1;i:2;i:2;i:3;i:3;i:4;}',
  'fit' => '24',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'user/reset/%/%/%',
  'title' => 'Reset password',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/user/user.pages.inc',
])
->values([
  'path' => 'user/timezone',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_timezone',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'user/timezone',
  'title' => 'User timezone',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->values([
  'path' => 'userreference/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'userreference_autocomplete',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'userreference/autocomplete',
  'title' => 'Userreference autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
])
->execute();
$connection->schema()->createTable('node', [
  'fields' => [
    'nid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ],
    'created' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'changed' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'comment' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'promote' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'moderate' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'sticky' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'tnid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'translate' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'nid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('node_access', [
  'fields' => [
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'gid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'realm' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'grant_view' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'grant_update' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'grant_delete' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'nid',
    'gid',
    'realm',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('node_access')
->fields([
  'nid',
  'gid',
  'realm',
  'grant_view',
  'grant_update',
  'grant_delete',
])
->values([
  'nid' => '0',
  'gid' => '0',
  'realm' => 'all',
  'grant_view' => '1',
  'grant_update' => '0',
  'grant_delete' => '0',
])
->execute();
$connection->schema()->createTable('node_comment_statistics', [
  'fields' => [
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'last_comment_timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'last_comment_name' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '60',
    ],
    'last_comment_uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'comment_count' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'nid',
  ],
  'indexes' => [
    'comment_count' => [
      'comment_count',
    ],
    'last_comment_uid' => [
      'last_comment_uid',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('node_counter', [
  'fields' => [
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'totalcount' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'daycount' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'nid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('node_revisions', [
  'fields' => [
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'vid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'body' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'teaser' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'log' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'format' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'vid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('node_type', [
  'fields' => [
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ],
    'description' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'help' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'has_title' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'title_label' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'has_body' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'body_label' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'min_word_count' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'custom' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'modified' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'locked' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'orig_type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
  ],
  'primary key' => [
    'type',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('node_type')
->fields([
  'type',
  'name',
  'module',
  'description',
  'help',
  'has_title',
  'title_label',
  'has_body',
  'body_label',
  'min_word_count',
  'custom',
  'modified',
  'locked',
  'orig_type',
])
->values([
  'type' => 'article',
  'name' => 'Article',
  'module' => 'node',
  'description' => 'An <em>article</em>, content type.',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'has_body' => '1',
  'body_label' => 'Body',
  'min_word_count' => '0',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'orig_type' => 'story',
])
->values([
  'type' => 'page',
  'name' => 'Page',
  'module' => 'node',
  'description' => "A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.",
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'has_body' => '1',
  'body_label' => 'Body',
  'min_word_count' => '0',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'orig_type' => 'page',
])
->execute();
$connection->schema()->createTable('permission', [
  'fields' => [
    'pid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'rid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'perm' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'tid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'pid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('permission')
->fields([
  'pid',
  'rid',
  'perm',
  'tid',
])
->values([
  'pid' => '1',
  'rid' => '1',
  'perm' => 'access content, migrate test anonymous permission',
  'tid' => '0',
])
->values([
  'pid' => '2',
  'rid' => '2',
  'perm' => 'access comments, access content, post comments, post comments without approval, migrate test authenticated permission',
  'tid' => '0',
])
->execute();
$connection->schema()->createTable('profile_fields', [
  'fields' => [
    'fid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'explanation' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'category' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
    'page' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '128',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'required' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'register' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'visibility' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'autocomplete' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'options' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'fid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('profile_values', [
  'fields' => [
    'fid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'value' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'fid',
    'uid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('role', [
  'fields' => [
    'rid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
  ],
  'primary key' => [
    'rid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('role')
->fields([
  'rid',
  'name',
])
->values([
  'rid' => '1',
  'name' => 'anonymous user',
])
->values([
  'rid' => '2',
  'name' => 'authenticated user',
])
->values([
  'rid' => '3',
  'name' => 'migrate test role 1',
])
->values([
  'rid' => '4',
  'name' => 'migrate test role 2',
])
->values([
  'rid' => '5',
  'name' => 'migrate test role 3 that is longer than thirty two characters',
])
->execute();
$connection->schema()->createTable('semaphore', [
  'fields' => [
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'value' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'expire' => [
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '10',
      'scale' => '0',
    ],
  ],
  'primary key' => [
    'name',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('sessions', [
  'fields' => [
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'sid' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ],
    'hostname' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'cache' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'session' => [
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ],
  ],
  'primary key' => [
    'sid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('system', [
  'fields' => [
    'filename' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'owner' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'throttle' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'bootstrap' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'schema_version' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '-1',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'info' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'filename',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('system')
->fields([
  'filename',
  'name',
  'type',
  'owner',
  'status',
  'throttle',
  'bootstrap',
  'schema_version',
  'weight',
  'info',
])
->values([
  'filename' => 'modules/aggregator/aggregator.module',
  'name' => 'aggregator',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Aggregator";s:11:"description";s:57:"Aggregates syndicated content (RSS, RDF, and Atom feeds).";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/block/block.module',
  'name' => 'block',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:5:"Block";s:11:"description";s:62:"Controls the boxes that are displayed around the main content.";s:7:"package";s:15:"Core - required";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/blog/blog.module',
  'name' => 'blog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Blog";s:11:"description";s:69:"Enables keeping easily and regularly updated user web pages or blogs.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/blogapi/blogapi.module',
  'name' => 'blogapi',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"Blog API";s:11:"description";s:79:"Allows users to post content using applications that support XML-RPC blog APIs.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/book/book.module',
  'name' => 'book',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6000',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Book";s:11:"description";s:63:"Allows users to structure site pages in a hierarchy or outline.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/color/color.module',
  'name' => 'color',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:5:"Color";s:11:"description";s:61:"Allows the user to change the color scheme of certain themes.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/comment/comment.module',
  'name' => 'comment',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6005',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Comment";s:11:"description";s:57:"Allows users to comment on and discuss published content.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/contact/contact.module',
  'name' => 'contact',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Contact";s:11:"description";s:61:"Enables the use of both personal and site-wide contact forms.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/dblog/dblog.module',
  'name' => 'dblog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:16:"Database logging";s:11:"description";s:47:"Logs and records system events to the database.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/filter/filter.module',
  'name' => 'filter',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"Filter";s:11:"description";s:60:"Handles the filtering of content in preparation for display.";s:7:"package";s:15:"Core - required";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/forum/forum.module',
  'name' => 'forum',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6000',
  'weight' => '1',
  'info' => 'a:10:{s:4:"name";s:5:"Forum";s:11:"description";s:50:"Enables threaded discussions about general topics.";s:12:"dependencies";a:2:{i:0;s:8:"taxonomy";i:1;s:7:"comment";}s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/help/help.module',
  'name' => 'help',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Help";s:11:"description";s:35:"Manages the display of online help.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/locale/locale.module',
  'name' => 'locale',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6007',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"Locale";s:11:"description";s:119:"Adds language handling functionality and enables the translation of the user interface to languages other than English.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/menu/menu.module',
  'name' => 'menu',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6000',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Menu";s:11:"description";s:60:"Allows administrators to customize the site navigation menu.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/node/node.module',
  'name' => 'node',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Node";s:11:"description";s:66:"Allows content to be submitted to the site and displayed on pages.";s:7:"package";s:15:"Core - required";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/openid/openid.module',
  'name' => 'openid',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"OpenID";s:11:"description";s:48:"Allows users to log into your site using OpenID.";s:7:"version";s:4:"6.38";s:7:"package";s:15:"Core - optional";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/path/path.module',
  'name' => 'path',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Path";s:11:"description";s:28:"Allows users to rename URLs.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/ping/ping.module',
  'name' => 'ping',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Ping";s:11:"description";s:51:"Alerts other sites when your site has been updated.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/poll/poll.module',
  'name' => 'poll',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Poll";s:11:"description";s:95:"Allows your site to capture votes on different topics in the form of multiple choice questions.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/profile/profile.module',
  'name' => 'profile',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Profile";s:11:"description";s:36:"Supports configurable user profiles.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/search/search.module',
  'name' => 'search',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"Search";s:11:"description";s:36:"Enables site-wide keyword searching.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/statistics/statistics.module',
  'name' => 'statistics',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '1',
  'schema_version' => '6000',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Statistics";s:11:"description";s:37:"Logs access statistics for your site.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/syslog/syslog.module',
  'name' => 'syslog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"Syslog";s:11:"description";s:41:"Logs and records system events to syslog.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/system/system.module',
  'name' => 'system',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6056',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"System";s:11:"description";s:54:"Handles general site configuration for administrators.";s:7:"package";s:15:"Core - required";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/taxonomy/taxonomy.module',
  'name' => 'taxonomy',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"Taxonomy";s:11:"description";s:38:"Enables the categorization of content.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/throttle/throttle.module',
  'name' => 'throttle',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"Throttle";s:11:"description";s:66:"Handles the auto-throttling mechanism, to control site congestion.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/tracker/tracker.module',
  'name' => 'tracker',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Tracker";s:11:"description";s:43:"Enables tracking of recent posts for users.";s:12:"dependencies";a:1:{i:0;s:7:"comment";}s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/translation/translation.module',
  'name' => 'translation',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:19:"Content translation";s:11:"description";s:57:"Allows content to be translated into different languages.";s:12:"dependencies";a:1:{i:0;s:6:"locale";}s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/trigger/trigger.module',
  'name' => 'trigger',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Trigger";s:11:"description";s:90:"Enables actions to be fired on certain system events, such as when new content is created.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/update/update.module',
  'name' => 'update',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:13:"Update status";s:11:"description";s:88:"Checks the status of available updates for Drupal and your installed modules and themes.";s:7:"version";s:4:"6.38";s:7:"package";s:15:"Core - optional";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/upload/upload.module',
  'name' => 'upload',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6000',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"Upload";s:11:"description";s:51:"Allows users to upload and attach files to content.";s:7:"package";s:15:"Core - optional";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'modules/user/user.module',
  'name' => 'user',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"User";s:11:"description";s:47:"Manages the user registration and login system.";s:7:"package";s:15:"Core - required";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/cck/content.module',
  'name' => 'content',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6010',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Content";s:11:"description";s:50:"Allows administrators to define new content types.";s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/cck/modules/content_copy/content_copy.module',
  'name' => 'content_copy',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:12:"Content Copy";s:11:"description";s:51:"Enables ability to import/export field definitions.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/cck/modules/content_multigroup/content_multigroup.module',
  'name' => 'content_multigroup',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:18:"Content Multigroup";s:11:"description";s:81:"Combine multiple CCK fields into repeating field collections that work in unison.";s:12:"dependencies";a:2:{i:0;s:7:"content";i:1;s:10:"fieldgroup";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:20:"6.x-3.0-alpha4+0-dev";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1435195093";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/cck/modules/content_permissions/content_permissions.module',
  'name' => 'content_permissions',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:19:"Content Permissions";s:11:"description";s:43:"Set field-level permissions for CCK fields.";s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/cck/modules/fieldgroup/fieldgroup.module',
  'name' => 'fieldgroup',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Fieldgroup";s:11:"description";s:37:"Create display groups for CCK fields.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/cck/modules/nodereference/nodereference.module',
  'name' => 'nodereference',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"Node Reference";s:11:"description";s:59:"Defines a field type for referencing one node from another.";s:12:"dependencies";a:3:{i:0;s:7:"content";i:1;s:4:"text";i:2;s:13:"optionwidgets";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/cck/modules/number/number.module',
  'name' => 'number',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6000',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"Number";s:11:"description";s:28:"Defines numeric field types.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/cck/modules/optionwidgets/optionwidgets.module',
  'name' => 'optionwidgets',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"Option Widgets";s:11:"description";s:82:"Defines selection, check box and radio button widgets for text and numeric fields.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/cck/modules/text/text.module',
  'name' => 'text',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6003',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Text";s:11:"description";s:32:"Defines simple text field types.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/cck/modules/userreference/userreference.module',
  'name' => 'userreference',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6002',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"User Reference";s:11:"description";s:56:"Defines a field type for referencing a user from a node.";s:12:"dependencies";a:3:{i:0;s:7:"content";i:1;s:4:"text";i:2;s:13:"optionwidgets";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:8:"6.x-2.10";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1434568159";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/cck/tests/content_test.module',
  'name' => 'content_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:12:"Content Test";s:11:"description";s:20:"Test module for CCK.";s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:12:"dependencies";a:1:{i:0;s:6:"schema";}s:6:"hidden";b:1;s:5:"files";a:1:{i:0;s:19:"content_test.module";}s:7:"version";s:20:"6.x-3.0-alpha4+0-dev";s:7:"project";s:3:"cck";s:9:"datestamp";s:10:"1435195093";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/date/date/date.module',
  'name' => 'date',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6005',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Date";s:11:"description";s:41:"Defines CCK date/time fields and widgets.";s:12:"dependencies";a:3:{i:0;s:7:"content";i:1;s:8:"date_api";i:2;s:13:"date_timezone";}s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-2.8";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1326285938";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/date/date_api.module',
  'name' => 'date_api',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6006',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"Date API";s:11:"description";s:45:"A Date API that can be used by other modules.";s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-2.8";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1326285938";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/date/date_locale/date_locale.module',
  'name' => 'date_locale',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:11:"Date Locale";s:11:"description";s:124:"Allows the site admin to configure multiple formats for date/time display to tailor dates for a specific locale or audience.";s:7:"package";s:9:"Date/Time";s:12:"dependencies";a:2:{i:0;s:8:"date_api";i:1;s:6:"locale";}s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-2.8";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1326285938";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/date/date_php4/date_php4.module',
  'name' => 'date_php4',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:9:"Date PHP4";s:11:"description";s:134:"Emulate PHP 5.2 date functions in PHP 4.x, PHP 5.0, and PHP 5.1. Required when using the Date API with PHP versions less than PHP 5.2.";s:7:"package";s:9:"Date/Time";s:12:"dependencies";a:1:{i:0;s:8:"date_api";}s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-2.8";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1326285938";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/date/date_popup/date_popup.module',
  'name' => 'date_popup',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Date Popup";s:11:"description";s:84:"Enables jquery popup calendars and time entry widgets for selecting dates and times.";s:12:"dependencies";a:2:{i:0;s:8:"date_api";i:1;s:13:"date_timezone";}s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-2.8";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1326285938";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/date/date_repeat/date_repeat.module',
  'name' => 'date_repeat',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:15:"Date Repeat API";s:11:"description";s:73:"A Date Repeat API to calculate repeating dates and times from iCal rules.";s:12:"dependencies";a:1:{i:0;s:8:"date_api";}s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-2.8";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1326285938";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/date/date_timezone/date_timezone.module',
  'name' => 'date_timezone',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '5200',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:13:"Date Timezone";s:11:"description";s:111:"Needed when using Date API. Overrides site and user timezone handling to set timezone names instead of offsets.";s:7:"package";s:9:"Date/Time";s:12:"dependencies";a:1:{i:0;s:8:"date_api";}s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-2.8";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1326285938";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/date/date_tools/date_tools.module',
  'name' => 'date_tools',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Date Tools";s:11:"description";s:52:"Tools to import and auto-create dates and calendars.";s:12:"dependencies";a:2:{i:0;s:7:"content";i:1;s:4:"date";}s:7:"package";s:9:"Date/Time";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-2.8";s:7:"project";s:4:"date";s:9:"datestamp";s:10:"1326285938";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/ddblock/ddblock.module',
  'name' => 'ddblock',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:7:{s:4:"name";s:21:"Dynamic display block";s:11:"description";s:36:"Displays dynamic content in a block.";s:4:"core";s:3:"6.x";s:12:"dependencies";a:1:{i:0;s:13:"jquery_update";}s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/email/email.module',
  'name' => 'email',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:5:"Email";s:11:"description";s:35:"Defines an email field type for cck";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-1.4";s:7:"project";s:5:"email";s:9:"datestamp";s:10:"1354093658";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/event/contrib/calendarsignup/calendarsignup.module',
  'name' => 'calendarsignup',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:15:"Calendar Signup";s:11:"description";s:44:"Add signup forms in an event.module calendar";s:7:"package";s:5:"Event";s:12:"dependencies";a:2:{i:0;s:5:"event";i:1;s:6:"signup";}s:4:"core";s:3:"6.x";s:7:"version";s:11:"6.x-2.x-dev";s:7:"project";s:5:"event";s:9:"datestamp";s:10:"1425082685";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/event/contrib/datepicker/datepicker.module',
  'name' => 'datepicker',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:11:"Date Picker";s:11:"description";s:40:"Add a date picker to event module forms.";s:7:"package";s:5:"Event";s:12:"dependencies";a:1:{i:0;s:5:"event";}s:4:"core";s:3:"6.x";s:7:"version";s:11:"6.x-2.x-dev";s:7:"project";s:5:"event";s:9:"datestamp";s:10:"1425082685";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/event/event.module',
  'name' => 'event',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6005',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:5:"Event";s:11:"description";s:44:"Calendaring API, calendar display and export";s:7:"package";s:5:"Event";s:4:"core";s:3:"6.x";s:7:"version";s:11:"6.x-2.x-dev";s:7:"project";s:5:"event";s:9:"datestamp";s:10:"1425082685";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/filefield/filefield.module',
  'name' => 'filefield',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6104',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:9:"FileField";s:11:"description";s:26:"Defines a file field type.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:3:"php";s:3:"5.0";s:7:"version";s:8:"6.x-3.14";s:7:"project";s:9:"filefield";s:9:"datestamp";s:10:"1456327142";s:10:"dependents";a:0:{}}',
])
->values([
  'filename' => 'sites/all/modules/filefield/filefield_meta/filefield_meta.module',
  'name' => 'filefield_meta',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"FileField Meta";s:11:"description";s:48:"Add metadata gathering and storage to FileField.";s:12:"dependencies";a:2:{i:0;s:9:"filefield";i:1;s:6:"getid3";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:3:"php";s:3:"5.0";s:7:"version";s:8:"6.x-3.14";s:7:"project";s:9:"filefield";s:9:"datestamp";s:10:"1456327142";s:10:"dependents";a:0:{}}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18n.module',
  'name' => 'i18n',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '1',
  'schema_version' => '9',
  'weight' => '10',
  'info' => 'a:10:{s:4:"name";s:20:"Internationalization";s:11:"description";s:49:"Extends Drupal support for multilingual features.";s:12:"dependencies";a:2:{i:0;s:6:"locale";i:1;s:11:"translation";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-1.4";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1270669810";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18nblocks/i18nblocks.module',
  'name' => 'i18nblocks',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:17:"Block translation";s:11:"description";s:50:"Enables multilingual blocks and block translation.";s:12:"dependencies";a:2:{i:0;s:4:"i18n";i:1;s:11:"i18nstrings";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-1.4";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1270669810";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18ncck/i18ncck.module',
  'name' => 'i18ncck',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:15:"CCK translation";s:11:"description";s:56:"Supports translatable custom CCK fields and fieldgroups.";s:12:"dependencies";a:3:{i:0;s:4:"i18n";i:1;s:7:"content";i:2;s:11:"i18nstrings";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-1.4";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1270669810";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18ncontent/i18ncontent.module',
  'name' => 'i18ncontent',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6002',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:24:"Content type translation";s:11:"description";s:99:"Add multilingual options for content and translate related strings: name, description, help text...";s:12:"dependencies";a:1:{i:0;s:11:"i18nstrings";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-1.4";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1270669810";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18nmenu/i18nmenu.module',
  'name' => 'i18nmenu',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:16:"Menu translation";s:11:"description";s:40:"Supports translatable custom menu items.";s:12:"dependencies";a:4:{i:0;s:4:"i18n";i:1;s:4:"menu";i:2;s:10:"i18nblocks";i:3;s:11:"i18nstrings";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-1.4";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1270669810";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18npoll/i18npoll.module',
  'name' => 'i18npoll',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"Poll aggregate";s:11:"description";s:45:"Aggregates poll results for all translations.";s:12:"dependencies";a:2:{i:0;s:11:"translation";i:1;s:4:"poll";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-1.4";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1270669810";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18nprofile/i18nprofile.module',
  'name' => 'i18nprofile',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '2',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:19:"Profile translation";s:11:"description";s:36:"Enables multilingual profile fields.";s:12:"dependencies";a:2:{i:0;s:7:"profile";i:1;s:11:"i18nstrings";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-1.4";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1270669810";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18nstrings/i18nstrings.module',
  'name' => 'i18nstrings',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6006',
  'weight' => '10',
  'info' => 'a:10:{s:4:"name";s:18:"String translation";s:11:"description";s:57:"Provides support for translation of user defined strings.";s:12:"dependencies";a:1:{i:0;s:6:"locale";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-1.4";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1270669810";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18nsync/i18nsync.module',
  'name' => 'i18nsync',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '100',
  'info' => 'a:10:{s:4:"name";s:24:"Synchronize translations";s:11:"description";s:74:"Synchronizes taxonomy and fields accross translations of the same content.";s:12:"dependencies";a:1:{i:0;s:4:"i18n";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-1.4";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1270669810";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18ntaxonomy/i18ntaxonomy.module',
  'name' => 'i18ntaxonomy',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6002',
  'weight' => '5',
  'info' => 'a:10:{s:4:"name";s:20:"Taxonomy translation";s:11:"description";s:30:"Enables multilingual taxonomy.";s:12:"dependencies";a:3:{i:0;s:4:"i18n";i:1;s:8:"taxonomy";i:2;s:11:"i18nstrings";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-1.4";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1270669810";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/i18n/i18nviews/i18nviews.module',
  'name' => 'i18nviews',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:17:"Views translation";s:11:"description";s:80:"Translation of views strings and content selection for views. Requires Views 3.x";s:12:"dependencies";a:3:{i:0;s:5:"views";i:1;s:11:"i18nstrings";i:2;s:12:"i18ntaxonomy";}s:7:"package";s:13:"Multilanguage";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-1.4";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1270669810";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/i18n/tests/i18n_test.module',
  'name' => 'i18n_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:26:"Internationalization tests";s:11:"description";s:55:"Helper module for testing i18n (do not enable manually)";s:12:"dependencies";a:3:{i:0;s:6:"locale";i:1;s:11:"translation";i:2;s:4:"i18n";}s:7:"package";s:5:"Devel";s:4:"core";s:3:"6.x";s:7:"version";s:7:"6.x-1.4";s:7:"project";s:4:"i18n";s:9:"datestamp";s:10:"1270669810";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/imageapi/imageapi.module',
  'name' => 'imageapi',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"ImageAPI";s:11:"description";s:38:"ImageAPI supporting multiple toolkits.";s:7:"package";s:10:"ImageCache";s:4:"core";s:3:"6.x";s:3:"php";s:3:"5.1";s:7:"version";s:13:"6.x-1.9+4-dev";s:7:"project";s:8:"imageapi";s:9:"datestamp";s:10:"1380582658";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}}',
])
->values([
  'filename' => 'sites/all/modules/imageapi/imageapi_gd.module',
  'name' => 'imageapi_gd',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:10:{s:4:\"name\";s:12:\"ImageAPI GD2\";s:11:\"description\";s:49:\"Uses PHP's built-in GD2 image processing support.\";s:7:\"package\";s:10:\"ImageCache\";s:4:\"core\";s:3:\"6.x\";s:7:\"version\";s:13:\"6.x-1.9+4-dev\";s:7:\"project\";s:8:\"imageapi\";s:9:\"datestamp\";s:10:\"1380582658\";s:12:\"dependencies\";a:0:{}s:10:\"dependents\";a:0:{}s:3:\"php\";s:5:\"4.3.5\";}",
])
->values([
  'filename' => 'sites/all/modules/imageapi/imageapi_imagemagick.module',
  'name' => 'imageapi_imagemagick',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:20:"ImageAPI ImageMagick";s:11:"description";s:33:"Command Line ImageMagick support.";s:7:"package";s:10:"ImageCache";s:4:"core";s:3:"6.x";s:7:"version";s:13:"6.x-1.9+4-dev";s:7:"project";s:8:"imageapi";s:9:"datestamp";s:10:"1380582658";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/imagecache/imagecache.module',
  'name' => 'imagecache',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"ImageCache";s:11:"description";s:36:"Dynamic image manipulator and cache.";s:7:"package";s:10:"ImageCache";s:12:"dependencies";a:1:{i:0;s:8:"imageapi";}s:4:"core";s:3:"6.x";s:7:"version";s:18:"6.x-2.0-rc1+16-dev";s:7:"project";s:10:"imagecache";s:9:"datestamp";s:10:"1380582680";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/imagecache/imagecache_ui.module',
  'name' => 'imagecache_ui',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:13:"ImageCache UI";s:11:"description";s:26:"ImageCache User Interface.";s:12:"dependencies";a:2:{i:0;s:10:"imagecache";i:1;s:8:"imageapi";}s:7:"package";s:10:"ImageCache";s:4:"core";s:3:"6.x";s:7:"version";s:18:"6.x-2.0-rc1+16-dev";s:7:"project";s:10:"imagecache";s:9:"datestamp";s:10:"1380582680";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/imagefield/imagefield.module',
  'name' => 'imagefield',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6006',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"ImageField";s:11:"description";s:28:"Defines an image field type.";s:4:"core";s:3:"6.x";s:12:"dependencies";a:2:{i:0;s:7:"content";i:1;s:9:"filefield";}s:7:"package";s:3:"CCK";s:7:"version";s:7:"6.x-3.3";s:7:"project";s:10:"imagefield";s:9:"datestamp";s:10:"1273102211";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/link/link.module',
  'name' => 'link',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6002',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:4:"Link";s:11:"description";s:32:"Defines simple link field types.";s:12:"dependencies";a:1:{i:0;s:7:"content";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:5:"files";a:1:{i:0;s:16:"link.migrate.inc";}s:7:"version";s:8:"6.x-2.11";s:7:"project";s:4:"link";s:9:"datestamp";s:10:"1393559923";s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/nodereference_url/nodereference_url.module',
  'name' => 'nodereference_url',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '6100',
  'weight' => '0',
  'info' => 'a:8:{s:4:"name";s:25:"Node Reference URL Widget";s:11:"description";s:99:"Adds an additional widget to the CCK Node Reference field that prepopulates a reference by the URL.";s:12:"dependencies";a:1:{i:0;s:13:"nodereference";}s:7:"package";s:3:"CCK";s:4:"core";s:3:"6.x";s:10:"dependents";a:0:{}s:7:"version";N;s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'sites/all/modules/variable/variable.module',
  'name' => 'variable',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:12:"Variable API";s:11:"description";s:12:"Variable API";s:4:"core";s:3:"6.x";s:7:"version";s:11:"6.x-1.x-dev";s:7:"project";s:8:"variable";s:9:"datestamp";s:10:"1406295528";s:12:"dependencies";a:0:{}s:10:"dependents";a:0:{}s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'themes/bluemarine/bluemarine.info',
  'name' => 'bluemarine',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Bluemarine";s:11:"description";s:66:"Table-based multi-column theme with a marine and ash color scheme.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/bluemarine/script.js";}s:10:"screenshot";s:32:"themes/bluemarine/screenshot.png";s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'themes/chameleon/chameleon.info',
  'name' => 'chameleon',
  'type' => 'theme',
  'owner' => 'themes/chameleon/chameleon.theme',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:9:"Chameleon";s:11:"description";s:42:"Minimalist tabled theme with light colors.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:8:"features";a:4:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"scripts";a:1:{s:9:"script.js";s:26:"themes/chameleon/script.js";}s:10:"screenshot";s:31:"themes/chameleon/screenshot.png";s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'themes/chameleon/marvin/marvin.info',
  'name' => 'marvin',
  'type' => 'theme',
  'owner' => '',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:6:"Marvin";s:11:"description";s:31:"Boxy tabled theme in all grays.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"base theme";s:9:"chameleon";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/chameleon/marvin/script.js";}s:10:"screenshot";s:38:"themes/chameleon/marvin/screenshot.png";s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'themes/garland/garland.info',
  'name' => 'garland',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '1',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:7:"Garland";s:11:"description";s:66:"Tableless, recolorable, multi-column, fluid width theme (default).";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:24:"themes/garland/script.js";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"4.3.5";}',
])
->values([
  'filename' => 'themes/garland/minnelli/minnelli.info',
  'name' => 'minnelli',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:14:{s:4:"name";s:8:"Minnelli";s:11:"description";s:56:"Tableless, recolorable, multi-column, fixed width theme.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"base theme";s:7:"garland";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/garland/minnelli/script.js";}s:10:"screenshot";s:38:"themes/garland/minnelli/screenshot.png";s:3:"php";s:5:"4.3.5";s:6:"engine";s:11:"phptemplate";}',
])
->values([
  'filename' => 'themes/pushbutton/pushbutton.info',
  'name' => 'pushbutton',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'throttle' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:13:{s:4:"name";s:10:"Pushbutton";s:11:"description";s:52:"Tabled, multi-column theme in blue and orange tones.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/pushbutton/script.js";}s:10:"screenshot";s:32:"themes/pushbutton/screenshot.png";s:3:"php";s:5:"4.3.5";}',
])
->execute();
$connection->schema()->createTable('term_data', [
  'fields' => [
    'tid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'description' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
    'trid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'tid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('term_hierarchy', [
  'fields' => [
    'tid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'parent' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'tid',
    'parent',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('term_node', [
  'fields' => [
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'tid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'vid',
    'tid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('term_relation', [
  'fields' => [
    'trid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'tid1' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'tid2' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'trid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('term_synonym', [
  'fields' => [
    'tsid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'tid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
  ],
  'primary key' => [
    'tsid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('upload', [
  'fields' => [
    'fid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'nid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'description' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'list' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'fid',
    'vid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('upload')
->fields([
  'fid',
  'nid',
  'vid',
  'description',
  'list',
  'weight',
])
->values([
  'fid' => '1',
  'nid' => '1',
  'vid' => '1',
  'description' => 'file 1-1-1',
  'list' => '0',
  'weight' => '-1',
])
->values([
  'fid' => '1',
  'nid' => '1',
  'vid' => '5',
  'description' => 'file 1-1-1',
  'list' => '0',
  'weight' => '-1',
])
->values([
  'fid' => '1',
  'nid' => '1',
  'vid' => '2001',
  'description' => 'file 1-1-1',
  'list' => '0',
  'weight' => '-1',
])
->values([
  'fid' => '2',
  'nid' => '1',
  'vid' => '2',
  'description' => 'file 1-2-2',
  'list' => '1',
  'weight' => '4',
])
->values([
  'fid' => '2',
  'nid' => '2',
  'vid' => '3',
  'description' => 'file 2-3-2',
  'list' => '1',
  'weight' => '2',
])
->values([
  'fid' => '3',
  'nid' => '1',
  'vid' => '2',
  'description' => 'file 1-2-3',
  'list' => '0',
  'weight' => '3',
])
->values([
  'fid' => '3',
  'nid' => '2',
  'vid' => '3',
  'description' => 'file 2-3-3',
  'list' => '0',
  'weight' => '1',
])
->values([
  'fid' => '3',
  'nid' => '12',
  'vid' => '15',
  'description' => 'file 12-15-3',
  'list' => '0',
  'weight' => '0',
])
->execute();
$connection->schema()->createTable('url_alias', [
  'fields' => [
    'pid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'src' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'dst' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
  ],
  'primary key' => [
    'pid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('users', [
  'fields' => [
    'uid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '60',
      'default' => '',
    ],
    'pass' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'mail' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '64',
      'default' => '',
    ],
    'mode' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'sort' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'default' => '0',
    ],
    'threshold' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'default' => '0',
    ],
    'theme' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'signature' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'signature_format' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'created' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'access' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'login' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'timezone' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '8',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
    'picture' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'init' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '64',
      'default' => '',
    ],
    'data' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'timezone_name' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '50',
      'default' => '',
    ],
    'pass_plain' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'expected_timezone' => [
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '50',
    ],
    'timezone_id' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'uid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('users')
->fields([
  'uid',
  'name',
  'pass',
  'mail',
  'mode',
  'sort',
  'threshold',
  'theme',
  'signature',
  'signature_format',
  'created',
  'access',
  'login',
  'status',
  'timezone',
  'language',
  'picture',
  'init',
  'data',
  'timezone_name',
  'pass_plain',
  'expected_timezone',
  'timezone_id',
])
->values([
  'uid' => '1',
  'name' => 'root',
  'pass' => '63a9f0ea7bb98050796b649e85481845',
  'mail' => 'root@localhost',
  'mode' => '0',
  'sort' => '0',
  'threshold' => '0',
  'theme' => '',
  'signature' => '',
  'signature_format' => '0',
  'created' => '0',
  'access' => '1543973668',
  'login' => '1543973668',
  'status' => '1',
  'timezone' => NULL,
  'language' => '',
  'picture' => '',
  'init' => 'root@localhost',
  'data' => 'b:0;',
  'timezone_name' => '',
  'pass_plain' => 'root',
  'expected_timezone' => NULL,
  'timezone_id' => '0',
])
->execute();
$connection->schema()->createTable('users_roles', [
  'fields' => [
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'rid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
  ],
  'primary key' => [
    'uid',
    'rid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('users_roles')
->fields([
  'uid',
  'rid',
])
->values([
  'uid' => '2',
  'rid' => '3',
])
->execute();
$connection->schema()->createTable('variable', [
  'fields' => [
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'value' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
  ],
  'primary key' => [
    'name',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('variable')
->fields([
  'name',
  'value',
])
->values([
  'name' => 'actions_max_stack',
  'value' => 'i:35;',
])
->values([
  'name' => 'admin_compact_mode',
  'value' => 'b:0;',
])
->values([
  'name' => 'aggregator_allowed_html_tags',
  'value' => 's:70:"<a> <b> <br /> <dd> <dl> <dt> <em> <i> <li> <ol> <p> <strong> <u> <ul>";',
])
->values([
  'name' => 'aggregator_clear',
  'value' => 's:7:"9676800";',
])
->values([
  'name' => 'aggregator_fetcher',
  'value' => 's:10:"aggregator";',
])
->values([
  'name' => 'aggregator_parser',
  'value' => 's:10:"aggregator";',
])
->values([
  'name' => 'aggregator_processors',
  'value' => 'a:1:{i:0;s:10:"aggregator";}',
])
->values([
  'name' => 'aggregator_summary_items',
  'value' => 's:1:"3";',
])
->values([
  'name' => 'aggregator_teaser_length',
  'value' => 's:3:"600";',
])
->values([
  'name' => 'allowed_html_1',
  'value' => 's:61:"<a> <em> <strong> <cite> <code> <ul> <ol> <li> <dl> <dt> <dd>";',
])
->values([
  'name' => 'allow_insecure_uploads',
  'value' => 'i:1;',
])
->values([
  'name' => 'anonymous',
  'value' => 's:5:"Guest";',
])
->values([
  'name' => 'array_filter',
  'value' => 'b:1;',
])
->values([
  'name' => 'cache_lifetime',
  'value' => 'i:0;',
])
->values([
  'name' => 'configurable_timezones',
  'value' => 's:1:"0";',
])
->values([
  'name' => 'contact_default_status',
  'value' => 'i:1;',
])
->values([
  'name' => 'contact_hourly_threshold',
  'value' => 'i:3;',
])
->values([
  'name' => 'content_extra_weights_employee',
  'value' => 'a:11:{s:5:"title";s:2:"-5";s:10:"body_field";s:1:"0";s:20:"revision_information";s:2:"20";s:6:"author";s:2:"20";s:7:"options";s:2:"25";s:16:"comment_settings";s:2:"30";s:8:"language";s:1:"0";s:11:"translation";s:2:"30";s:4:"menu";s:2:"-2";s:4:"book";s:2:"10";s:4:"path";s:2:"30";}',
])
->values([
  'name' => 'content_extra_weights_story',
  'value' => 'a:9:{s:5:"title";s:2:"-5";s:10:"body_field";s:2:"-2";s:20:"revision_information";s:2:"19";s:6:"author";s:2:"18";s:7:"options";s:2:"20";s:16:"comment_settings";s:2:"22";s:4:"menu";s:2:"-3";s:8:"taxonomy";s:2:"-4";s:11:"attachments";s:2:"21";}',
])
->values([
  'name' => 'content_extra_weights_test_page',
  'value' => 'a:8:{s:5:"title";s:2:"37";s:10:"body_field";s:2:"38";s:20:"revision_information";s:2:"40";s:6:"author";s:2:"39";s:7:"options";s:2:"41";s:16:"comment_settings";s:2:"42";s:4:"menu";s:2:"36";s:11:"attachments";s:2:"43";}',
])
->values([
  'name' => 'content_schema_version',
  'value' => 'i:6009;',
])
->values([
  'name' => 'cron_threshold_error',
  'value' => 'i:1209600;',
])
->values([
  'name' => 'cron_threshold_warning',
  'value' => 'i:172800;',
])
->values([
  'name' => 'css_js_query_string',
  'value' => 's:20:"y8SAkMTxRZndiw700000";',
])
->values([
  'name' => 'date:story:4:field_test_datestamp_fromto',
  'value' => 's:4:"both";',
])
->values([
  'name' => 'date:story:4:field_test_datestamp_multiple_from',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:4:field_test_datestamp_multiple_number',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:4:field_test_datestamp_multiple_to',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:4:field_test_datestamp_show_repeat_rule',
  'value' => 's:4:"show";',
])
->values([
  'name' => 'date:story:4:field_test_datetime_fromto',
  'value' => 's:4:"both";',
])
->values([
  'name' => 'date:story:4:field_test_datetime_multiple_from',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:4:field_test_datetime_multiple_number',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:4:field_test_datetime_multiple_to',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:4:field_test_datetime_show_repeat_rule',
  'value' => 's:4:"show";',
])
->values([
  'name' => 'date:story:4:field_test_date_fromto',
  'value' => 's:4:"both";',
])
->values([
  'name' => 'date:story:4:field_test_date_multiple_from',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:4:field_test_date_multiple_number',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:4:field_test_date_multiple_to',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:4:field_test_date_show_repeat_rule',
  'value' => 's:4:"show";',
])
->values([
  'name' => 'date:story:5:field_test_datestamp_fromto',
  'value' => 's:4:"both";',
])
->values([
  'name' => 'date:story:5:field_test_datestamp_multiple_from',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:5:field_test_datestamp_multiple_number',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:5:field_test_datestamp_multiple_to',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:5:field_test_datestamp_show_repeat_rule',
  'value' => 's:4:"show";',
])
->values([
  'name' => 'date:story:5:field_test_datetime_fromto',
  'value' => 's:4:"both";',
])
->values([
  'name' => 'date:story:5:field_test_datetime_multiple_from',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:5:field_test_datetime_multiple_number',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:5:field_test_datetime_multiple_to',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:5:field_test_datetime_show_repeat_rule',
  'value' => 's:4:"show";',
])
->values([
  'name' => 'date:story:5:field_test_date_fromto',
  'value' => 's:4:"both";',
])
->values([
  'name' => 'date:story:5:field_test_date_multiple_from',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:5:field_test_date_multiple_number',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:5:field_test_date_multiple_to',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:5:field_test_date_show_repeat_rule',
  'value' => 's:4:"show";',
])
->values([
  'name' => 'date:story:full:field_test_datestamp_fromto',
  'value' => 's:4:"both";',
])
->values([
  'name' => 'date:story:full:field_test_datestamp_multiple_from',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:full:field_test_datestamp_multiple_number',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:full:field_test_datestamp_multiple_to',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:full:field_test_datestamp_show_repeat_rule',
  'value' => 's:4:"show";',
])
->values([
  'name' => 'date:story:full:field_test_datetime_fromto',
  'value' => 's:4:"both";',
])
->values([
  'name' => 'date:story:full:field_test_datetime_multiple_from',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:full:field_test_datetime_multiple_number',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:full:field_test_datetime_multiple_to',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:full:field_test_datetime_show_repeat_rule',
  'value' => 's:4:"show";',
])
->values([
  'name' => 'date:story:full:field_test_date_fromto',
  'value' => 's:4:"both";',
])
->values([
  'name' => 'date:story:full:field_test_date_multiple_from',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:full:field_test_date_multiple_number',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:full:field_test_date_multiple_to',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:full:field_test_date_show_repeat_rule',
  'value' => 's:4:"show";',
])
->values([
  'name' => 'date:story:teaser:field_test_datestamp_fromto',
  'value' => 's:4:"both";',
])
->values([
  'name' => 'date:story:teaser:field_test_datestamp_multiple_from',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:teaser:field_test_datestamp_multiple_number',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:teaser:field_test_datestamp_multiple_to',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:teaser:field_test_datestamp_show_repeat_rule',
  'value' => 's:4:"show";',
])
->values([
  'name' => 'date:story:teaser:field_test_datetime_fromto',
  'value' => 's:4:"both";',
])
->values([
  'name' => 'date:story:teaser:field_test_datetime_multiple_from',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:teaser:field_test_datetime_multiple_number',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:teaser:field_test_datetime_multiple_to',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:teaser:field_test_datetime_show_repeat_rule',
  'value' => 's:4:"show";',
])
->values([
  'name' => 'date:story:teaser:field_test_date_fromto',
  'value' => 's:4:"both";',
])
->values([
  'name' => 'date:story:teaser:field_test_date_multiple_from',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:teaser:field_test_date_multiple_number',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:teaser:field_test_date_multiple_to',
  'value' => 's:0:"";',
])
->values([
  'name' => 'date:story:teaser:field_test_date_show_repeat_rule',
  'value' => 's:4:"show";',
])
->values([
  'name' => 'date_api_version',
  'value' => 's:3:"5.2";',
])
->values([
  'name' => 'date_default_timezone',
  'value' => 's:4:"3600";',
])
->values([
  'name' => 'date_first_day',
  'value' => 's:1:"4";',
])
->values([
  'name' => 'date_format_long',
  'value' => 's:24:"\L\O\N\G l, F j, Y - H:i";',
])
->values([
  'name' => 'date_format_medium',
  'value' => 's:27:"\M\E\D\I\U\M D, m/d/Y - H:i";',
])
->values([
  'name' => 'date_format_short',
  'value' => 's:22:"\S\H\O\R\T m/d/Y - H:i";',
])
->values([
  'name' => 'dblog_row_limit',
  'value' => 'i:10000;',
])
->values([
  'name' => 'drupal_badge_color',
  'value' => 's:12:"powered-blue";',
])
->values([
  'name' => 'drupal_badge_size',
  'value' => 's:5:"80x15";',
])
->values([
  'name' => 'drupal_http_request_fails',
  'value' => 'b:0;',
])
->values([
  'name' => 'drupal_private_key',
  'value' => 's:43:"6bTz0JLHTM1R1c7VtbZtbio47JygBoNuGuzS5G0JYWs";',
])
->values([
  'name' => 'error_level',
  'value' => 'i:1;',
])
->values([
  'name' => 'event_nodeapi_article',
  'value' => 's:5:"never";',
])
->values([
  'name' => 'event_nodeapi_company',
  'value' => 's:5:"never";',
])
->values([
  'name' => 'event_nodeapi_employee',
  'value' => 's:5:"never";',
])
->values([
  'name' => 'event_nodeapi_event',
  'value' => 's:3:"all";',
])
->values([
  'name' => 'event_nodeapi_sponsor',
  'value' => 's:5:"never";',
])
->values([
  'name' => 'event_timezone_display',
  'value' => 's:5:"event";',
])
->values([
  'name' => 'feed_default_items',
  'value' => 'i:10;',
])
->values([
  'name' => 'feed_item_length',
  'value' => 's:5:"title";',
])
->values([
  'name' => 'file_description_length',
  'value' => 'i:128;',
])
->values([
  'name' => 'file_description_type',
  'value' => 's:9:"textfield";',
])
->values([
  'name' => 'file_directory_path',
  'value' => 's:25:"core/tests/fixtures/files";',
])
->values([
  'name' => 'file_directory_temp',
  'value' => 's:10:"files/temp";',
])
->values([
  'name' => 'file_downloads',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'file_icon_directory',
  'value' => 's:25:"sites/default/files/icons";',
])
->values([
  'name' => 'filter_allowed_protocols',
  'value' => 'a:13:{i:0;s:4:"http";i:1;s:5:"https";i:2;s:3:"ftp";i:3;s:4:"news";i:4;s:4:"nntp";i:5;s:3:"tel";i:6;s:6:"telnet";i:7;s:6:"mailto";i:8;s:3:"irc";i:9;s:3:"ssh";i:10;s:4:"sftp";i:11;s:6:"webcal";i:12;s:4:"rtsp";}',
])
->values([
  'name' => 'filter_html_1',
  'value' => 'i:1;',
])
->values([
  'name' => 'filter_html_help_1',
  'value' => 'i:1;',
])
->values([
  'name' => 'filter_html_nofollow_1',
  'value' => 'i:0;',
])
->values([
  'name' => 'filter_url_length_1',
  'value' => 's:2:"72";',
])
->values([
  'name' => 'form_build_id_article',
  'value' => 's:48:"form-t2zKJflpBD4rpYoGQH33ckjjWAYdo5lF3Hl1O_YnWyE";',
])
->values([
  'name' => 'form_build_id_company',
  'value' => 's:48:"form-jFw2agRukPxjG5dG-N6joZLyoxXmCoxTzua0HUciqK0";',
])
->values([
  'name' => 'form_build_id_employee',
  'value' => 's:48:"form-q42bJnZxCCHxcx5FjxjEOd8OaEAg9wnK8nX1hBjtT4M";',
])
->values([
  'name' => 'form_build_id_sponsor',
  'value' => 's:48:"form-1iWzOEGgEeoeGb7ywYWz4iUNal77IHPDVwqYj-a7ezQ";',
])
->values([
  'name' => 'i18nstrings_allowed_formats',
  'value' => 'a:2:{i:0;i:1;i:1;i:2;}',
])
->values([
  'name' => 'i18nsync_nodeapi_employee',
  'value' => 'a:1:{i:0;s:10:"field_sync";}',
])
->values([
  'name' => 'i18ntaxonomy_vocabulary',
  'value' => 'a:4:{i:1;s:1:"3";i:2;s:1:"2";i:3;s:1:"3";i:5;s:1:"1";}',
])
->values([
  'name' => 'i18n_lock_node_article',
  'value' => 'i:1;',
])
->values([
  'name' => 'i18n_lock_node_employee',
  'value' => 'i:0;',
])
->values([
  'name' => 'i18n_lock_node_sponsor',
  'value' => 'i:0;',
])
->values([
  'name' => 'i18n_newnode_current_employee',
  'value' => 'i:0;',
])
->values([
  'name' => 'i18n_newnode_current_sponsor',
  'value' => 'i:0;',
])
->values([
  'name' => 'i18n_node_employee',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'i18n_node_sponsor',
  'value' => 'i:1;',
])
->values([
  'name' => 'i18n_required_node_employee',
  'value' => 'i:0;',
])
->values([
  'name' => 'i18n_required_node_sponsor',
  'value' => 'i:0;',
])
->values([
  'name' => 'image_jpeg_quality',
  'value' => 'i:75;',
])
->values([
  'name' => 'image_toolkit',
  'value' => 's:2:"gd";',
])
->values([
  'name' => 'javascript_parsed',
  'value' => 'a:16:{i:0;s:14:"misc/jquery.js";i:1;s:14:"misc/drupal.js";i:2;s:19:"misc/tableheader.js";s:10:"refresh:fr";s:7:"waiting";s:10:"refresh:zu";s:7:"waiting";i:3;s:17:"misc/tabledrag.js";i:4;s:32:"sites/all/modules/cck/content.js";i:5;s:16:"misc/textarea.js";i:6;s:16:"misc/collapse.js";i:7;s:12:"misc/form.js";i:8;s:19:"misc/tableselect.js";i:9;s:20:"modules/user/user.js";i:10;s:20:"misc/autocomplete.js";i:11;s:19:"misc/jquery.form.js";i:12;s:12:"misc/ahah.js";i:13;s:14:"misc/teaser.js";}',
])
->values([
  'name' => 'language_content_type_article',
  'value' => 's:1:"2";',
])
->values([
  'name' => 'language_content_type_employee',
  'value' => 's:1:"2";',
])
->values([
  'name' => 'language_content_type_sponsor',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'language_count',
  'value' => 'i:11;',
])
->values([
  'name' => 'language_default',
  'value' => 'O:8:"stdClass":11:{s:8:"language";s:2:"en";s:4:"name";s:7:"English";s:6:"native";s:7:"English";s:9:"direction";s:1:"0";s:7:"enabled";i:1;s:7:"plurals";s:1:"0";s:7:"formula";s:0:"";s:6:"domain";s:0:"";s:6:"prefix";s:0:"";s:6:"weight";s:1:"0";s:10:"javascript";s:0:"";}',
])
->values([
  'name' => 'language_negotiation',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'locale_cache_strings',
  'value' => 'i:1;',
])
->values([
  'name' => 'locale_js_directory',
  'value' => 's:9:"languages";',
])
->values([
  'name' => 'menu_default_node_menu',
  'value' => 's:10:"navigation";',
])
->values([
  'name' => 'menu_expanded',
  'value' => 'a:1:{i:0;s:15:"secondary-links";}',
])
->values([
  'name' => 'menu_masks',
  'value' => 'a:22:{i:0;i:127;i:1;i:63;i:2;i:62;i:3;i:61;i:4;i:59;i:5;i:31;i:6;i:30;i:7;i:29;i:8;i:24;i:9;i:21;i:10;i:15;i:11;i:14;i:12;i:13;i:13;i:12;i:14;i:11;i:15;i:7;i:16;i:6;i:17;i:5;i:18;i:4;i:19;i:3;i:20;i:2;i:21;i:1;}',
])
->values([
  'name' => 'menu_override_parent_selector',
  'value' => 'b:0;',
])
->values([
  'name' => 'minimum_word_size',
  'value' => 's:1:"3";',
])
->values([
  'name' => 'node_admin_theme',
  'value' => 'i:0;',
])
->values([
  'name' => 'node_options_article',
  'value' => 'a:1:{i:0;s:7:"promote";}',
])
->values([
  'name' => 'node_options_book',
  'value' => 'a:1:{i:0;s:6:"status";}',
])
->values([
  'name' => 'node_options_company',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
])
->values([
  'name' => 'node_options_employee',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
])
->values([
  'name' => 'node_options_sponsor',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
])
->values([
  'name' => 'node_options_test_event',
  'value' => 'a:2:{i:0;s:6:"sticky";i:1;s:8:"revision";}',
])
->values([
  'name' => 'node_options_test_page',
  'value' => 'a:3:{i:0;s:6:"status";i:1;s:7:"promote";i:2;s:6:"sticky";}',
])
->values([
  'name' => 'node_options_test_planet',
  'value' => 'a:2:{i:0;s:6:"sticky";i:1;s:8:"revision";}',
])
->values([
  'name' => 'node_options_test_story',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
])
->values([
  'name' => 'node_preview',
  'value' => 'i:0;',
])
->values([
  'name' => 'node_rank_comments',
  'value' => 's:1:"5";',
])
->values([
  'name' => 'node_rank_promote',
  'value' => 's:1:"0";',
])
->values([
  'name' => 'node_rank_recent',
  'value' => 's:1:"0";',
])
->values([
  'name' => 'node_rank_relevance',
  'value' => 's:1:"2";',
])
->values([
  'name' => 'node_rank_sticky',
  'value' => 's:1:"8";',
])
->values([
  'name' => 'node_rank_views',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'overlap_cjk',
  'value' => 'i:1;',
])
->values([
  'name' => 'page_compression',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'preprocess_css',
  'value' => 'i:0;',
])
->values([
  'name' => 'preprocess_js',
  'value' => 'i:0;',
])
->values([
  'name' => 'search_cron_limit',
  'value' => 's:3:"100";',
])
->values([
  'name' => 'simpletest_clear_results',
  'value' => 'b:1;',
])
->values([
  'name' => 'simpletest_httpauth_method',
  'value' => 'i:1;',
])
->values([
  'name' => 'simpletest_httpauth_password',
  'value' => 'N;',
])
->values([
  'name' => 'simpletest_httpauth_username',
  'value' => 'N;',
])
->values([
  'name' => 'simpletest_verbose',
  'value' => 'b:1;',
])
->values([
  'name' => 'site_403',
  'value' => 's:4:"user";',
])
->values([
  'name' => 'site_404',
  'value' => 's:14:"page-not-found";',
])
->values([
  'name' => 'site_frontpage',
  'value' => 's:4:"node";',
])
->values([
  'name' => 'site_mail',
  'value' => 's:21:"site_mail@example.com";',
])
->values([
  'name' => 'site_name',
  'value' => 's:9:"site_name";',
])
->values([
  'name' => 'site_offline',
  'value' => 'i:0;',
])
->values([
  'name' => 'site_offline_message',
  'value' => 's:94:"Drupal is currently under maintenance. We should be back shortly. Thank you for your patience.";',
])
->values([
  'name' => 'site_slogan',
  'value' => 's:13:"Migrate rocks";',
])
->values([
  'name' => 'statistics_block_top_all_num',
  'value' => 's:1:"8";',
])
->values([
  'name' => 'statistics_block_top_day_num',
  'value' => 's:1:"7";',
])
->values([
  'name' => 'statistics_block_top_last_num',
  'value' => 's:1:"9";',
])
->values([
  'name' => 'statistics_count_content_views',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'statistics_enable_access_log',
  'value' => 's:1:"0";',
])
->values([
  'name' => 'statistics_flush_accesslog_timer',
  'value' => 's:6:"259200";',
])
->values([
  'name' => 'syslog_facility',
  'value' => 'i:128;',
])
->values([
  'name' => 'syslog_identity',
  'value' => 's:6:"drupal";',
])
->values([
  'name' => 'taxonomy_override_selector',
  'value' => 'b:0;',
])
->values([
  'name' => 'taxonomy_terms_per_page_admin',
  'value' => 'i:100;',
])
->values([
  'name' => 'teaser_length',
  'value' => 'i:456;',
])
->values([
  'name' => 'theme_default',
  'value' => 's:7:"garland";',
])
->values([
  'name' => 'theme_settings',
  'value' => 'a:22:{s:11:"toggle_logo";i:1;s:11:"toggle_name";i:1;s:13:"toggle_slogan";i:0;s:14:"toggle_mission";i:1;s:24:"toggle_node_user_picture";i:0;s:27:"toggle_comment_user_picture";i:0;s:13:"toggle_search";i:0;s:14:"toggle_favicon";i:1;s:20:"toggle_primary_links";i:1;s:22:"toggle_secondary_links";i:1;s:21:"toggle_node_info_test";i:1;s:26:"toggle_node_info_something";i:1;s:12:"default_logo";i:1;s:9:"logo_path";s:0:"";s:11:"logo_upload";s:0:"";s:15:"default_favicon";i:1;s:12:"favicon_path";s:0:"";s:14:"favicon_upload";s:0:"";s:26:"toggle_node_info_test_page";i:1;s:27:"toggle_node_info_test_story";i:1;s:27:"toggle_node_info_test_event";i:1;s:28:"toggle_node_info_test_planet";i:1;}',
])
->values([
  'name' => 'update_check_frequency',
  'value' => 's:1:"7";',
])
->values([
  'name' => 'update_fetch_url',
  'value' => 's:41:"http://updates.drupal.org/release-history";',
])
->values([
  'name' => 'update_max_fetch_attempts',
  'value' => 'i:2;',
])
->values([
  'name' => 'update_notification_threshold',
  'value' => 's:3:"all";',
])
->values([
  'name' => 'update_notify_emails',
  'value' => 'a:0:{}',
])
->values([
  'name' => 'upload_article',
  'value' => 'b:0;',
])
->values([
  'name' => 'upload_company',
  'value' => 's:1:"1";',
])
->values([
  'name' => 'upload_employee',
  'value' => 'b:0;',
])
->values([
  'name' => 'upload_event',
  'value' => 'b:0;',
])
->values([
  'name' => 'upload_sponsor',
  'value' => 'b:0;',
])
->values([
  'name' => 'upload_story',
  'value' => 'b:1;',
])
->values([
  'name' => 'upload_test_event',
  'value' => 'b:0;',
])
->values([
  'name' => 'upload_test_page',
  'value' => 'b:0;',
])
->values([
  'name' => 'upload_test_planet',
  'value' => 'b:0;',
])
->values([
  'name' => 'upload_test_story',
  'value' => 'b:0;',
])
->values([
  'name' => 'user_block_max_list_count',
  'value' => 's:2:"10";',
])
->values([
  'name' => 'user_block_seconds_online',
  'value' => 's:3:"900";',
])
->values([
  'name' => 'user_block_whois_new_count',
  'value' => 's:1:"5";',
])
->values([
  'name' => 'user_email_verification',
  'value' => 'i:0;',
])
->values([
  'name' => 'user_mail_password_reset_body',
  'value' => "s:409:\"!username,\n\nA request to reset the password for your account has been made at !site.\n\nYou may now log in to !uri_brief by clicking on this link or copying and pasting it in your browser:\n\n!login_url\n\nThis is a one-time login, so it can be used only once. It expires after one day and nothing will happen if it's not used.\n\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\";",
])
->values([
  'name' => 'user_mail_password_reset_subject',
  'value' => 's:52:"Replacement login information for !username at !site";',
])
->values([
  'name' => 'user_mail_register_admin_created_body',
  'value' => "s:452:\"!username,\n\nA site administrator at !site has created an account for you. You may now log in to !login_uri using the following username and password:\n\nusername: !username\npassword: !password\n\nYou may also log in by clicking on this link or copying and pasting it in your browser:\n\n!login_url\n\nThis is a one-time login, so it can be used only once.\n\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\n\n\n--  !site team\";",
])
->values([
  'name' => 'user_mail_register_admin_created_subject',
  'value' => 's:52:"An administrator created an account for you at !site";',
])
->values([
  'name' => 'user_mail_register_no_approval_required_body',
  'value' => "s:426:\"!username,\n\nThank you for registering at !site. You may now log in to !login_uri using the following username and password:\n\nusername: !username\npassword: !password\n\nYou may also log in by clicking on this link or copying and pasting it in your browser:\n\n!login_url\n\nThis is a one-time login, so it can be used only once.\n\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\n\n\n--  !site team\";",
])
->values([
  'name' => 'user_mail_register_no_approval_required_subject',
  'value' => 's:38:"Account details for !username at !site";',
])
->values([
  'name' => 'user_mail_register_pending_approval_admin_body',
  'value' => 's:54:"!username has applied for an account.\r\n\r\n!edit_uri";',
])
->values([
  'name' => 'user_mail_register_pending_approval_admin_subject',
  'value' => 's:63:"Account details for !username at !site (pending admin approval)";',
])
->values([
  'name' => 'user_mail_register_pending_approval_body',
  'value' => "s:267:\"!username,\n\nThank you for registering at !site. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\n\n\n--  !site team\";",
])
->values([
  'name' => 'user_mail_register_pending_approval_subject',
  'value' => 's:63:"Account details for !username at !site (pending admin approval)";',
])
->values([
  'name' => 'user_mail_status_activated_body',
  'value' => "s:419:\"!username,\n\nYour account at !site has been activated.\n\nYou may now log in by clicking on this link or copying and pasting it in your browser:\n\n!login_url\n\nThis is a one-time login, so it can be used only once.\n\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\n\nOnce you have set your own password, you will be able to log in to !login_uri in the future using:\n\nusername: !username\n\";",
])
->values([
  'name' => 'user_mail_status_activated_notify',
  'value' => 'i:0;',
])
->values([
  'name' => 'user_mail_status_activated_subject',
  'value' => 's:49:"Account details for !username at !site (approved)";',
])
->values([
  'name' => 'user_mail_status_blocked_body',
  'value' => "s:51:\"!username,\n\nYour account on !site has been blocked.\";",
])
->values([
  'name' => 'user_mail_status_blocked_notify',
  'value' => 'i:1;',
])
->values([
  'name' => 'user_mail_status_blocked_subject',
  'value' => 's:48:"Account details for !username at !site (blocked)";',
])
->values([
  'name' => 'user_mail_status_canceled_body',
  'value' => 's:54:"!username,\n\nYour account on !site has been canceled.";',
])
->values([
  'name' => 'user_mail_status_canceled_subject',
  'value' => 's:49:"Account details for !username at !site (canceled)";',
])
->values([
  'name' => 'user_mail_status_deleted_body',
  'value' => "s:51:\"!username,\n\nYour account on !site has been deleted.\";",
])
->values([
  'name' => 'user_mail_status_deleted_subject',
  'value' => 's:48:"Account details for !username at !site (deleted)";',
])
->values([
  'name' => 'user_register',
  'value' => 'i:0;',
])
->values([
  'name' => 'user_signatures',
  'value' => 's:1:"1";',
])
->execute();
$connection->schema()->createTable('vocabulary', [
  'fields' => [
    'vid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'name' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'description' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'help' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'relations' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'hierarchy' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'multiple' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'required' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'tags' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'module' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'weight' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
  ],
  'primary key' => [
    'vid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('vocabulary_node_types', [
  'fields' => [
    'vid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
  ],
  'primary key' => [
    'vid',
    'type',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->schema()->createTable('watchdog', [
  'fields' => [
    'wid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '16',
      'default' => '',
    ],
    'message' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'variables' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'severity' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'link' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'location' => [
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ],
    'referer' => [
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ],
    'hostname' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ],
    'timestamp' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'wid',
  ],
  'mysql_character_set' => 'utf8mb3',
]);

// Reset the SQL mode.
if ($connection->databaseType() === 'mysql') {
  $connection->query("SET sql_mode = '$sql_mode'");
}
