<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->

- [Issue title](#issue-title)
- [Problem/Motivation](#problemmotivation)
- [How to reproduce](#how-to-reproduce)
- [Solution](#solution)
- [Minimum Requirements](#minimum-requirements)
- [Support](#support)
- [Documentation](#documentation)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

### Issue title

The issue title should comply with the following structure:

[ *ISSUE-GROUP* ] Short description

The *ISSUE-GROUP* should be one of:

* `command:name`
* `console`
* `helper`
* `standard`
* `template`
* `translation`
* `test`
* `docs`

### Problem/Motivation
A brief statement describing why the issue was filed.

**Details to include:**
- Why are we doing this? Above all, a summary should explain why a change is needed, in a few short sentences.

### How to reproduce
Include steps related how to reproduce. 

**Details to include:**
- Drupal version (you can obtain this by running `drupal site:status`).  
- Console version (you can obtain this by running `drupal --version`).
- Steps to reproduce
- Include screen-shot or video whenever necessary.

### Solution
A brief description of the proposed fix.

**Details to include:**
- A short summary of the approach proposed or used in the PR.
- Approaches that have been tried and ruled out.
- Links to relevant API documentation or other resources.
- Known workarounds.

### Minimum Requirements
This project requires Drupal 8.

### Support
**Do not open issue for support question, only features and bugs.** For question please visit our [DrupalConsole Gitter room](https://gitter.im/hechoendrupal/DrupalConsole).

### Documentation
There's been some amazing Drupal Community work done around DrupalConsole. Many of your questions can be answered in our [DrupalConsole Book](https://www.gitbook.com/book/hechoendrupal/drupal-console/details).

If you find documentation in this DrupalConsole Book inaccurate or missing, you can created a new issue at [DrupalConsole Book](https://github.com/hechoendrupal/drupal-console-book) repository.
