<?php

namespace Drupal\commerce_price\Resolver;

use Drupal\commerce\Context;
use Drupal\commerce\PurchasableEntityInterface;

/**
 * Defines the interface for price resolvers.
 *
 * Interface for services tagged as 'commerce_price.price_resolver'.
 */
interface PriceResolverInterface {

  /**
   * Resolves a price for the given purchasable entity.
   *
   * Use $context->getData('field_name', 'price') to get the name of the field
   * for which the price is being resolved (e.g "list_price", "price").
   *
   * @param \Drupal\commerce\PurchasableEntityInterface $entity
   *   The purchasable entity.
   * @param string $quantity
   *   The quantity.
   * @param \Drupal\commerce\Context $context
   *   The context.
   *
   * @return \Drupal\commerce_price\Price|null
   *   A price value object, if resolved. Otherwise NULL, indicating that the
   *   next resolver in the chain should be called.
   */
  public function resolve(PurchasableEntityInterface $entity, $quantity, Context $context);

}
