<?php

namespace Drupal\cms_content_sync\Plugin\rest\resource;

use Drupal\cms_content_sync\Controller\LoggerProxy;
use Drupal\rest\ModifiedResourceResponse;

/**
 *
 */
trait ContentSyncRestTrait {

  /**
   * @inheritDoc
   */
  public function respondWith(array $body, int $status, bool $serialize) {
    // Trace the current request => provide all related Content Sync logs to
    // the Sync Core for debugging, even if the request succeeds.
    $trace = 'true' === \Drupal::request()->query->get('trace');

    if ($trace || $status !== self::CODE_OK) {
      $body['log'] = LoggerProxy::$messages;
    }

    // Embed the actual status code in the response body so that it can go
    // past CDNs that filter out 5XX response bodies.
    // CDNs filter out 5XX to avoid spilling secrets and internal information
    // to visitors. But as we are providing a controlled response even for 5xx
    // status codes, we need to bypass the filter by responding with a 2xx
    // status code even on failure so that the information makes it to
    // the Sync Core.
    $force2xx = 'true' === \Drupal::request()->query->get('force2xx');
    if ($force2xx) {
      $body = [
        'responseBody' => $body,
        'statusCode' => $status,
      ];
      $status = self::CODE_OK;
    }

    $response = new ModifiedResourceResponse(
      $serialize ? NULL : $body,
      $status
    );

    if ($serialize) {
      $response->setContent(
        json_encode($body)
      );
    }

    return $response;
  }

}
