<?php

namespace Drupal\cms_content_sync\Plugin\Action;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Action\ActionBase;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\TempStore\PrivateTempStoreFactory;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Push the node with Content Sync.
 *
 * @Action(
 *   id = "node_cms_content_sync_export_action",
 *   label = @Translation("Push changes"),
 *   type = "node",
 *   confirm_form_route_name = "node.cms_content_sync_push_changes_confirm",
 *   requirements = {
 *     "_permission" = "publish cms content sync changes",
 *   }
 * )
 */
class PushChanges extends ActionBase implements ContainerFactoryPluginInterface
{
    /**
     * The tempstore object.
     *
     * @var \Drupal\Core\TempStore\SharedTempStore
     */
    protected $tempStore;

    /**
     * Constructs a new DeleteNode object.
     *
     * @param array                                          $configuration
     *                                                                           A configuration array containing information about the plugin instance
     * @param string                                         $plugin_id
     *                                                                           The plugin ID for the plugin instance
     * @param mixed                                          $plugin_definition
     *                                                                           The plugin implementation definition
     * @param \Drupal\Core\TempStore\PrivateTempStoreFactory $temp_store_factory
     *                                                                           The tempstore factory
     */
    public function __construct(array $configuration, $plugin_id, $plugin_definition, PrivateTempStoreFactory $temp_store_factory)
    {
        $this->tempStore = $temp_store_factory->get('node_cms_content_sync_push_changes_confirm');

        parent::__construct($configuration, $plugin_id, $plugin_definition);
    }

    /**
     * {@inheritdoc}
     */
    public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition)
    {
        return new static(
      $configuration,

      $plugin_id,
      $plugin_definition,
      $container->get('tempstore.private')
    );
    }

    /**
     * {@inheritdoc}
     */
    public function executeMultiple(array $entities)
    {
        $this->tempStore->set('nodes', $entities);
    }

    /**
     * {@inheritdoc}
     */
    public function execute($object = null)
    {
        $this->executeMultiple([$object]);
    }

    /**
     * {@inheritdoc}
     */
    public function access($object, AccountInterface $account = null, $return_as_object = false)
    {
        /** @var \Drupal\node\NodeInterface $object */
        $result = $object
            ->access('update', $account, true)
            ->andIf($object
            ->access('edit', $account, true))
            ->andIf(AccessResult::allowedIfHasPermission($account, 'publish cms content sync changes'));

        return $return_as_object ? $result : $result
            ->isAllowed();
    }
}
