<?php

namespace Drupal\cms_content_sync_views\Plugin\views\filter;

use Drupal\cms_content_sync\Entity\Flow;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\views\Plugin\views\filter\InOperator;

/**
 * Provides a view filter to filter on the sync state entity.
 *
 * @ingroup views_filter_handlers
 *
 * @ViewsFilter("cms_content_sync_entity_type_filter")
 */
class EntityType extends InOperator implements ContainerFactoryPluginInterface
{
    /**
     * {@inheritdoc}
     */
    public function getValueOptions()
    {
        if (!isset($this->valueOptions)) {
            $this->valueTitle = $this->t('Entity Type');

            $this->valueOptions = [];
            $flows = Flow::getAll();

            if (!empty($flows)) {
                foreach ($flows as $flow) {
                    foreach ($flow->getController()->getEntityTypeConfig(null, null, true) as $type_name => $bundles) {
                        foreach ($bundles as $config) {
                            if (isset($this->valueOptions[$type_name])) {
                                continue;
                            }

                            /**
                             * @var \Drupal\Core\Entity\EntityTypeManager $entityTypeManager
                             */
                            $entityTypeManager = \Drupal::service('entity_type.manager');
                            $type = $entityTypeManager->getDefinition($type_name);

                            $this->valueOptions[$type_name] = $type->getLabel();
                        }
                    }
                }

                return $this->valueOptions;
            }
        }

        return $this->valueOptions['none'] = $this->t('None');
    }
}
