<?php

/**
 * @file
 * Text Expectations.
 *
 * This file outlines test expectations for the node-with-recursive-deps.json
 * fixture.
 */

use Drupal\Tests\acquia_contenthub\Kernel\Stubs\CdfExpectations;

$data = [
  'uuid' => [
    'en' => [
      '0' => [
        'value' => "d1aee8f8-e868-496d-a8f7-5b9a8df2de7e",
      ],
    ],
    'ko' => [
      '0' => [
        'value' => "d1aee8f8-e868-496d-a8f7-5b9a8df2de7e",
      ],
    ],
  ],
  'langcode' => [
    'en' => [
      0 => [
        'value' => 'en',
      ],
    ],
    'ko' => [
      0 => [
        'value' => 'ko',
      ],
    ],
  ],
  'type' => [
    'en' => [
      '0' => [
        'target_id' => "5cb0868f-2004-4a10-be43-69fea1403c58",
      ],
    ],
    'ko' => [
      '0' => [
        'target_id' => "5cb0868f-2004-4a10-be43-69fea1403c58",
      ],
    ],
  ],
  'revision_timestamp' => [
    'en' => [
      '0' => [
        'value' => "1579198225",
      ],
    ],
    'ko' => [
      '0' => [
        'value' => "1579198225",
      ],
    ],
  ],
  'revision_uid' => [
    'en' => [
      '0' => [
        'target_id' => "3a56676e-97ee-486f-8692-40e1847950df",
      ],
    ],
    'ko' => [
      '0' => [
        'target_id' => "3a56676e-97ee-486f-8692-40e1847950df",
      ],
    ],
  ],
  'status' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
    'ko' => [
      '0' => [
        'value' => "1",
      ],
    ],
  ],
  'title' => [
    'en' => [
      '0' => [
        'value' => "Give it a go and grow your own herbs",
      ],
    ],
    'ko' => [
      '0' => [
        'value' => "Give it a go and grow your own herbs",
      ],
    ],
  ],
  'uid' => [
    'en' => [
      '0' => [
        'target_id' => "79b2f512-6e56-4fe0-94eb-67898d19f741",
      ],
    ],
    'ko' => [
      '0' => [
        'target_id' => "376a9b53-3c5e-485b-9bc7-288f940842bc",
      ],
    ],
  ],
  'created' => [
    'en' => [
      '0' => [
        'value' => "1534820567",
      ],
    ],
    'ko' => [
      '0' => [
        'value' => "1538580182",
      ],
    ],
  ],
  'changed' => [
    'en' => [
      '0' => [
        'value' => "1579198225",
      ],
    ],
    'ko' => [
      '0' => [
        'value' => "1579198206",
      ],
    ],
  ],
  'promote' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
    'ko' => [
      '0' => [
        'value' => "1",
      ],
    ],
  ],
  'sticky' => [
    'en' => [
      '0' => [
        'value' => "0",
      ],
    ],
    'ko' => [
      '0' => [
        'value' => "0",
      ],
    ],
  ],
  'default_langcode' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
    'ko' => [
      '0' => [
        'value' => "0",
      ],
    ],
  ],
  'revision_default' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
    'ko' => [
      '0' => [
        'value' => "1",
      ],
    ],
  ],
  'moderation_state' => [
    'en' => [
      '0' => [
        'value' => "published",
      ],
    ],
    'ko' => [
      '0' => [
        'value' => "published",
      ],
    ],
  ],
  'content_translation_source' => [
    'en' => [
      '0' => [
        'value' => "und",
      ],
    ],
    'ko' => [
      '0' => [
        'value' => "en",
      ],
    ],
  ],
  'content_translation_outdated' => [
    'en' => [
      '0' => [
        'value' => "0",
      ],
    ],
    'ko' => [
      '0' => [
        'value' => "0",
      ],
    ],
  ],
  'body' => [
    'en' => [
      '0' => [
        'value' => "<p>There's nothing like having your own supply of fresh herbs, readily available and close at hand to use while cooking. Whether you have a large garden or a small kitchen window sill, there's always enough room for something home grown.</p>

<h2>Outdoors</h2>

<h3>Mint</h3>

<p>Mint is a great plant to grow as it's hardy and can grow in almost any soil. Mint can grow wild, so keep it contained in a pot or it might spread and take over your whole garden.</p>

<h3>Sage</h3>

<p>Like mint, sage is another prolific growing plant and will take over your garden if you let it. Highly aromatic, the sage plant can be planted in a pot or flower bed in well drained soil. The best way to store the herb is to sun dry the leaves and store in a cool, dark cupboard in a sealed container.</p>

<h3>Rosemary</h3>

<p>Rosemary plants grow into lovely shrubs. Easily grown from cuttings, rosemary plants do not like freezing temperatures so keep pots or planted bushes near the home to shelter them from the cold. It grows well in pots as it likes dry soil, but can survive well in the ground too. If pruning rosemary to encourage it into a better shape, save the branches and hang them upside down to preserve the flavor and use in food.</p>

<h2>Indoors</h2>

<h3>Basil</h3>

<p>Perfect in sunny spot on a kitchen window sill. Basil is an annual plant, so will die off in the autumn, so it's a good idea to harvest it in the summer if you have an abundance and dry it. Picked basil stays fresh longer if it is placed in water (like fresh flowers). A great way to store basil is to make it into pesto!</p>

<h3>Chives</h3>

<p>A versatile herb, chives can grow well indoors. Ensure the plant is watered well, and gets plenty of light. Remember to regularly trim the chives. This prevents the flowers from developing and encourages new growth.</p>

<h3>Coriander (Cilantro)</h3>

<p>Coriander can grow indoors, but unlike the other herbs, it doesn't like full sun. If you have a south facing kitchen window, this isn't the place for it. Although not as thirsty as basil, coriander doesn't like dry soil so don't forget to water it! Cut coriander is best stored in the fridge.</p>
",
        'summary' => "",
        'format' => "basic_html",
      ],
    ],
    'ko' => [
      '0' => [
        'value' => "<p>There's nothing like having your own supply of fresh herbs, readily available and close at hand to use while cooking. Whether you have a large garden or a small kitchen window sill, there's always enough room for something home grown.</p>

<h2>Outdoors</h2>

<h3>Mint</h3>

<p>Mint is a great plant to grow as it's hardy and can grow in almost any soil. Mint can grow wild, so keep it contained in a pot or it might spread and take over your whole garden.</p>

<h3>Sage</h3>

<p>Like mint, sage is another prolific growing plant and will take over your garden if you let it. Highly aromatic, the sage plant can be planted in a pot or flower bed in well drained soil. The best way to store the herb is to sun dry the leaves and store in a cool, dark cupboard in a sealed container.</p>

<h3>Rosemary</h3>

<p>Rosemary plants grow into lovely shrubs. Easily grown from cuttings, rosemary plants do not like freezing temperatures so keep pots or planted bushes near the home to shelter them from the cold. It grows well in pots as it likes dry soil, but can survive well in the ground too. If pruning rosemary to encourage it into a better shape, save the branches and hang them upside down to preserve the flavor and use in food.</p>

<h2>Indoors</h2>

<h3>Basil</h3>

<p>Perfect in sunny spot on a kitchen window sill. Basil is an annual plant, so will die off in the autumn, so it's a good idea to harvest it in the summer if you have an abundance and dry it. Picked basil stays fresh longer if it is placed in water (like fresh flowers). A great way to store basil is to make it into pesto!</p>

<h3>Chives</h3>

<p>A versatile herb, chives can grow well indoors. Ensure the plant is watered well, and gets plenty of light. Remember to regularly trim the chives. This prevents the flowers from developing and encourages new growth.</p>

<h3>Coriander (Cilantro)</h3>

<p>Coriander can grow indoors, but unlike the other herbs, it doesn't like full sun. If you have a south facing kitchen window, this isn't the place for it. Although not as thirsty as basil, coriander doesn't like dry soil so don't forget to water it! Cut coriander is best stored in the fridge.</p>
",
        'summary' => "",
        'format' => "basic_html",
      ],
    ],
  ],
  'field_image' => [
    'en' => [
      '0' => [
        'target_id' => "2fb67a1f-039c-421f-887d-76b2263e65a9",
        'alt' => "Fresh cut herbs including mint, parsley, thyme and dill",
        'title' => "",
        'width' => "768",
        'height' => "512",
      ],
    ],
    'ko' => [
      '0' => [
        'target_id' => "2fb67a1f-039c-421f-887d-76b2263e65a9",
        'alt' => "Fresh cut herbs including mint, parsley, thyme and dill",
        'title' => "",
        'width' => "768",
        'height' => "512",
      ],
    ],
  ],
  'field_tags' => [
    'en' => [
      '0' => [
        'target_id' => "ca412fba-b2ef-4ac0-a115-d65ecd630be2",
      ],
      '1' => [
        'target_id' => "f8df7410-8f5b-433d-914c-82e139950ce0",
      ],
      '2' => [
        'target_id' => "076620a9-aa23-46c2-bd96-e0221d695a11",
      ],
    ],
    'ko' => [
      '0' => [
        'target_id' => "ca412fba-b2ef-4ac0-a115-d65ecd630be2",
      ],
      '1' => [
        'target_id' => "f8df7410-8f5b-433d-914c-82e139950ce0",
      ],
      '2' => [
        'target_id' => "076620a9-aa23-46c2-bd96-e0221d695a11",
      ],
    ],
  ],
];

$expectations['d1aee8f8-e868-496d-a8f7-5b9a8df2de7e'] = new CdfExpectations($data,
  [
    'nid',
    'vid',
    'revision_log',
    'revision_translation_affected',
    'path',
    'comment',
  ]);

$data = [
  'uuid' => [
    'en' => [
      '0' => [
        'value' => "3a56676e-97ee-486f-8692-40e1847950df",
      ],
    ],
  ],
  'preferred_langcode' => [
    'en' => [
      '0' => [
        'value' => "en",
      ],
    ],
  ],
  'preferred_admin_langcode' => [],
  'name' => [
    'en' => [
      '0' => [
        'value' => "umami_admin",
      ],
    ],
  ],
  'pass' => [
    'en' => [
      '0' => [
        'value' => '$S$EIr5b5uzjWug/lFxctuBFAw9IsoH98/wzdcsAqM4jfhXsM68unAN',
        'pre_hashed' => "1",
      ],
    ],
  ],
  'mail' => [
    'en' => [
      '0' => [
        'value' => "foo@bar.com",
      ],
    ],
  ],
  'timezone' => [
    'en' => [
      '0' => [
        'value' => "America/Chicago",
      ],
    ],
  ],
  'status' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
  ],
  'created' => [
    'en' => [
      '0' => [
        'value' => "1534820467",
      ],
    ],
  ],
  'changed' => [
    'en' => [
      '0' => [
        'value' => "1553118295",
      ],
    ],
  ],
  'access' => [
    'en' => [
      '0' => [
        'value' => "1553118265",
      ],
    ],
  ],
  'login' => [
    'en' => [
      '0' => [
        'value' => "1549946954",
      ],
    ],
  ],
  'init' => [
    'en' => [
      '0' => [
        'value' => "foo@bar.com",
      ],
    ],
  ],
  'roles' => [
    'en' => [
      '0' => [
        'target_id' => "b25ceac1-c6e6-4c82-8c61-8fdd797a9522",
      ],
    ],
  ],
  'default_langcode' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
  ],
  'content_translation_source' => [
    'en' => [
      '0' => [
        'value' => "und",
      ],
    ],
  ],
  'content_translation_outdated' => [
    'en' => [
      '0' => [
        'value' => "0",
      ],
    ],
  ],
  'content_translation_uid' => [
    'en' => [],
  ],
  'content_translation_status' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
  ],
  'content_translation_created' => [],
  'user_picture' => [
    'en' => [
      '0' => [
        'target_id' => "27b3075f-b9a8-4bf6-989f-ac227ce594f2",
        'alt' => "",
        'title' => "",
        'width' => "100",
        'height' => "100",
      ],
    ],
  ],
];

$expectations['3a56676e-97ee-486f-8692-40e1847950df'] = new CdfExpectations($data, []);
$data = [
  'uuid' => [
    'en' => [
      '0' => [
        'value' => "27b3075f-b9a8-4bf6-989f-ac227ce594f2",
      ],
    ],
  ],
  'uid' => [
    'en' => [
      '0' => [
        'target_id' => "3a56676e-97ee-486f-8692-40e1847950df",
      ],
    ],
  ],
  'filename' => [
    'en' => [
      '0' => [
        'value' => "profile.gif",
      ],
    ],
  ],
  'uri' => [
    'en' => [
      '0' => [
        'value' => "public://pictures/2019-03/profile.gif",
      ],
    ],
  ],
  'filemime' => [
    'en' => [
      '0' => [
        'value' => "image/gif",
      ],
    ],
  ],
  'filesize' => [
    'en' => [
      '0' => [
        'value' => "1825",
      ],
    ],
  ],
  'status' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
  ],
  'created' => [
    'en' => [
      '0' => [
        'value' => "1553118254",
      ],
    ],
  ],
  'changed' => [
    'en' => [
      '0' => [
        'value' => "1553118265",
      ],
    ],
  ],
];

$expectations['27b3075f-b9a8-4bf6-989f-ac227ce594f2'] = new CdfExpectations($data, []);
$data = [
  'uuid' => [
    'en' => [
      '0' => [
        'value' => "79b2f512-6e56-4fe0-94eb-67898d19f741",
      ],
    ],
  ],
  'preferred_langcode' => [
    'en' => [
      '0' => [
        'value' => "en",
      ],
    ],
  ],
  'preferred_admin_langcode' => [],
  'name' => [
    'en' => [
      '0' => [
        'value' => "Holly Foat",
      ],
    ],
  ],
  'pass' => [],
  'mail' => [
    'en' => [
      '0' => [
        'value' => "holly.foat@example.com",
      ],
    ],
  ],
  'timezone' => [
    'en' => [
      '0' => [
        'value' => "",
      ],
    ],
  ],
  'status' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
  ],
  'created' => [
    'en' => [
      '0' => [
        'value' => "1534820567",
      ],
    ],
  ],
  'changed' => [
    'en' => [
      '0' => [
        'value' => "1534820567",
      ],
    ],
  ],
  'access' => [
    'en' => [
      '0' => [
        'value' => "0",
      ],
    ],
  ],
  'login' => [
    'en' => [
      '0' => [
        'value' => "0",
      ],
    ],
  ],
  'init' => [],
  'roles' => [
    'en' => [
      '0' => [
        'target_id' => "d4676653-5597-415e-a6d1-5d4050b8a4de",
      ],
    ],
  ],
  'default_langcode' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
  ],
  'content_translation_source' => [
    'en' => [
      '0' => [
        'value' => "und",
      ],
    ],
  ],
  'content_translation_outdated' => [
    'en' => [
      '0' => [
        'value' => "0",
      ],
    ],
  ],
  'content_translation_uid' => [
    'en' => [],
  ],
  'content_translation_status' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
  ],
  'content_translation_created' => [],
  'user_picture' => [
    'en' => [],
  ],
];

$expectations['79b2f512-6e56-4fe0-94eb-67898d19f741'] = new CdfExpectations($data, []);
$data = [
  'uuid' => [
    'en' => [
      '0' => [
        'value' => "2fb67a1f-039c-421f-887d-76b2263e65a9",
      ],
    ],
  ],
  'uid' => [
    'en' => [],
  ],
  'filename' => [
    'en' => [
      '0' => [
        'value' => "home-grown-herbs.jpg",
      ],
    ],
  ],
  'uri' => [
    'en' => [
      '0' => [
        'value' => "public://home-grown-herbs.jpg",
      ],
    ],
  ],
  'filemime' => [
    'en' => [
      '0' => [
        'value' => "image/jpeg",
      ],
    ],
  ],
  'filesize' => [
    'en' => [
      '0' => [
        'value' => "114984",
      ],
    ],
  ],
  'status' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
  ],
  'created' => [
    'en' => [
      '0' => [
        'value' => "1534820567",
      ],
    ],
  ],
  'changed' => [
    'en' => [
      '0' => [
        'value' => "1534820567",
      ],
    ],
  ],
];

$expectations['2fb67a1f-039c-421f-887d-76b2263e65a9'] = new CdfExpectations($data, []);
$data = [
  'uuid' => [
    'en' => [
      '0' => [
        'value' => "ca412fba-b2ef-4ac0-a115-d65ecd630be2",
      ],
    ],
  ],
  'vid' => [
    'en' => [
      '0' => [
        'target_id' => "82b789b8-ccfb-4aed-a728-027ae3c3d412",
      ],
    ],
  ],
  'status' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
  ],
  'name' => [
    'en' => [
      '0' => [
        'value' => "Grow your own",
      ],
    ],
  ],
  'description' => [
    'en' => [
      '0' => [
        'value' => "",
        'format' => "",
      ],
    ],
  ],
  'weight' => [
    'en' => [
      '0' => [
        'value' => "0",
      ],
    ],
  ],
  'parent' => [],
  'changed' => [
    'en' => [
      '0' => [
        'value' => "1534820567",
      ],
    ],
  ],
  'default_langcode' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
  ],
];

$expectations['ca412fba-b2ef-4ac0-a115-d65ecd630be2'] = new CdfExpectations($data, []);
$data = [
  'uuid' => [
    'en' => [
      '0' => [
        'value' => "f8df7410-8f5b-433d-914c-82e139950ce0",
      ],
    ],
  ],
  'vid' => [
    'en' => [
      '0' => [
        'target_id' => "82b789b8-ccfb-4aed-a728-027ae3c3d412",
      ],
    ],
  ],
  'status' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
  ],
  'name' => [
    'en' => [
      '0' => [
        'value' => "Seasonal",
      ],
    ],
  ],
  'description' => [
    'en' => [
      '0' => [
        'value' => "",
        'format' => "",
      ],
    ],
  ],
  'weight' => [
    'en' => [
      '0' => [
        'value' => "0",
      ],
    ],
  ],
  'parent' => [],
  'changed' => [
    'en' => [
      '0' => [
        'value' => "1534820567",
      ],
    ],
  ],
  'default_langcode' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
  ],
];

$expectations['f8df7410-8f5b-433d-914c-82e139950ce0'] = new CdfExpectations($data, []);
$data = [
  'uuid' => [
    'en' => [
      '0' => [
        'value' => "076620a9-aa23-46c2-bd96-e0221d695a11",
      ],
    ],
  ],
  'vid' => [
    'en' => [
      '0' => [
        'target_id' => "82b789b8-ccfb-4aed-a728-027ae3c3d412",
      ],
    ],
  ],
  'status' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
  ],
  'name' => [
    'en' => [
      '0' => [
        'value' => "Herbs",
      ],
    ],
  ],
  'description' => [
    'en' => [
      '0' => [
        'value' => "",
        'format' => "",
      ],
    ],
  ],
  'weight' => [
    'en' => [
      '0' => [
        'value' => "0",
      ],
    ],
  ],
  'parent' => [],
  'changed' => [
    'en' => [
      '0' => [
        'value' => "1534820567",
      ],
    ],
  ],
  'default_langcode' => [
    'en' => [
      '0' => [
        'value' => "1",
      ],
    ],
  ],
];

$expectations['076620a9-aa23-46c2-bd96-e0221d695a11'] = new CdfExpectations($data, []);

return $expectations;
