<?php

namespace Drupal\acquia_contenthub\Libs\ServiceQueue;

/**
 * Defines constants for service queue entity actions.
 *
 * This class centralizes the action constants used throughout the Content Hub
 * service queue processing system for consistent action identification.
 *
 * @package Drupal\acquia_contenthub\Libs\ServiceQueue
 */
final class ServiceQueueEntityActions {

  /**
   * Action constant for entity deletion.
   *
   * Used when an entity needs to be deleted from the local site.
   */
  public const DELETE = 'entity_delete';

  /**
   * Action constant for entity update.
   *
   * Used when an existing entity needs to be updated with new data.
   */
  public const UPDATE = 'entity_update';

  /**
   * Action constant for entity creation.
   *
   * Used when a new entity needs to be created on the local site.
   */
  public const CREATE = 'entity_create';

}
