<?php

namespace Drupal\acquia_contenthub_publisher\Libs;

/**
 * Defines export settings.
 */
interface ExportSettingsInterface {

  /**
   * Toggles manual export mode.
   *
   * @param bool $enabled
   *   False by default. If set to true, manual export mode will be enabled.
   */
  public function toggleManualExportMode(bool $enabled): void;

  /**
   * Checks if manual export mode enabled.
   *
   * @return bool
   *   TRUE if the manual export mode is enabled.
   */
  public function isManualExportModeEnabled(): bool;

  /**
   * Updates propagate Entity Deletion flag.
   *
   * @param bool $enabled
   *   False by default. If set to true, entity deletion propagation will stop.
   */
  public function updatePropagateEntityDeletionFlag(bool $enabled): void;

  /**
   * Checks if propagation of entity deletion is disabled/enabled.
   *
   * @return bool
   *   TRUE if propagation of entity deletion is disabled.
   */
  public function isEntityDeletionPropagationDisabled(): bool;

}
