<?php

namespace Acquia\ContentHubClient\test\MetaData;

use Acquia\ContentHubClient\MetaData\ClientMetaData;
use PHPUnit\Framework\TestCase;

/**
 * @coversDefaultClass \Acquia\ContentHubClient\MetaData\ClientMetaData
 *
 * @package Acquia\ContentHubClient\test
 */
class ClientMetaDataTest extends TestCase {

  /**
   * Test metadata.
   *
   * @var array
   */
  protected array $metadata = [
    'client_type' => 'drupal',
    'is_publisher' => TRUE,
    'is_subscriber' => FALSE,
    'webhook_version' => '2.0',
    'syndication_strategy' => 'push',
    'config' => [
      'valid_ssl' => TRUE,
      'drupal_version' => '10.1.1',
      'ch_version' => '3.3.0',
    ],
  ];

  /**
   * SUT.
   *
   * @var \Acquia\ContentHubClient\MetaData\ClientMetaData
   */
  protected ClientMetaData $sut;

  /**
   * Tests toArray method.
   *
   * @covers ::toArray
   */
  public function testGetMetaData(): void {
    $this->sut = new ClientMetaData($this->metadata['client_type'], $this->metadata['is_publisher'], $this->metadata['is_subscriber'], $this->metadata['webhook_version'], $this->metadata['config'], $this->metadata['syndication_strategy']);
    $client_metadata = $this->sut->toArray();
    $this->assertEquals($this->metadata, $client_metadata);
  }

  /**
   * Tests fromArray method.
   *
   * @covers ::fromArray
   */
  public function testMetaDataCreationFromArray(): void {
    $this->sut = ClientMetaData::fromArray($this->metadata);
    $client_metadata = $this->sut->toArray();
    $this->assertEquals($this->metadata, $client_metadata);
  }

  /**
   * Tests fromArray method with required params only.
   *
   * @covers ::fromArray
   */
  public function testMetaDataCreationFromArrayWithRequiredParamsonly(): void {
    $this->sut = ClientMetaData::fromArray([
      'client_type' => $this->metadata['client_type'],
      'is_publisher' => $this->metadata['is_publisher'],
      'is_subscriber' => $this->metadata['is_subscriber'],
    ]);
    $client_metadata = $this->sut->toArray();
    $this->assertEquals([
      'client_type' => 'drupal',
      'is_publisher' => TRUE,
      'is_subscriber' => FALSE,
      'webhook_version' => '2.0',
      'config' => [],
      'syndication_strategy' => 'push',
    ], $client_metadata);
  }

}
